/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class IndexSamplingIntegrationTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final Label label = Label.label((String)"Person");
    private final String property = "name";
    private final long nodes = 1000L;
    private final String[] names = new String[]{"Neo4j", "Neo", "Graph", "Apa"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSampleNotUniqueIndex() throws Throwable {
        GraphDatabaseService db = null;
        long deletedNodes = 0L;
        try {
            IndexDefinition indexDefinition;
            db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.graphDbDir());
            try (org.neo4j.graphdb.Transaction tx = db.beginTx();){
                indexDefinition = db.schema().indexFor(this.label).on("name").create();
                tx.success();
            }
            tx = db.beginTx();
            var6_4 = null;
            try {
                db.schema().awaitIndexOnline(indexDefinition, 10L, TimeUnit.SECONDS);
                tx.success();
            }
            catch (Throwable throwable) {
                var6_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var6_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var6_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            tx = db.beginTx();
            var6_4 = null;
            try {
                int i = 0;
                while ((long)i < 1000L) {
                    db.createNode(new Label[]{this.label}).setProperty("name", (Object)this.names[i % this.names.length]);
                    tx.success();
                    ++i;
                }
            }
            catch (Throwable i) {
                var6_4 = i;
                throw i;
            }
            finally {
                if (tx != null) {
                    if (var6_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable i) {
                            var6_4.addSuppressed(i);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            tx = db.beginTx();
            var6_4 = null;
            try {
                int i = 0;
                while ((long)i < 100L) {
                    try (ResourceIterator nodes = db.findNodes(this.label, "name", (Object)this.names[i % this.names.length]);){
                        ((Node)nodes.next()).delete();
                    }
                    ++deletedNodes;
                    tx.success();
                    ++i;
                }
            }
            catch (Throwable throwable) {
                var6_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var6_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var6_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
        this.triggerIndexResamplingOnNextStartup();
        Register.DoubleLongRegister register = this.fetchIndexSamplingValues(db);
        Assert.assertEquals((long)this.names.length, (long)register.readFirst());
        Assert.assertThat((Object)register.readSecond(), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1000L - deletedNodes)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1000L))));
        Register.DoubleLongRegister indexSizeRegister = this.fetchIndexSizeValues(db);
        Assert.assertEquals((long)0L, (long)indexSizeRegister.readFirst());
        Assert.assertEquals((long)(1000L - deletedNodes), (long)indexSizeRegister.readSecond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSampleUniqueIndex() throws Throwable {
        GraphDatabaseService db = null;
        long deletedNodes = 0L;
        try {
            db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.graphDbDir());
            try (org.neo4j.graphdb.Transaction tx = db.beginTx();){
                db.schema().constraintFor(this.label).assertPropertyIsUnique("name").create();
                tx.success();
            }
            tx = db.beginTx();
            var5_4 = null;
            try {
                int i = 0;
                while ((long)i < 1000L) {
                    db.createNode(new Label[]{this.label}).setProperty("name", (Object)("" + i));
                    tx.success();
                    ++i;
                }
            }
            catch (Throwable i) {
                var5_4 = i;
                throw i;
            }
            finally {
                if (tx != null) {
                    if (var5_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable i) {
                            var5_4.addSuppressed(i);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            tx = db.beginTx();
            var5_4 = null;
            try {
                int i = 0;
                while ((long)i < 1000L) {
                    if (i % 10 == 0) {
                        ++deletedNodes;
                        db.findNode(this.label, "name", (Object)("" + i)).delete();
                        tx.success();
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var5_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
        this.triggerIndexResamplingOnNextStartup();
        Register.DoubleLongRegister indexSampleRegister = this.fetchIndexSamplingValues(db);
        Assert.assertEquals((long)(1000L - deletedNodes), (long)indexSampleRegister.readFirst());
        Assert.assertEquals((long)(1000L - deletedNodes), (long)indexSampleRegister.readSecond());
        Register.DoubleLongRegister indexSizeRegister = this.fetchIndexSizeValues(db);
        Assert.assertEquals((long)0L, (long)indexSizeRegister.readFirst());
        Assert.assertEquals((long)(1000L - deletedNodes), (long)indexSizeRegister.readSecond());
    }

    private IndexReference indexId(Transaction tx) {
        int labelId = tx.tokenRead().nodeLabel(this.label.name());
        int propertyKeyId = tx.tokenRead().propertyKey("name");
        return tx.schemaRead().index(labelId, new int[]{propertyKeyId});
    }

    /*
     * Loose catch block
     */
    private Register.DoubleLongRegister fetchIndexSamplingValues(GraphDatabaseService db) throws IndexNotFoundKernelException, TransactionFailureException {
        try {
            db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.graphDbDir());
            GraphDatabaseAPI api = (GraphDatabaseAPI)db;
            try (Transaction tx = ((Kernel)api.getDependencyResolver().resolveDependency(Kernel.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);){
                Register.DoubleLongRegister doubleLongRegister = tx.schemaRead().indexSample(this.indexId(tx), Registers.newDoubleLongRegister());
                return doubleLongRegister;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    /*
     * Loose catch block
     */
    private Register.DoubleLongRegister fetchIndexSizeValues(GraphDatabaseService db) throws IndexNotFoundKernelException, TransactionFailureException {
        try {
            db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.graphDbDir());
            GraphDatabaseAPI api = (GraphDatabaseAPI)db;
            try (Transaction tx = ((Kernel)api.getDependencyResolver().resolveDependency(Kernel.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);){
                Register.DoubleLongRegister doubleLongRegister = tx.schemaRead().indexUpdatesAndSize(this.indexId(tx), Registers.newDoubleLongRegister());
                return doubleLongRegister;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    private void triggerIndexResamplingOnNextStartup() {
        String baseName = "neostore.counts.db";
        FileUtils.deleteFile((File)new File(this.testDirectory.graphDbDir(), baseName + ".a"));
        FileUtils.deleteFile((File)new File(this.testDirectory.graphDbDir(), baseName + ".b"));
    }
}

