/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.io.IOException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.LuceneDataSource;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestIndexDelectionFs {
    private static GraphDatabaseAPI db;

    @BeforeClass
    public static void doBefore() throws IOException {
        File directory = new File("target/test-data/deletion");
        FileUtils.deleteRecursively((File)directory);
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabase(directory);
    }

    @AfterClass
    public static void doAfter() {
        db.shutdown();
    }

    @Test
    public void indexDeleteShouldDeleteDirectory() {
        Index index;
        String indexName = "index";
        String otherIndexName = "other-index";
        File indexBaseDir = new File(db.getStoreDir(), "index");
        File pathToLuceneIndex = LuceneDataSource.getFileDirectory((File)indexBaseDir, (IndexIdentifier)new IndexIdentifier(IndexEntityType.Node, indexName));
        File pathToOtherLuceneIndex = LuceneDataSource.getFileDirectory((File)indexBaseDir, (IndexIdentifier)new IndexIdentifier(IndexEntityType.Node, otherIndexName));
        try (Transaction tx = db.beginTx();){
            index = db.index().forNodes(indexName);
            Index otherIndex = db.index().forNodes(otherIndexName);
            Node node = db.createNode();
            index.add((PropertyContainer)node, "someKey", (Object)"someValue");
            otherIndex.add((PropertyContainer)node, "someKey", (Object)"someValue");
            tx.success();
        }
        Assert.assertTrue((boolean)pathToLuceneIndex.exists());
        Assert.assertTrue((boolean)pathToOtherLuceneIndex.exists());
        tx = db.beginTx();
        var8_7 = null;
        try {
            index.delete();
            Assert.assertTrue((boolean)pathToLuceneIndex.exists());
            Assert.assertTrue((boolean)pathToOtherLuceneIndex.exists());
            tx.success();
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertFalse((boolean)pathToLuceneIndex.exists());
        Assert.assertTrue((boolean)pathToOtherLuceneIndex.exists());
    }
}

