/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.event;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.event.TestTransactionEvents;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class TestTransactionEventsWithIndexes
extends TestTransactionEvents {
    @Test
    public void nodeCanBeExplicitIndexedInBeforeCommit() {
        Node node2;
        Index index;
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            index = db.index().forNodes("index");
            tx.success();
        }
        db.registerTransactionEventHandler((TransactionEventHandler)new TransactionEventHandler<Object>(){

            public Object beforeCommit(TransactionData data) {
                Iterator nodes = data.createdNodes().iterator();
                if (nodes.hasNext()) {
                    Node node = (Node)nodes.next();
                    index.add((PropertyContainer)node, "key", (Object)"value");
                }
                return null;
            }

            public void afterCommit(TransactionData data, Object state) {
            }

            public void afterRollback(TransactionData data, Object state) {
            }
        });
        tx = db.beginTx();
        var4_3 = null;
        try {
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            node2 = db.createNode();
            node2.setProperty("random", (Object)42);
            tx.success();
        }
        catch (Throwable node2) {
            var4_3 = node2;
            throw node2;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node2) {
                        var4_3.addSuppressed(node2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        var4_3 = null;
        try (Transaction ignore = db.beginTx();){
            node2 = (Node)Iterables.single((Iterable)index.get("key", (Object)"value"));
            Assert.assertThat((Object)node2.getProperty("random"), (Matcher)Matchers.is((Object)42));
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }
}

