/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrencytest;

import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.test.rule.concurrent.ThreadingRule;
import org.neo4j.values.storable.Values;

public class ConstraintIndexConcurrencyTest {
    @Rule
    public final DatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public final ThreadingRule threads = new ThreadingRule();

    @Test
    public void shouldNotAllowConcurrentViolationOfConstraint() throws Exception {
        GraphDatabaseAPI graphDb = this.db.getGraphDatabaseAPI();
        Supplier<KernelTransaction> ktxSupplier = () -> ((ThreadToStatementContextBridge)graphDb.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
        Label label = Label.label((String)"Foo");
        String propertyKey = "bar";
        String conflictingValue = "baz";
        try (Transaction tx = graphDb.beginTx();){
            graphDb.schema().constraintFor(label).assertPropertyIsUnique(propertyKey).create();
            tx.success();
        }
        tx = graphDb.beginTx();
        var7_7 = null;
        try {
            KernelTransaction ktx = ktxSupplier.get();
            int labelId = ktx.tokenRead().nodeLabel(label.name());
            int propertyKeyId = ktx.tokenRead().propertyKey(propertyKey);
            IndexDescriptor index = TestIndexDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyKeyId});
            Read read = ktx.dataRead();
            try (NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor();){
                read.nodeIndexSeek(ktx.schemaRead().index(labelId, new int[]{propertyKeyId}), cursor, IndexOrder.NONE, new IndexQuery[]{IndexQuery.exact((int)index.schema().getPropertyId(), (Object)"The value is irrelevant, we just want to perform some sort of lookup against this index")});
            }
            this.threads.execute(db -> {
                try (Transaction transaction = db.beginTx();){
                    db.createNode(new Label[]{label}).setProperty(propertyKey, (Object)conflictingValue);
                    transaction.success();
                }
                return null;
            }, (Object)graphDb).get();
            long node = ktx.dataWrite().nodeCreate();
            ktx.dataWrite().nodeAddLabel(node, labelId);
            try {
                ktx.dataWrite().nodeSetProperty(node, propertyKeyId, Values.of((Object)conflictingValue));
                Assert.fail((String)"exception expected");
            }
            catch (UniquePropertyValueValidationException e) {
                Assert.assertEquals((Object)ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyKeyId}), (Object)e.constraint());
                IndexEntryConflictException conflict = (IndexEntryConflictException)((Object)Iterators.single(e.conflicts().iterator()));
                Assert.assertEquals((Object)Values.stringValue((String)conflictingValue), (Object)conflict.getSinglePropertyValue());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

