/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.SpatialMocks;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public class IndexingAcceptanceTest {
    public static final String LONG_STRING = "a long string that has to be stored in dynamic records";
    @ClassRule
    public static ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    @Rule
    public final TestName testName = new TestName();
    private Label LABEL1;
    private Label LABEL2;
    private Label LABEL3;

    @Test
    public void shouldInterpretPropertyAsChangedEvenIfPropertyMovesFromOneRecordToAnother() {
        Node myNode;
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        long smallValue = 10L;
        long bigValue = 0x4000000000000000L;
        try (Transaction tx = beansAPI.beginTx();){
            myNode = beansAPI.createNode(new Label[]{this.LABEL1});
            myNode.setProperty("pad0", (Object)true);
            myNode.setProperty("pad1", (Object)true);
            myNode.setProperty("pad2", (Object)true);
            myNode.setProperty("key", (Object)smallValue);
            tx.success();
        }
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL1, (String[])new String[]{"key"});
        tx = beansAPI.beginTx();
        var8_5 = null;
        try {
            myNode.setProperty("key", (Object)bigValue);
            tx.success();
        }
        catch (Throwable throwable) {
            var8_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"key", (Object)bigValue, (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{myNode}));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"key", (Object)smallValue, (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
    }

    @Test
    public void shouldUseDynamicPropertiesToIndexANodeWhenAddedAlongsideExistingPropertiesInASeparateTransaction() {
        Node myNode;
        long id;
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        try (Transaction tx = beansAPI.beginTx();){
            Node myNode2 = beansAPI.createNode();
            id = myNode2.getId();
            myNode2.setProperty("key0", (Object)true);
            myNode2.setProperty("key1", (Object)true);
            tx.success();
        }
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL1, (String[])new String[]{"key2"});
        try (Transaction tx = beansAPI.beginTx();){
            myNode = beansAPI.getNodeById(id);
            myNode.addLabel(this.LABEL1);
            myNode.setProperty("key2", (Object)LONG_STRING);
            myNode.setProperty("key3", (Object)LONG_STRING);
            tx.success();
        }
        Assert.assertThat((Object)myNode, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, (Matcher)Neo4jMatchers.hasProperty((String)"key2").withValue((Object)LONG_STRING)));
        Assert.assertThat((Object)myNode, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, (Matcher)Neo4jMatchers.hasProperty((String)"key3").withValue((Object)LONG_STRING)));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"key2", (Object)LONG_STRING, (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{myNode}));
    }

    @Test
    public void searchingForNodeByPropertyShouldWorkWithoutIndex() {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Node myNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1);
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"name", (Object)"Hawking", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{myNode}));
    }

    @Test
    public void searchingUsesIndexWhenItExists() {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Node myNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1);
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL1, (String[])new String[]{"name"});
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"name", (Object)"Hawking", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{myNode}));
    }

    @Test
    public void shouldCorrectlyUpdateIndexesWhenChangingLabelsAndPropertyAtTheSameTime() {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Node myNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1, this.LABEL2);
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL1, (String[])new String[]{"name"});
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL2, (String[])new String[]{"name"});
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL3, (String[])new String[]{"name"});
        try (Transaction tx = beansAPI.beginTx();){
            myNode.removeLabel(this.LABEL1);
            myNode.addLabel(this.LABEL3);
            myNode.setProperty("name", (Object)"Einstein");
            tx.success();
        }
        Assert.assertThat((Object)myNode, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)"Einstein")));
        Assert.assertThat(this.labels(myNode), (Matcher)Neo4jMatchers.containsOnly((Object[])new Label[]{this.LABEL2, this.LABEL3}));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"name", (Object)"Hawking", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"name", (Object)"Einstein", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL2, (String)"name", (Object)"Hawking", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL2, (String)"name", (Object)"Einstein", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{myNode}));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL3, (String)"name", (Object)"Hawking", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL3, (String)"name", (Object)"Einstein", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{myNode}));
    }

    @Test
    public void shouldCorrectlyUpdateIndexesWhenChangingLabelsAndPropertyMultipleTimesAllAtOnce() {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Node myNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Hawking"}), this.LABEL1, this.LABEL2);
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL1, (String[])new String[]{"name"});
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL2, (String[])new String[]{"name"});
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL3, (String[])new String[]{"name"});
        try (Transaction tx = beansAPI.beginTx();){
            myNode.addLabel(this.LABEL3);
            myNode.setProperty("name", (Object)"Einstein");
            myNode.removeLabel(this.LABEL1);
            myNode.setProperty("name", (Object)"Feynman");
            tx.success();
        }
        Assert.assertThat((Object)myNode, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)beansAPI, (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)"Feynman")));
        Assert.assertThat(this.labels(myNode), (Matcher)Neo4jMatchers.containsOnly((Object[])new Label[]{this.LABEL2, this.LABEL3}));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"name", (Object)"Hawking", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"name", (Object)"Einstein", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"name", (Object)"Feynman", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL2, (String)"name", (Object)"Hawking", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL2, (String)"name", (Object)"Einstein", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL2, (String)"name", (Object)"Feynman", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{myNode}));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL3, (String)"name", (Object)"Hawking", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL3, (String)"name", (Object)"Einstein", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL3, (String)"name", (Object)"Feynman", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{myNode}));
    }

    @Test
    public void searchingByLabelAndPropertyReturnsEmptyWhenMissingLabelOrProperty() {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"name", (Object)"Hawking", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.isEmpty());
    }

    @Test
    public void shouldSeeIndexUpdatesWhenQueryingOutsideTransaction() {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL1, (String[])new String[]{"name"});
        Node firstNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"name", (Object)"Mattias", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{firstNode}));
        Node secondNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Taylor"}), this.LABEL1);
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.LABEL1, (String)"name", (Object)"Taylor", (GraphDatabaseService)beansAPI), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{secondNode}));
    }

    @Test
    public void createdNodeShouldShowUpWithinTransaction() {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL1, (String[])new String[]{"name"});
        Transaction tx = beansAPI.beginTx();
        Node firstNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        long sizeBeforeDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        firstNode.delete();
        long sizeAfterDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        tx.close();
        Assert.assertThat((Object)sizeBeforeDelete, (Matcher)IsEqual.equalTo((Object)1L));
        Assert.assertThat((Object)sizeAfterDelete, (Matcher)IsEqual.equalTo((Object)0L));
    }

    @Test
    public void deletedNodeShouldShowUpWithinTransaction() {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL1, (String[])new String[]{"name"});
        Node firstNode = this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        Transaction tx = beansAPI.beginTx();
        long sizeBeforeDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        firstNode.delete();
        long sizeAfterDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        tx.close();
        Assert.assertThat((Object)sizeBeforeDelete, (Matcher)IsEqual.equalTo((Object)1L));
        Assert.assertThat((Object)sizeAfterDelete, (Matcher)IsEqual.equalTo((Object)0L));
    }

    @Test
    public void createdNodeShouldShowUpInIndexQuery() {
        GraphDatabaseAPI beansAPI = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)beansAPI, (Label)this.LABEL1, (String[])new String[]{"name"});
        this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        Transaction tx = beansAPI.beginTx();
        long sizeBeforeDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        this.createNode((GraphDatabaseService)beansAPI, MapUtil.map((Object[])new Object[]{"name", "Mattias"}), this.LABEL1);
        long sizeAfterDelete = Iterators.count((Iterator)beansAPI.findNodes(this.LABEL1, "name", (Object)"Mattias"));
        tx.close();
        Assert.assertThat((Object)sizeBeforeDelete, (Matcher)IsEqual.equalTo((Object)1L));
        Assert.assertThat((Object)sizeAfterDelete, (Matcher)IsEqual.equalTo((Object)2L));
    }

    @Test
    public void shouldBeAbleToQuerySupportedPropertyTypes() {
        String property = "name";
        GraphDatabaseAPI db = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)db, (Label)this.LABEL1, (String[])new String[]{property});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, "A String");
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, true);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, false);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, (byte)56);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, Character.valueOf('z'));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, (short)12);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, 12);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, 12L);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, Float.valueOf(12.0f));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, 12.0);
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, SpatialMocks.mockPoint((double)12.3, (double)45.6, (CRS)SpatialMocks.mockWGS84()));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, SpatialMocks.mockPoint((double)123.0, (double)456.0, (CRS)SpatialMocks.mockCartesian()));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, SpatialMocks.mockPoint((double)12.3, (double)45.6, (double)100.0, (CRS)SpatialMocks.mockWGS84_3D()));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, SpatialMocks.mockPoint((double)123.0, (double)456.0, (double)789.0, (CRS)SpatialMocks.mockCartesian_3D()));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6}));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{123.0, 456.0}));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.3, 45.6, 100.0}));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{123.0, 456.0, 789.0}));
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new String[]{"A String"});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new boolean[]{true});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Boolean[]{false});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new byte[]{56});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Byte[]{(byte)57});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new char[]{'a'});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Character[]{Character.valueOf('b')});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new short[]{12});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Short[]{(short)13});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new int[]{14});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Integer[]{15});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new long[]{16L});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Long[]{17L});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new float[]{18.0f});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Float[]{Float.valueOf(19.0f)});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new double[]{20.0});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Double[]{21.0});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Point[]{SpatialMocks.mockPoint((double)12.3, (double)45.6, (CRS)SpatialMocks.mockWGS84())});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Point[]{SpatialMocks.mockPoint((double)123.0, (double)456.0, (CRS)SpatialMocks.mockCartesian())});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Point[]{SpatialMocks.mockPoint((double)12.3, (double)45.6, (double)100.0, (CRS)SpatialMocks.mockWGS84_3D())});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new Point[]{SpatialMocks.mockPoint((double)123.0, (double)456.0, (double)789.0, (CRS)SpatialMocks.mockCartesian_3D())});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{12.3, 45.6})});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian, (double[])new double[]{123.0, 456.0})});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84_3D, (double[])new double[]{12.3, 45.6, 100.0})});
        this.assertCanCreateAndFind((GraphDatabaseService)db, this.LABEL1, property, new PointValue[]{Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.Cartesian_3D, (double[])new double[]{123.0, 456.0, 789.0})});
    }

    @Test
    public void shouldRetrieveMultipleNodesWithSameValueFromIndex() {
        Node node2;
        Node node1;
        GraphDatabaseAPI graph = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)graph, (Label)this.LABEL1, (String[])new String[]{"name"});
        try (Transaction tx = graph.beginTx();){
            node1 = graph.createNode(new Label[]{this.LABEL1});
            node1.setProperty("name", (Object)"Stefan");
            node2 = graph.createNode(new Label[]{this.LABEL1});
            node2.setProperty("name", (Object)"Stefan");
            tx.success();
        }
        tx = graph.beginTx();
        var5_3 = null;
        try {
            ResourceIterator result = graph.findNodes(this.LABEL1, "name", (Object)"Stefan");
            Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node2}), (Object)Iterators.asSet((Iterator)result));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldThrowWhenMultipleResultsForSingleNode() {
        GraphDatabaseAPI graph = dbRule.getGraphDatabaseAPI();
        Neo4jMatchers.createIndex((GraphDatabaseService)graph, (Label)this.LABEL1, (String[])new String[]{"name"});
        try (Transaction tx = graph.beginTx();){
            Node node1 = graph.createNode(new Label[]{this.LABEL1});
            node1.setProperty("name", (Object)"Stefan");
            Node node2 = graph.createNode(new Label[]{this.LABEL1});
            node2.setProperty("name", (Object)"Stefan");
            tx.success();
        }
        try {
            tx = graph.beginTx();
            var5_4 = null;
            try {
                graph.findNode(this.LABEL1, "name", (Object)"Stefan");
                Assert.fail((String)"Expected MultipleFoundException but got none");
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var5_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (MultipleFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)IsEqual.equalTo((Object)String.format("Found multiple nodes with label: '%s', property name: 'name' and property value: 'Stefan' while only one was expected.", this.LABEL1)));
        }
    }

    @Test
    public void shouldAddIndexedPropertyToNodeWithDynamicLabels() {
        long nodeId;
        int indexesCount = 20;
        String labelPrefix = "foo";
        String propertyKeyPrefix = "bar";
        String propertyValuePrefix = "baz";
        GraphDatabaseAPI db = dbRule.getGraphDatabaseAPI();
        for (int i = 0; i < indexesCount; ++i) {
            Neo4jMatchers.createIndexNoWait((GraphDatabaseService)db, (Label)Label.label((String)(labelPrefix + i)), (String[])new String[]{propertyKeyPrefix + i});
        }
        Neo4jMatchers.waitForIndexes((GraphDatabaseService)db);
        try (Transaction tx = db.beginTx();){
            nodeId = db.createNode().getId();
            tx.success();
        }
        tx = db.beginTx();
        var9_9 = null;
        try {
            Node node = db.getNodeById(nodeId);
            for (int i = 0; i < indexesCount; ++i) {
                node.addLabel(Label.label((String)(labelPrefix + i)));
                node.setProperty(propertyKeyPrefix + i, (Object)(propertyValuePrefix + i));
            }
            tx.success();
        }
        catch (Throwable node) {
            var9_9 = node;
            throw node;
        }
        finally {
            if (tx != null) {
                if (var9_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node) {
                        var9_9.addSuppressed(node);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var9_9 = null;
        try {
            for (int i = 0; i < indexesCount; ++i) {
                Label label = Label.label((String)(labelPrefix + i));
                String key = propertyKeyPrefix + i;
                String value = propertyValuePrefix + i;
                ResourceIterator nodes = db.findNodes(label, key, (Object)value);
                Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)nodes));
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void assertCanCreateAndFind(GraphDatabaseService db, Label label, String propertyKey, Object value) {
        Node created = this.createNode(db, MapUtil.map((Object[])new Object[]{propertyKey, value}), label);
        try (Transaction tx = db.beginTx();){
            Node found = db.findNode(label, propertyKey, value);
            Assert.assertThat((Object)found, (Matcher)IsEqual.equalTo((Object)created));
            found.delete();
            tx.success();
        }
    }

    @Before
    public void setupLabels() {
        this.LABEL1 = Label.label((String)("LABEL1-" + this.testName.getMethodName()));
        this.LABEL2 = Label.label((String)("LABEL2-" + this.testName.getMethodName()));
        this.LABEL3 = Label.label((String)("LABEL3-" + this.testName.getMethodName()));
    }

    private Node createNode(GraphDatabaseService beansAPI, Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = beansAPI.beginTx();){
            Node node = beansAPI.createNode(labels);
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                node.setProperty(property.getKey(), property.getValue());
            }
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private Neo4jMatchers.Deferred<Label> labels(final Node myNode) {
        return new Neo4jMatchers.Deferred<Label>((GraphDatabaseService)dbRule.getGraphDatabaseAPI()){

            protected Iterable<Label> manifest() {
                return myNode.getLabels();
            }
        };
    }
}

