/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProviderFactory;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory20;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.Values;

public class IndexFailureOnStartupTest {
    private static final Label PERSON = Label.label((String)"Person");
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule().startLazily();

    @Test
    public void failedIndexShouldRepairAutomatically() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(PERSON).on("name").create();
            tx.success();
        }
        this.awaitIndexesOnline(5, TimeUnit.SECONDS);
        this.createNamed(PERSON, "Johan");
        this.db.restartDatabase((DatabaseRule.RestartAction)new DeleteIndexFile("_0.cfs"), new String[0]);
        this.createNamed(PERSON, "Lars");
        this.awaitIndexesOnline(5, TimeUnit.SECONDS);
        this.indexStateShouldBe((Matcher<Schema.IndexState>)CoreMatchers.equalTo((Object)Schema.IndexState.ONLINE));
        this.assertFindsNamed(PERSON, "Lars");
    }

    @Test
    public void shouldNotBeAbleToViolateConstraintWhenBackingIndexFailsToOpen() throws Exception {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(PERSON).assertPropertyIsUnique("name").create();
            tx.success();
        }
        this.createNamed(PERSON, "Lars");
        this.db.restartDatabase((DatabaseRule.RestartAction)new DeleteIndexFile("_0.cfs"), new String[0]);
        this.createNamed(PERSON, "Johan");
        Throwable failure = null;
        try {
            this.createNamed(PERSON, "Lars");
        }
        catch (Throwable e) {
            failure = e;
        }
        Assert.assertNotNull((Object)failure);
        this.indexStateShouldBe((Matcher<Schema.IndexState>)CoreMatchers.equalTo((Object)Schema.IndexState.ONLINE));
    }

    @Test
    public void shouldArchiveFailedIndex() throws Exception {
        Node node;
        this.db.setConfig(GraphDatabaseSettings.archive_failed_index, "true");
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode(new Label[]{PERSON});
            node.setProperty("name", (Object)"Fry");
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            node = this.db.createNode(new Label[]{PERSON});
            node.setProperty("name", (Object)Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{1.0, 2.0}));
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().constraintFor(PERSON).assertPropertyIsUnique("name").create();
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertThat((Object)this.archiveFile(), (Matcher)CoreMatchers.nullValue());
        this.db.restartDatabase((DatabaseRule.RestartAction)new DeleteIndexFile("segments_"), new String[0]);
        this.indexStateShouldBe((Matcher<Schema.IndexState>)CoreMatchers.equalTo((Object)Schema.IndexState.ONLINE));
        Assert.assertThat((Object)this.archiveFile(), (Matcher)CoreMatchers.notNullValue());
    }

    private File archiveFile() throws IOException {
        try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();){
            File indexDir = IndexFailureOnStartupTest.indexRootDirectory(this.db.databaseDirectory());
            File[] files = indexDir.listFiles(pathname -> pathname.isFile() && pathname.getName().startsWith("archive-"));
            if (files == null || files.length == 0) {
                File file = null;
                return file;
            }
            Assert.assertEquals((long)1L, (long)files.length);
            File file = files[0];
            return file;
        }
    }

    private void awaitIndexesOnline(int timeout, TimeUnit unit) {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline((long)timeout, unit);
            tx.success();
        }
    }

    private void assertFindsNamed(Label label, String name) {
        try (Transaction tx = this.db.beginTx();){
            Assert.assertNotNull((String)"Must be able to find node created while index was offline", (Object)this.db.findNode(label, "name", (Object)name));
            tx.success();
        }
    }

    private void indexStateShouldBe(Matcher<Schema.IndexState> matchesExpectation) {
        try (Transaction tx = this.db.beginTx();){
            for (IndexDefinition index : this.db.schema().getIndexes()) {
                Assert.assertThat((Object)this.db.schema().getIndexState(index), matchesExpectation);
            }
            tx.success();
        }
    }

    private void createNamed(Label label, String name) {
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode(new Label[]{label}).setProperty("name", (Object)name);
            tx.success();
        }
    }

    private static File indexRootDirectory(File base) {
        return IndexFailureOnStartupTest.providerDirectoryStructure(base).rootDirectory();
    }

    private static File soleIndexDir(File base) {
        return IndexFailureOnStartupTest.providerDirectoryStructure(base).directoryForIndex(1L);
    }

    private static IndexDirectoryStructure providerDirectoryStructure(File base) {
        return NativeLuceneFusionIndexProviderFactory20.subProviderDirectoryStructure((File)base).forProvider(LuceneIndexProviderFactory.PROVIDER_DESCRIPTOR);
    }

    private static class DeleteIndexFile
    implements DatabaseRule.RestartAction {
        private final String prefix;

        DeleteIndexFile(String prefix) {
            this.prefix = prefix;
        }

        public void run(FileSystemAbstraction fs, File base) {
            File indexRootDirectory = new File(IndexFailureOnStartupTest.soleIndexDir(base), "1");
            File[] files = fs.listFiles(indexRootDirectory, (dir, name) -> name.startsWith(this.prefix));
            Stream.of(files).forEach(arg_0 -> ((FileSystemAbstraction)fs).deleteFile(arg_0));
        }
    }
}

