/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.validation.ReservedIdException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class BatchInsertionIT {
    @Rule
    public final EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule().startLazily();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldIndexNodesWithMultipleLabels() throws Exception {
        File path = this.dbRule.databaseDirectory();
        BatchInserter inserter = BatchInserters.inserter((File)path, (FileSystemAbstraction)this.fileSystemRule.get());
        inserter.createNode(MapUtil.map((Object[])new Object[]{"name", "Bob"}), new Label[]{Label.label((String)"User"), Label.label((String)"Admin")});
        inserter.createDeferredSchemaIndex(Label.label((String)"User")).on("name").create();
        inserter.createDeferredSchemaIndex(Label.label((String)"Admin")).on("name").create();
        inserter.shutdown();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            MatcherAssert.assertThat((Object)Iterators.count((Iterator)db.findNodes(Label.label((String)"User"), "name", (Object)"Bob")), (Matcher)IsEqual.equalTo((Object)1L));
            MatcherAssert.assertThat((Object)Iterators.count((Iterator)db.findNodes(Label.label((String)"Admin"), "name", (Object)"Bob")), (Matcher)IsEqual.equalTo((Object)1L));
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotIndexNodesWithWrongLabel() throws Exception {
        File file = new File(this.dbRule.getDatabaseDirAbsolutePath());
        BatchInserter inserter = BatchInserters.inserter((File)file, (FileSystemAbstraction)this.fileSystemRule.get());
        inserter.createNode(MapUtil.map((Object[])new Object[]{"name", "Bob"}), new Label[]{Label.label((String)"User"), Label.label((String)"Admin")});
        inserter.createDeferredSchemaIndex(Label.label((String)"Banana")).on("name").create();
        inserter.shutdown();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            MatcherAssert.assertThat((Object)Iterators.count((Iterator)db.findNodes(Label.label((String)"Banana"), "name", (Object)"Bob")), (Matcher)IsEqual.equalTo((Object)0L));
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToMakeRepeatedCallsToSetNodeProperty() throws Exception {
        File file = this.dbRule.databaseDirectory();
        BatchInserter inserter = BatchInserters.inserter((File)file, (FileSystemAbstraction)this.fileSystemRule.get());
        long nodeId = inserter.createNode(Collections.emptyMap(), new Label[0]);
        Integer finalValue = 87;
        inserter.setNodeProperty(nodeId, "a", (Object)"some property value");
        inserter.setNodeProperty(nodeId, "a", (Object)42);
        inserter.setNodeProperty(nodeId, "a", (Object)3.14);
        inserter.setNodeProperty(nodeId, "a", (Object)true);
        inserter.setNodeProperty(nodeId, "a", (Object)finalValue);
        inserter.shutdown();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction ignored = db.beginTx();){
            MatcherAssert.assertThat((Object)db.getNodeById(nodeId).getProperty("a"), (Matcher)IsEqual.equalTo((Object)finalValue));
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToMakeRepeatedCallsToSetNodePropertyWithMultiplePropertiesPerBlock() throws Exception {
        File file = this.dbRule.databaseDirectory();
        BatchInserter inserter = BatchInserters.inserter((File)file, (FileSystemAbstraction)this.fileSystemRule.get());
        long nodeId = inserter.createNode(Collections.emptyMap(), new Label[0]);
        Integer finalValue1 = 87;
        Double finalValue2 = 3.14;
        inserter.setNodeProperty(nodeId, "a", (Object)"some property value");
        inserter.setNodeProperty(nodeId, "a", (Object)42);
        inserter.setNodeProperty(nodeId, "b", (Object)finalValue2);
        inserter.setNodeProperty(nodeId, "a", (Object)finalValue2);
        inserter.setNodeProperty(nodeId, "a", (Object)true);
        inserter.setNodeProperty(nodeId, "a", (Object)finalValue1);
        inserter.shutdown();
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction ignored = db.beginTx();){
            MatcherAssert.assertThat((Object)db.getNodeById(nodeId).getProperty("a"), (Matcher)IsEqual.equalTo((Object)finalValue1));
            MatcherAssert.assertThat((Object)db.getNodeById(nodeId).getProperty("b"), (Matcher)IsEqual.equalTo((Object)finalValue2));
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ReservedIdException.class)
    public void makeSureCantCreateNodeWithMagicNumber() throws IOException {
        File path = this.dbRule.databaseDirectory();
        BatchInserter inserter = BatchInserters.inserter((File)path, (FileSystemAbstraction)this.fileSystemRule.get());
        try {
            long id = 0xFFFFFFFFL;
            inserter.createNode(id, null, new Label[0]);
        }
        finally {
            inserter.shutdown();
        }
    }
}

