/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.CorruptIndexException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.impl.lucene.explicit.Inserter;
import org.neo4j.io.proc.ProcessUtil;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.VerboseTimeout;

public class LuceneRecoveryIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final VerboseTimeout timeout = VerboseTimeout.builder().withTimeout(3L, TimeUnit.MINUTES).build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHardCoreRecovery() throws Exception {
        String path = this.testDirectory.storeDir().getPath();
        Process process = Runtime.getRuntime().exec(new String[]{ProcessUtil.getJavaExecutable().toString(), "-cp", ProcessUtil.getClassPath(), Inserter.class.getName(), path});
        this.awaitFile(new File(path, "started"));
        Thread.sleep(5000L);
        process.destroy();
        process.waitFor();
        GraphDatabaseService db = null;
        try {
            db = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.storeDir());
            try (Transaction transaction = db.beginTx();){
                Assert.assertTrue((boolean)db.index().existsForNodes("myIndex"));
                Index index = db.index().forNodes("myIndex");
                for (Node node : db.getAllNodes()) {
                    for (String key : node.getPropertyKeys()) {
                        String value = (String)node.getProperty(key);
                        boolean found = false;
                        try (IndexHits indexHits = index.get(key, (Object)value);){
                            for (Node indexedNode : indexHits) {
                                if (!indexedNode.equals(node)) continue;
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        throw new IllegalStateException(node + " has property '" + key + "'='" + value + "', but not in index");
                    }
                }
            }
            catch (Throwable e) {
                if (Exceptions.contains((Throwable)e, (Class[])new Class[]{CorruptIndexException.class}) || this.exceptionContainsStackTraceElementFromPackage(e, "org.apache.lucene")) {
                    System.err.println("Lucene exception happened during recovery after a real crash. It may be that the index is corrupt somehow and this is out of control and not something this test can really improve on right now. Printing the exception for reference");
                    e.printStackTrace();
                    if (db != null) {
                        db.shutdown();
                    }
                    return;
                }
                throw e;
            }
            NodeCreator nodeCreator = new NodeCreator(db);
            Thread t = new Thread(nodeCreator);
            t.start();
            t.join();
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    private boolean exceptionContainsStackTraceElementFromPackage(Throwable e, String packageName) {
        for (StackTraceElement element : e.getStackTrace()) {
            if (!element.getClassName().startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    private void awaitFile(File file) throws InterruptedException {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(300L);
        while (!file.exists() && System.currentTimeMillis() < end) {
            Thread.sleep(100L);
        }
        if (!file.exists()) {
            Assert.fail((String)"The inserter doesn't seem to have run properly");
        }
    }

    private static class NodeCreator
    implements Runnable {
        private final GraphDatabaseService db;

        NodeCreator(GraphDatabaseService db) {
            this.db = db;
        }

        @Override
        public void run() {
            try (Transaction tx = this.db.beginTx();){
                Index index = this.db.index().forNodes("myIndex");
                index.add((PropertyContainer)this.db.createNode(), "one", (Object)"two");
                tx.success();
            }
        }
    }
}

