/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.CommunityEditionModule;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProviderFactory;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory10;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory20;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class NonUniqueIndexTest {
    @Rule
    public PageCacheAndDependenciesRule resources = new PageCacheAndDependenciesRule(DefaultFileSystemRule::new, NonUniqueIndexTest.class);

    @Test
    public void concurrentIndexPopulationAndInsertsShouldNotProduceDuplicates() throws Exception {
        Node node;
        Config config = Config.defaults();
        GraphDatabaseService db = this.newEmbeddedGraphDatabaseWithSlowJobScheduler(config);
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(Label.label((String)"SomeLabel")).on("key").create();
            tx.success();
        }
        try (Transaction tx = db.beginTx();){
            node = db.createNode(new Label[]{Label.label((String)"SomeLabel")});
            node.setProperty("key", (Object)"value");
            tx.success();
        }
        tx = db.beginTx();
        var5_7 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var5_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        Assert.assertThat(this.nodeIdsInIndex(config, 1, "value"), (Matcher)CoreMatchers.equalTo(Collections.singletonList(node.getId())));
    }

    private GraphDatabaseService newEmbeddedGraphDatabaseWithSlowJobScheduler(Config config) {
        GraphDatabaseFactoryState graphDatabaseFactoryState = new GraphDatabaseFactoryState();
        graphDatabaseFactoryState.setUserLogProvider(NullLogService.getInstance().getUserLogProvider());
        return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

            protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                return new PlatformModule(storeDir, config, this.databaseInfo, dependencies){

                    protected CentralJobScheduler createJobScheduler() {
                        return NonUniqueIndexTest.newSlowJobScheduler();
                    }

                    protected LogService createLogService(LogProvider userLogProvider) {
                        return NullLogService.getInstance();
                    }
                };
            }
        }.newFacade(this.resources.directory().storeDir(), config, graphDatabaseFactoryState.databaseDependencies());
    }

    private static CentralJobScheduler newSlowJobScheduler() {
        return new CentralJobScheduler(){

            public JobScheduler.JobHandle schedule(JobScheduler.Group group, Runnable job) {
                return super.schedule(group, NonUniqueIndexTest.slowRunnable(job));
            }
        };
    }

    private static Runnable slowRunnable(Runnable target) {
        return () -> {
            LockSupport.parkNanos(100000000L);
            target.run();
        };
    }

    /*
     * Exception decompiling
     */
    private List<Long> nodeIdsInIndex(Config config, int indexId, String value) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static IndexProvider selectIndexProvider(PageCache pageCache, File databaseDirectory, FileSystemAbstraction fs, IndexProvider.Monitor monitor, Config config, OperationalMode operationalMode) {
        String defaultSchemaProvider = (String)config.get(GraphDatabaseSettings.default_schema_provider);
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = RecoveryCleanupWorkCollector.IMMEDIATE;
        if (GraphDatabaseSettings.SchemaIndex.LUCENE10.providerIdentifier().equals(defaultSchemaProvider)) {
            return LuceneIndexProviderFactory.newInstance((PageCache)pageCache, (File)databaseDirectory, (FileSystemAbstraction)fs, (IndexProvider.Monitor)monitor, (Config)config, (OperationalMode)operationalMode, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector);
        }
        if (GraphDatabaseSettings.SchemaIndex.NATIVE10.providerIdentifier().equals(defaultSchemaProvider)) {
            return NativeLuceneFusionIndexProviderFactory10.create((PageCache)pageCache, (File)databaseDirectory, (FileSystemAbstraction)fs, (IndexProvider.Monitor)monitor, (Config)config, (OperationalMode)operationalMode, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector);
        }
        return NativeLuceneFusionIndexProviderFactory20.create((PageCache)pageCache, (File)databaseDirectory, (FileSystemAbstraction)fs, (IndexProvider.Monitor)monitor, (Config)config, (OperationalMode)operationalMode, (RecoveryCleanupWorkCollector)recoveryCleanupWorkCollector);
    }
}

