/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.impl.index.builder.LuceneIndexStorageBuilder;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProviderFactory;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory20;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ConstraintIndexFailureIT {
    private static final String INJECTED_FAILURE = "Injected failure";
    @Rule
    public final TestDirectory storeDir = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailToValidateConstraintsIfUnderlyingIndexIsFailed() throws Exception {
        this.dbWithConstraint();
        this.storeIndexFailure(INJECTED_FAILURE);
        GraphDatabaseService db = this.startDatabase();
        try {
            try (Transaction tx = db.beginTx();){
                db.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
                Assert.fail((String)"expected exception");
            }
            catch (ConstraintViolationException e) {
                Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(UnableToValidateConstraintException.class));
                Assert.assertThat((Object)e.getCause().getCause().getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"The index is in a failed state:"), (Matcher)CoreMatchers.containsString((String)INJECTED_FAILURE)));
            }
        }
        finally {
            db.shutdown();
        }
    }

    private GraphDatabaseService startDatabase() {
        return new TestGraphDatabaseFactory().newEmbeddedDatabase(this.storeDir.storeDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbWithConstraint() {
        GraphDatabaseService db = this.startDatabase();
        try (Transaction tx = db.beginTx();){
            db.schema().constraintFor(Label.label((String)"Label1")).assertPropertyIsUnique("key1").create();
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private void storeIndexFailure(String failure) throws IOException {
        File luceneIndexDirectory = NativeLuceneFusionIndexProviderFactory20.subProviderDirectoryStructure((File)this.storeDir.databaseDir()).forProvider(LuceneIndexProviderFactory.PROVIDER_DESCRIPTOR).directoryForIndex(1L);
        PartitionedIndexStorage indexStorage = LuceneIndexStorageBuilder.create().withFileSystem(this.fileSystemRule.get()).withIndexFolder(luceneIndexDirectory).build();
        indexStorage.storeIndexFailure(failure);
    }
}

