/*
 * Decompiled with CFR 0.152.
 */
package schema;

import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.RandomValues;

public class DynamicIndexStoreViewIT {
    private final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.suppressOutput);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void populateDbWithConcurrentUpdates() throws Exception {
        GraphDatabaseService database = new TestGraphDatabaseFactory().newEmbeddedDatabase(this.testDirectory.storeDir());
        try {
            RandomValues randomValues = RandomValues.create();
            int counter = 1;
            for (int j = 0; j < 100; ++j) {
                try (Transaction transaction = database.beginTx();){
                    for (int i = 0; i < 5; ++i) {
                        Node node = database.createNode(new Label[]{Label.label((String)("label" + counter))});
                        node.setProperty("property", randomValues.nextValue().asObject());
                    }
                    transaction.success();
                }
                ++counter;
            }
            int populatorCount = 5;
            ExecutorService executor = Executors.newFixedThreadPool(populatorCount);
            CountDownLatch startSignal = new CountDownLatch(1);
            AtomicBoolean endSignal = new AtomicBoolean();
            for (int i = 0; i < populatorCount; ++i) {
                executor.submit(new Populator(database, counter, startSignal, endSignal));
            }
            try {
                try (Transaction transaction = database.beginTx();){
                    database.schema().indexFor(Label.label((String)"label10")).on("property").create();
                    transaction.success();
                }
                startSignal.countDown();
                transaction = database.beginTx();
                var9_16 = null;
                try {
                    database.schema().awaitIndexesOnline((long)populatorCount, TimeUnit.MINUTES);
                    transaction.success();
                }
                catch (Throwable throwable) {
                    var9_16 = throwable;
                    throw throwable;
                }
                finally {
                    if (transaction != null) {
                        if (var9_16 != null) {
                            try {
                                transaction.close();
                            }
                            catch (Throwable throwable) {
                                var9_16.addSuppressed(throwable);
                            }
                        } else {
                            transaction.close();
                        }
                    }
                }
            }
            finally {
                endSignal.set(true);
                executor.shutdown();
            }
        }
        finally {
            database.shutdown();
            ConsistencyCheckService consistencyCheckService = new ConsistencyCheckService();
            Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8m");
            consistencyCheckService.runFullConsistencyCheck(this.testDirectory.databaseDir(), config, ProgressMonitorFactory.NONE, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out), false);
        }
    }

    private class Populator
    implements Runnable {
        private final GraphDatabaseService databaseService;
        private final long totalNodes;
        private final CountDownLatch startSignal;
        private final AtomicBoolean endSignal;

        Populator(GraphDatabaseService databaseService, long totalNodes, CountDownLatch startSignal, AtomicBoolean endSignal) {
            this.databaseService = databaseService;
            this.totalNodes = totalNodes;
            this.startSignal = startSignal;
            this.endSignal = endSignal;
        }

        @Override
        public void run() {
            RandomValues randomValues = RandomValues.create();
            DoubleLatch.awaitLatch((CountDownLatch)this.startSignal);
            while (!this.endSignal.get()) {
                Transaction transaction = this.databaseService.beginTx();
                Throwable throwable = null;
                try {
                    try {
                        int operationType = randomValues.nextIntValue(3).value();
                        switch (operationType) {
                            case 0: {
                                long targetNodeId = randomValues.nextLongValue(this.totalNodes).value();
                                this.databaseService.getNodeById(targetNodeId).delete();
                                break;
                            }
                            case 1: {
                                long nodeId = randomValues.nextLongValue(this.totalNodes).value();
                                Node node = this.databaseService.getNodeById(nodeId);
                                Map allProperties = node.getAllProperties();
                                for (String key : allProperties.keySet()) {
                                    node.setProperty(key, randomValues.nextValue().asObject());
                                }
                                break;
                            }
                            case 2: {
                                Node nodeToUpdate = this.databaseService.createNode(new Label[]{Label.label((String)"label10")});
                                nodeToUpdate.setProperty("property", randomValues.nextValue().asObject());
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unknown type of index operation");
                            }
                        }
                        transaction.success();
                    }
                    catch (Exception e) {
                        transaction.failure();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (transaction == null) continue;
                    if (throwable != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    transaction.close();
                }
            }
        }
    }
}

