/*
 * Decompiled with CFR 0.152.
 */
package schema;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongFunction;
import java.util.function.ToIntFunction;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.api.index.BatchingMultipleIndexPopulator;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.RepeatRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.GeneratingInputIterator;
import org.neo4j.unsafe.impl.batchimport.ImportLogic;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.RandomsStates;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.BadCollector;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitors;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;

public class MultipleIndexPopulationStressIT {
    private static final String[] TOKENS = new String[]{"One", "Two", "Three", "Four"};
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final RandomRule random = new RandomRule();
    private final CleanupRule cleanup = new CleanupRule();
    private final RepeatRule repeat = new RepeatRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.random).around((TestRule)this.repeat).around((TestRule)this.directory).around((TestRule)this.cleanup).around((TestRule)this.fileSystemRule);

    @Test
    public void populateMultipleIndexWithSeveralNodesSingleThreaded() throws Exception {
        this.prepareAndRunTest(false, 10, TimeUnit.SECONDS.toMillis(5L));
    }

    @Test
    public void populateMultipleIndexWithSeveralNodesMultiThreaded() throws Exception {
        this.prepareAndRunTest(true, 10, TimeUnit.SECONDS.toMillis(5L));
    }

    @Test
    public void shouldPopulateMultipleIndexPopulatorsUnderStressSingleThreaded() throws Exception {
        this.readConfigAndRunTest(false);
    }

    @Test
    public void shouldPopulateMultipleIndexPopulatorsUnderStressMultiThreaded() throws Exception {
        int concurrentUpdatesQueueFlushThreshold = this.random.nextInt(100, 5000);
        FeatureToggles.set(BatchingMultipleIndexPopulator.class, (String)"queue_threshold", (Object)concurrentUpdatesQueueFlushThreshold);
        try {
            this.readConfigAndRunTest(true);
        }
        finally {
            FeatureToggles.clear(BatchingMultipleIndexPopulator.class, (String)"queue_threshold");
        }
    }

    private void readConfigAndRunTest(boolean multiThreaded) throws Exception {
        int nodeCount = (int)Settings.parseLongWithUnit((String)System.getProperty(this.getClass().getName() + ".nodes", "200k"));
        long duration = (Long)TimeUtil.parseTimeMillis.apply(System.getProperty(this.getClass().getName() + ".duration", "5s"));
        this.prepareAndRunTest(multiThreaded, nodeCount, duration);
    }

    private void prepareAndRunTest(boolean multiThreaded, int nodeCount, long durationMillis) throws Exception {
        this.createRandomData(nodeCount);
        long endTime = System.currentTimeMillis() + durationMillis;
        int i = 0;
        while (System.currentTimeMillis() < endTime) {
            this.runTest(nodeCount, i, multiThreaded);
            ++i;
        }
    }

    private void runTest(int nodeCount, int run, boolean multiThreaded) throws Exception {
        this.populateDbAndIndexes(nodeCount, multiThreaded);
        ConsistencyCheckService cc = new ConsistencyCheckService();
        ConsistencyCheckService.Result result = cc.runFullConsistencyCheck(this.directory.databaseDir(), Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8m"), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
        Assert.assertTrue((boolean)result.isSuccessful());
        this.dropIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateDbAndIndexes(int nodeCount, boolean multiThreaded) throws InterruptedException {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.directory.databaseDir()).setConfig(GraphDatabaseSettings.multi_threaded_schema_index_population_enabled, multiThreaded + "").newGraphDatabase();
        try {
            this.createIndexes(db);
            AtomicBoolean end = new AtomicBoolean();
            ExecutorService executor = (ExecutorService)this.cleanup.add((Object)Executors.newCachedThreadPool());
            for (int i = 0; i < 10; ++i) {
                executor.submit(() -> {
                    RandomValues randomValues = RandomValues.create();
                    while (!end.get()) {
                        this.changeRandomNode(db, nodeCount, randomValues);
                    }
                });
            }
            while (!this.indexesAreOnline(db)) {
                Thread.sleep(100L);
            }
            end.set(true);
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropIndexes() {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.directory.databaseDir()).setConfig(GraphDatabaseSettings.pagecache_memory, "8m").newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            for (IndexDefinition index : db.schema().getIndexes()) {
                index.drop();
            }
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private boolean indexesAreOnline(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            block17: for (IndexDefinition index : db.schema().getIndexes()) {
                switch (db.schema().getIndexState(index)) {
                    case ONLINE: {
                        continue block17;
                    }
                    case POPULATING: {
                        boolean bl = false;
                        return bl;
                    }
                    case FAILED: {
                        Assert.fail((String)(index + " entered failed state: " + db.schema().getIndexFailure(index)));
                    }
                }
                throw new UnsupportedOperationException();
            }
            tx.success();
        }
        return true;
    }

    private void createIndexes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            for (String label : (String[])this.random.selection((Object[])TOKENS, 3, 3, false)) {
                for (String propertyKey : (String[])this.random.selection((Object[])TOKENS, 3, 3, false)) {
                    db.schema().indexFor(Label.label((String)label)).on(propertyKey).create();
                }
            }
            tx.success();
        }
    }

    private void changeRandomNode(GraphDatabaseService db, int nodeCount, RandomValues random) {
        try (Transaction tx = db.beginTx();){
            long nodeId = random.nextInt(nodeCount);
            Node node = db.getNodeById(nodeId);
            Object[] keys = Iterables.asCollection((Iterable)node.getPropertyKeys()).toArray();
            String key = (String)random.among(keys);
            if ((double)random.nextFloat() < 0.1) {
                node.removeProperty(key);
            } else {
                node.setProperty(key, random.nextValue().asObject());
            }
            tx.success();
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void createRandomData(int count) throws IOException {
        Config config = Config.defaults();
        RecordFormats recordFormats = RecordFormatSelector.selectForConfig((Config)config, (LogProvider)NullLogProvider.getInstance());
        ParallelBatchImporter importer = new ParallelBatchImporter(this.directory.databaseDir(), this.fileSystemRule.get(), null, Configuration.DEFAULT, (LogService)NullLogService.getInstance(), ExecutionMonitors.invisible(), AdditionalInitialIds.EMPTY, config, recordFormats, ImportLogic.NO_MONITOR);
        try (RandomDataInput input = new RandomDataInput(count);){
            importer.doImport((Input)input);
        }
    }

    private class RandomDataInput
    implements Input,
    AutoCloseable {
        private final int count;
        private final BadCollector badCollector;

        RandomDataInput(int count) {
            this.count = count;
            this.badCollector = this.createBadCollector();
        }

        public InputIterable relationships() {
            return GeneratingInputIterator.EMPTY_ITERABLE;
        }

        public InputIterable nodes() {
            return InputIterable.replayable(() -> new RandomNodeGenerator(this.count, (GeneratingInputIterator.Generator<RandomValues>)((GeneratingInputIterator.Generator)(state, visitor, id) -> {
                String[] keys;
                for (String key : keys = (String[])MultipleIndexPopulationStressIT.this.random.randomValues().selection((Object[])TOKENS, 1, TOKENS.length, false)) {
                    visitor.property(key, MultipleIndexPopulationStressIT.this.random.nextValueAsObject());
                }
                visitor.labels((String[])MultipleIndexPopulationStressIT.this.random.selection((Object[])TOKENS, 1, TOKENS.length, false));
            })));
        }

        public IdMapper idMapper(NumberArrayFactory numberArrayFactory) {
            return IdMappers.actual();
        }

        public Collector badCollector() {
            return this.badCollector;
        }

        private BadCollector createBadCollector() {
            try {
                return new BadCollector(((DefaultFileSystemAbstraction)MultipleIndexPopulationStressIT.this.fileSystemRule.get()).openAsOutputStream(new File(MultipleIndexPopulationStressIT.this.directory.databaseDir(), "bad"), false), 0L, 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public Input.Estimates calculateEstimates(ToIntFunction<Value[]> valueSizeCalculator) {
            return Inputs.knownEstimates((long)this.count, (long)0L, (long)(this.count * TOKENS.length / 2), (long)0L, (long)(this.count * TOKENS.length / 2 * 8), (long)0L, (long)0L);
        }

        @Override
        public void close() {
            this.badCollector.close();
        }
    }

    private class RandomNodeGenerator
    extends GeneratingInputIterator<RandomValues> {
        RandomNodeGenerator(int count, GeneratingInputIterator.Generator<RandomValues> randomsGenerator) {
            super((long)count, 1000, (LongFunction)new RandomsStates(MultipleIndexPopulationStressIT.this.random.seed()), randomsGenerator, 0L);
        }
    }
}

