/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.impl.schema.LuceneIndexProviderFactory;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory20;
import org.neo4j.kernel.impl.index.schema.NumberIndexProvider;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Values;

public class FusionIndexIT {
    @Rule
    public DatabaseRule db = new EmbeddedDatabaseRule().withSetting(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE20.providerIdentifier());
    private DatabaseLayout databaseLayout;
    private final Label label = Label.label((String)"label");
    private final String propKey = "propKey";
    private FileSystemAbstraction fs;
    private int numberValue = 1;
    private String stringValue = "string";
    private PointValue spatialValue = Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS84, (double[])new double[]{0.5, 0.5});
    private DateValue temporalValue = DateValue.date((int)2018, (int)3, (int)19);

    @Before
    public void setup() {
        this.databaseLayout = this.db.databaseLayout();
        this.fs = (FileSystemAbstraction)this.db.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
    }

    @Test
    public void mustRebuildFusionIndexIfNativePartIsMissing() throws IOException {
        this.initializeIndexWithDataAndShutdown();
        IndexProviderDescriptor descriptor = NumberIndexProvider.NATIVE_PROVIDER_DESCRIPTOR;
        this.deleteIndexFilesFor(descriptor);
        this.verifyContent();
    }

    @Test
    public void mustRebuildFusionIndexIfLucenePartIsMissing() throws IOException {
        this.initializeIndexWithDataAndShutdown();
        IndexProviderDescriptor descriptor = LuceneIndexProviderFactory.PROVIDER_DESCRIPTOR;
        this.deleteIndexFilesFor(descriptor);
        this.verifyContent();
    }

    @Test
    public void mustRebuildFusionIndexIfCompletelyMissing() throws IOException {
        this.initializeIndexWithDataAndShutdown();
        IndexProviderDescriptor luceneDescriptor = LuceneIndexProviderFactory.PROVIDER_DESCRIPTOR;
        IndexProviderDescriptor nativeDescriptor = NumberIndexProvider.NATIVE_PROVIDER_DESCRIPTOR;
        this.deleteIndexFilesFor(luceneDescriptor);
        this.deleteIndexFilesFor(nativeDescriptor);
        this.verifyContent();
    }

    private void verifyContent() {
        GraphDatabaseAPI newDb = this.db.getGraphDatabaseAPI();
        try (Transaction tx = newDb.beginTx();){
            Assert.assertEquals((long)1L, (long)Iterators.stream(newDb.schema().getIndexes(this.label).iterator()).count());
            Assert.assertNotNull((Object)newDb.findNode(this.label, "propKey", (Object)this.numberValue));
            Assert.assertNotNull((Object)newDb.findNode(this.label, "propKey", (Object)this.stringValue));
            Assert.assertNotNull((Object)newDb.findNode(this.label, "propKey", (Object)this.spatialValue));
            Assert.assertNotNull((Object)newDb.findNode(this.label, "propKey", (Object)this.temporalValue));
            tx.success();
        }
    }

    private void deleteIndexFilesFor(IndexProviderDescriptor descriptor) {
        File[] files;
        File databaseDirectory = this.databaseLayout.databaseDirectory();
        File rootDirectory = NativeLuceneFusionIndexProviderFactory20.subProviderDirectoryStructure((File)databaseDirectory).forProvider(descriptor).rootDirectory();
        for (File indexFile : files = this.fs.listFiles(rootDirectory)) {
            this.fs.deleteFile(indexFile);
        }
    }

    private void initializeIndexWithDataAndShutdown() {
        this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.numberValue);
            this.db.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.stringValue);
            this.db.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.spatialValue);
            this.db.createNode(new Label[]{this.label}).setProperty("propKey", (Object)this.temporalValue);
            tx.success();
        }
        this.db.shutdown();
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(this.label).on("propKey").create();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

