/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.eclipse.collections.impl.factory.Iterables;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.RandomValues;

public class GenericIndexValidationIT {
    private static final String[] PROP_KEYS = new String[]{"prop0", "prop1", "prop2", "prop3", "prop4", "prop5", "prop6", "prop7", "prop8", "prop9"};
    private static final int KEY_SIZE_LIMIT = TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)8192);
    private static final int ESTIMATED_OVERHEAD_PER_SLOT = 2;
    private static final int WIGGLE_ROOM = 50;
    private List<RandomValues.Types> allValidNonArrayTypes = Iterables.mList((Object[])RandomValues.Types.values()).without((Object)RandomValues.Types.ARRAY).without((Object)RandomValues.Types.CARTESIAN_POINT).without((Object)RandomValues.Types.CARTESIAN_POINT_3D).without((Object)RandomValues.Types.GEOGRAPHIC_POINT).without((Object)RandomValues.Types.GEOGRAPHIC_POINT_3D);
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule().withSetting(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerIdentifier());
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldEnforceSizeCapSingleValue() {
        this.createIndex(PROP_KEYS[0]);
        int keySizeLimitSingleSlot = KEY_SIZE_LIMIT - 2;
        for (int i = 0; i < 1000; ++i) {
            Node node2;
            Throwable throwable;
            Transaction tx;
            Object propValue = this.generateSingleValue(keySizeLimitSingleSlot, 50);
            long expectedNodeId = -1L;
            boolean ableToWrite = true;
            try {
                tx = this.db.beginTx();
                throwable = null;
                try {
                    node2 = this.db.createNode(new Label[]{TestLabels.LABEL_ONE});
                    node2.setProperty(PROP_KEYS[0], propValue);
                    expectedNodeId = node2.getId();
                    tx.success();
                }
                catch (Throwable node2) {
                    throwable = node2;
                    throw node2;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable node2) {
                                throwable.addSuppressed(node2);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                ableToWrite = false;
            }
            tx = this.db.beginTx();
            throwable = null;
            try {
                node2 = this.db.findNode((Label)TestLabels.LABEL_ONE, PROP_KEYS[0], propValue);
                if (ableToWrite) {
                    Assert.assertNotNull((Object)node2);
                    Assert.assertEquals((String)"node id", (long)expectedNodeId, (long)node2.getId());
                } else {
                    Assert.assertNull((Object)node2);
                }
                tx.success();
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    @Test
    public void shouldEnforceSizeCapComposite() {
        this.createIndex(PROP_KEYS);
        int keySizeLimitPerSlot = KEY_SIZE_LIMIT / PROP_KEYS.length - 2;
        int wiggleRoomPerSlot = 50 / PROP_KEYS.length;
        for (int i = 0; i < 1000; ++i) {
            int propKey;
            Throwable throwable;
            Transaction tx;
            Object[] propValues = new Object[PROP_KEYS.length];
            for (int propKey2 = 0; propKey2 < PROP_KEYS.length; ++propKey2) {
                propValues[propKey2] = this.generateSingleValue(keySizeLimitPerSlot, wiggleRoomPerSlot);
            }
            long expectedNodeId = -1L;
            boolean ableToWrite = true;
            try {
                tx = this.db.beginTx();
                throwable = null;
                try {
                    Node node = this.db.createNode(new Label[]{TestLabels.LABEL_ONE});
                    for (propKey = 0; propKey < PROP_KEYS.length; ++propKey) {
                        node.setProperty(PROP_KEYS[propKey], propValues[propKey]);
                    }
                    expectedNodeId = node.getId();
                    tx.success();
                }
                catch (Throwable node) {
                    throwable = node;
                    throw node;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable node) {
                                throwable.addSuppressed(node);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                ableToWrite = false;
            }
            tx = this.db.beginTx();
            throwable = null;
            try {
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (propKey = 0; propKey < PROP_KEYS.length; ++propKey) {
                    values.put(PROP_KEYS[propKey], propValues[propKey]);
                }
                ResourceIterator nodes = this.db.findNodes((Label)TestLabels.LABEL_ONE, values);
                if (ableToWrite) {
                    Assert.assertTrue((boolean)nodes.hasNext());
                    Node node = (Node)nodes.next();
                    Assert.assertNotNull((Object)node);
                    Assert.assertEquals((String)"node id", (long)expectedNodeId, (long)node.getId());
                } else {
                    Assert.assertFalse((boolean)nodes.hasNext());
                }
                tx.success();
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    private Object generateSingleValue(int keySizeLimit, int wiggleRoom) {
        switch ((RandomValues.Types)this.random.among((Object[])new RandomValues.Types[]{RandomValues.Types.STRING, RandomValues.Types.ARRAY})) {
            case STRING: {
                return this.random.nextAlphaNumericString(keySizeLimit - wiggleRoom, keySizeLimit + wiggleRoom);
            }
            case ARRAY: {
                return this.generateSingleArrayValue(keySizeLimit, wiggleRoom);
            }
        }
        throw new IllegalArgumentException();
    }

    private Object generateSingleArrayValue(int keySizeLimit, int wiggleRoom) {
        RandomValues.Types type = (RandomValues.Types)this.random.among(this.allValidNonArrayTypes);
        switch (type) {
            case BOOLEAN: {
                return this.createRandomArray(RandomValues::nextBooleanArrayRaw, keySizeLimit, wiggleRoom, 1);
            }
            case BYTE: {
                return this.createRandomArray(RandomValues::nextByteArrayRaw, keySizeLimit, wiggleRoom, 1);
            }
            case SHORT: {
                return this.createRandomArray(RandomValues::nextShortArrayRaw, keySizeLimit, wiggleRoom, 2);
            }
            case STRING: {
                return this.createRandomStringArray(keySizeLimit, wiggleRoom);
            }
            case INT: {
                return this.createRandomArray(RandomValues::nextIntArrayRaw, keySizeLimit, wiggleRoom, 4);
            }
            case LONG: {
                return this.createRandomArray(RandomValues::nextLongArrayRaw, keySizeLimit, wiggleRoom, 8);
            }
            case FLOAT: {
                return this.createRandomArray(RandomValues::nextFloatArrayRaw, keySizeLimit, wiggleRoom, 4);
            }
            case DOUBLE: {
                return this.createRandomArray(RandomValues::nextDoubleArrayRaw, keySizeLimit, wiggleRoom, 8);
            }
            case LOCAL_DATE_TIME: {
                return this.createRandomArray(RandomValues::nextLocalDateTimeArrayRaw, keySizeLimit, wiggleRoom, 12);
            }
            case DATE: {
                return this.createRandomArray(RandomValues::nextDateArrayRaw, keySizeLimit, wiggleRoom, 8);
            }
            case LOCAL_TIME: {
                return this.createRandomArray(RandomValues::nextLocalTimeArrayRaw, keySizeLimit, wiggleRoom, 8);
            }
            case PERIOD: {
                return this.createRandomArray(RandomValues::nextPeriodArrayRaw, keySizeLimit, wiggleRoom, 28);
            }
            case DURATION: {
                return this.createRandomArray(RandomValues::nextDurationArrayRaw, keySizeLimit, wiggleRoom, 28);
            }
            case TIME: {
                return this.createRandomArray(RandomValues::nextTimeArrayRaw, keySizeLimit, wiggleRoom, 12);
            }
            case DATE_TIME: {
                return this.createRandomArray(RandomValues::nextDateTimeArrayRaw, keySizeLimit, wiggleRoom, 16);
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    private Object createRandomStringArray(int keySizeLimit, int wiggleRoom) {
        int totalLength;
        int sizeOfString;
        if (this.random.nextBoolean()) {
            int singleEntrySize = 3;
            int length = this.random.nextInt(this.lowLimit(keySizeLimit, wiggleRoom, singleEntrySize), this.highLimit(keySizeLimit, wiggleRoom, singleEntrySize));
            char[] chars = new char[length];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = RandomStringUtils.randomAlphanumeric((int)1).charAt(0);
            }
            return chars;
        }
        int maxNumberOfStrings = 4;
        ArrayList<String> strings = new ArrayList<String>();
        for (totalLength = this.random.nextInt(this.lowLimit(keySizeLimit, wiggleRoom, 1), this.highLimit(keySizeLimit, wiggleRoom, 1)); strings.size() < maxNumberOfStrings - 1 && totalLength > 0; totalLength -= sizeOfString) {
            sizeOfString = this.random.nextInt(totalLength);
            strings.add(RandomStringUtils.randomAlphanumeric((int)sizeOfString));
        }
        strings.add(RandomStringUtils.randomAlphabetic((int)totalLength));
        return strings.toArray(new String[strings.size()]);
    }

    private Object createRandomArray(RandomArrayFactory factory, int keySizeLimit, int wiggleRoom, int entrySize) {
        return factory.next(this.random.randomValues(), this.lowLimit(keySizeLimit, wiggleRoom, entrySize), this.highLimit(keySizeLimit, wiggleRoom, entrySize));
    }

    private int lowLimit(int keySizeLimit, int wiggleRoom, int singleEntrySize) {
        return (keySizeLimit - wiggleRoom) / singleEntrySize;
    }

    private int highLimit(int keySizeLimit, int wiggleRoom, int singleEntrySize) {
        return (keySizeLimit + wiggleRoom) / singleEntrySize;
    }

    private void createIndex(String ... propKeys) {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = this.db.schema().indexFor((Label)TestLabels.LABEL_ONE);
            for (String propKey : propKeys) {
                indexCreator = indexCreator.on(propKey);
            }
            indexCreator.create();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @FunctionalInterface
    private static interface RandomArrayFactory {
        public Object next(RandomValues var1, int var2, int var3);
    }
}

