/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.RecoveryMonitor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class RecoverIndexDropIT {
    private static final String KEY = "key";
    @Rule
    public final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDropIndexOnRecovery() throws IOException {
        CommittedTransactionRepresentation dropTransaction = this.prepareDropTransaction();
        File storeDir = this.directory.databaseDir();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        RecoverIndexDropIT.createIndex(db);
        db.shutdown();
        this.appendDropTransactionToTransactionLog(this.directory.databaseDir(), dropTransaction);
        Monitors monitors = new Monitors();
        AssertRecoveryIsPerformed recoveryMonitor = new AssertRecoveryIsPerformed();
        monitors.addMonitorListener((Object)recoveryMonitor, new String[0]);
        db = new TestGraphDatabaseFactory().setMonitors(monitors).newEmbeddedDatabase(storeDir);
        try {
            Assert.assertTrue((boolean)recoveryMonitor.recoveryWasPerformed);
            try (Transaction tx = db.beginTx();){
                Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)db.schema().getIndexes()));
                tx.success();
            }
        }
        finally {
            db.shutdown();
        }
    }

    private static IndexDefinition createIndex(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            IndexDefinition index = db.schema().indexFor((Label)TestLabels.LABEL_ONE).on(KEY).create();
            tx.success();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    private void appendDropTransactionToTransactionLog(File databaseDirectory, CommittedTransactionRepresentation dropTransaction) throws IOException {
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)databaseDirectory, (FileSystemAbstraction)this.fs).build();
        File logFile = logFiles.getLogFileForVersion(logFiles.getHighestLogVersion());
        StoreChannel writeStoreChannel = this.fs.open(logFile, OpenMode.READ_WRITE);
        writeStoreChannel.position(writeStoreChannel.size());
        try (PhysicalFlushableChannel writeChannel = new PhysicalFlushableChannel(writeStoreChannel);){
            new LogEntryWriter((FlushableChannel)writeChannel).serialize(dropTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommittedTransactionRepresentation prepareDropTransaction() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newEmbeddedDatabase(this.directory.directory("preparation"));
        try {
            IndexDefinition index = RecoverIndexDropIT.createIndex((GraphDatabaseService)db);
            try (Transaction tx = db.beginTx();){
                index.drop();
                tx.success();
            }
            CommittedTransactionRepresentation committedTransactionRepresentation = RecoverIndexDropIT.extractLastTransaction(db);
            return committedTransactionRepresentation;
        }
        finally {
            db.shutdown();
        }
    }

    private static CommittedTransactionRepresentation extractLastTransaction(GraphDatabaseAPI db) throws IOException {
        LogicalTransactionStore txStore = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
        CommittedTransactionRepresentation transaction = null;
        try (TransactionCursor cursor = txStore.getTransactions(2L);){
            while (cursor.next()) {
                transaction = (CommittedTransactionRepresentation)cursor.get();
            }
        }
        return transaction;
    }

    private static class AssertRecoveryIsPerformed
    implements RecoveryMonitor {
        boolean recoveryWasPerformed;

        private AssertRecoveryIsPerformed() {
        }

        public void recoveryRequired(LogPosition recoveryPosition) {
            this.recoveryWasPerformed = true;
        }
    }
}

