/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class AccessExplicitIndexReadOnlyIT {
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule().startLazily();

    @Test
    public void shouldListAndReadExplicitIndexesForReadOnlyDb() throws Exception {
        int i;
        RelationshipIndex relationshipIndex;
        Index nodeIndex;
        this.db.ensureStarted();
        String key = "key";
        try (Transaction tx = this.db.beginTx();){
            nodeIndex = this.db.index().forNodes("NODE");
            relationshipIndex = this.db.index().forRelationships("RELATIONSHIP");
            for (i = 0; i < 10; ++i) {
                Node node = this.db.createNode();
                Relationship relationship = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
                nodeIndex.add((PropertyContainer)node, key, (Object)String.valueOf(i));
                relationshipIndex.add((PropertyContainer)relationship, key, (Object)String.valueOf(i));
            }
            tx.success();
        }
        this.db.restartDatabase(new String[]{GraphDatabaseSettings.read_only.name(), Boolean.TRUE.toString()});
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            nodeIndex = this.db.index().forNodes(this.db.index().nodeIndexNames()[0]);
            relationshipIndex = this.db.index().forRelationships(this.db.index().relationshipIndexNames()[0]);
            for (i = 0; i < 10; ++i) {
                Assert.assertNotNull((Object)nodeIndex.get(key, (Object)String.valueOf(i)).getSingle());
                Assert.assertNotNull((Object)relationshipIndex.get(key, (Object)String.valueOf(i)).getSingle());
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotCreateIndexesForReadOnlyDb() {
        Throwable throwable;
        Transaction tx2;
        this.db.withSetting(GraphDatabaseSettings.read_only, Boolean.TRUE.toString());
        try {
            tx2 = this.db.beginTx();
            throwable = null;
            try {
                this.db.index().forNodes("NODE");
                Assert.fail((String)"Should've failed");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx2 != null) {
                    if (throwable != null) {
                        try {
                            tx2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx2.close();
                    }
                }
            }
        }
        catch (WriteOperationsNotAllowedException tx2) {
            // empty catch block
        }
        try {
            tx2 = this.db.beginTx();
            throwable = null;
            try {
                this.db.index().forRelationships("RELATIONSHIP");
                Assert.fail((String)"Should've failed");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (tx2 != null) {
                    if (throwable != null) {
                        try {
                            tx2.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx2.close();
                    }
                }
            }
        }
        catch (WriteOperationsNotAllowedException writeOperationsNotAllowedException) {
            // empty catch block
        }
    }
}

