/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class ConstraintRecoveryIT {
    private static final String KEY = "prop";
    private static final Label LABEL = Label.label((String)"label1");
    @Rule
    public EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private GraphDatabaseAPI db;

    @Test
    public void shouldHaveAvailableOrphanedConstraintIndexIfUniqueConstraintCreationFails() {
        final EphemeralFileSystemAbstraction fs = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        fs.mkdir(new File("/tmp"));
        File pathToDb = new File("/tmp/bar2");
        TestGraphDatabaseFactory dbFactory = new TestGraphDatabaseFactory();
        dbFactory.setFileSystem((FileSystemAbstraction)fs);
        final EphemeralFileSystemAbstraction[] storeInNeedOfRecovery = new EphemeralFileSystemAbstraction[1];
        final AtomicBoolean monitorCalled = new AtomicBoolean(false);
        Monitors monitors = new Monitors();
        monitors.addMonitorListener((Object)new IndexingService.MonitorAdapter(){

            public void indexPopulationScanComplete() {
                monitorCalled.set(true);
                ((RecordStorageEngine)ConstraintRecoveryIT.this.db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().getSchemaStore().flush();
                storeInNeedOfRecovery[0] = fs.snapshot();
            }
        }, new String[0]);
        dbFactory.setMonitors(monitors);
        this.db = (GraphDatabaseAPI)dbFactory.newImpermanentDatabaseBuilder(pathToDb).setConfig(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE20.providerName()).newGraphDatabase();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 2; ++i) {
                this.db.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)true);
            }
            tx.success();
        }
        try {
            tx = this.db.beginTx();
            var8_9 = null;
            try {
                this.db.schema().constraintFor(LABEL).assertPropertyIsUnique(KEY).create();
                Assert.fail((String)"Should have failed with ConstraintViolationException");
                tx.success();
            }
            catch (Throwable i) {
                var8_9 = i;
                throw i;
            }
            finally {
                if (tx != null) {
                    if (var8_9 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable i) {
                            var8_9.addSuppressed(i);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (ConstraintViolationException tx2) {
            // empty catch block
        }
        this.db.shutdown();
        Assert.assertTrue((boolean)monitorCalled.get());
        dbFactory = new TestGraphDatabaseFactory();
        dbFactory.setFileSystem((FileSystemAbstraction)storeInNeedOfRecovery[0]);
        this.db = (GraphDatabaseAPI)dbFactory.newImpermanentDatabase(pathToDb);
        var8_9 = null;
        try (Transaction ignore = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
        }
        catch (Throwable i) {
            var8_9 = i;
            throw i;
        }
        ignore = this.db.beginTx();
        var8_9 = null;
        try {
            Assert.assertEquals((long)2L, (long)Iterables.count((Iterable)this.db.getAllNodes()));
        }
        catch (Throwable i) {
            var8_9 = i;
            throw i;
        }
        finally {
            if (ignore != null) {
                if (var8_9 != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable i) {
                        var8_9.addSuppressed(i);
                    }
                } else {
                    ignore.close();
                }
            }
        }
        ignore = this.db.beginTx();
        var8_9 = null;
        try {
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)Iterables.asList((Iterable)this.db.schema().getConstraints())));
        }
        catch (Throwable i) {
            var8_9 = i;
            throw i;
        }
        finally {
            if (ignore != null) {
                if (var8_9 != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable i) {
                        var8_9.addSuppressed(i);
                    }
                } else {
                    ignore.close();
                }
            }
        }
        ignore = this.db.beginTx();
        var8_9 = null;
        try {
            IndexDefinition orphanedConstraintIndex = (IndexDefinition)Iterables.single((Iterable)this.db.schema().getIndexes());
            Assert.assertEquals((Object)LABEL.name(), (Object)((Label)Iterables.single((Iterable)orphanedConstraintIndex.getLabels())).name());
            Assert.assertEquals((Object)KEY, (Object)Iterables.single((Iterable)orphanedConstraintIndex.getPropertyKeys()));
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
        finally {
            if (ignore != null) {
                if (var8_9 != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable) {
                        var8_9.addSuppressed(throwable);
                    }
                } else {
                    ignore.close();
                }
            }
        }
        this.db.shutdown();
    }
}

