/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class StringLengthIndexValidationIT {
    @Rule
    public DatabaseRule db = new EmbeddedDatabaseRule().withSetting(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE20.providerName());
    private static final String propKey = "largeString";
    private static final int keySizeLimit = TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)8192) - 8;

    @Test
    public void shouldSuccessfullyWriteAndReadWithinIndexKeySizeLimit() {
        this.createIndex();
        String propValue = this.getString(keySizeLimit);
        long expectedNodeId = this.createNode(propValue);
        this.assertReadNode(propValue, expectedNodeId);
    }

    @Test
    public void shouldSuccessfullyPopulateIndexWithinIndexKeySizeLimit() {
        String propValue = this.getString(keySizeLimit);
        long expectedNodeId = this.createNode(propValue);
        this.createIndex();
        this.assertReadNode(propValue, expectedNodeId);
    }

    @Test
    public void txMustFailIfExceedingIndexKeySizeLimit() {
        this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            String propValue = this.getString(keySizeLimit + 1);
            this.db.createNode(new Label[]{TestLabels.LABEL_ONE}).setProperty(propKey, (Object)propValue);
            tx.success();
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Property value size is too large for index. Please see index documentation for limitations."));
        }
    }

    @Test
    public void indexPopulationMustFailIfExceedingIndexKeySizeLimit() {
        String propValue = this.getString(keySizeLimit + 1);
        this.createNode(propValue);
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor((Label)TestLabels.LABEL_ONE).on(propKey).create();
            tx.success();
        }
        try {
            tx = this.db.beginTx();
            var3_4 = null;
            try {
                this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                tx.success();
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var3_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Index entered a FAILED state."));
        }
        tx = this.db.beginTx();
        var3_4 = null;
        try {
            Iterator iterator = this.db.schema().getIndexes((Label)TestLabels.LABEL_ONE).iterator();
            Assert.assertTrue((boolean)iterator.hasNext());
            IndexDefinition next = (IndexDefinition)iterator.next();
            Assert.assertEquals((String)"state is FAILED", (Object)Schema.IndexState.FAILED, (Object)this.db.schema().getIndexState(next));
            Assert.assertThat((Object)this.db.schema().getIndexFailure(next), (Matcher)Matchers.containsString((String)"Index key-value size it to large. Please see index documentation for limitations."));
            tx.success();
        }
        catch (Throwable throwable) {
            var3_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private String getString(int byteArraySize) {
        return RandomStringUtils.randomAlphabetic((int)byteArraySize);
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor((Label)TestLabels.LABEL_ONE).on(propKey).create();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private long createNode(String propValue) {
        long expectedNodeId;
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{TestLabels.LABEL_ONE});
            node.setProperty(propKey, (Object)propValue);
            expectedNodeId = node.getId();
            tx.success();
        }
        return expectedNodeId;
    }

    private void assertReadNode(String propValue, long expectedNodeId) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.findNode((Label)TestLabels.LABEL_ONE, propKey, (Object)propValue);
            Assert.assertNotNull((Object)node);
            Assert.assertEquals((String)"node id", (long)expectedNodeId, (long)node.getId());
            tx.success();
        }
    }
}

