/*
 * Decompiled with CFR 0.152.
 */
package schema;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.RandomValues;

public class IndexPopulationIT {
    @ClassRule
    public static final TestDirectory directory = TestDirectory.testDirectory();
    private static final int TEST_TIMEOUT = 120000;
    private static GraphDatabaseService database;
    private static ExecutorService executorService;

    @BeforeClass
    public static void setUp() {
        database = new GraphDatabaseFactory().newEmbeddedDatabase(directory.storeDir());
        executorService = Executors.newCachedThreadPool();
    }

    @AfterClass
    public static void tearDown() {
        executorService.shutdown();
        database.shutdown();
    }

    @Test(timeout=120000L)
    public void indexCreationDoNotBlockQueryExecutions() throws Exception {
        Label nodeLabel = Label.label((String)"nodeLabel");
        try (Transaction transaction = database.beginTx();){
            database.createNode(new Label[]{nodeLabel});
            transaction.success();
        }
        transaction = database.beginTx();
        var3_3 = null;
        try {
            database.schema().indexFor(Label.label((String)"testLabel")).on("testProperty").create();
            Future<Number> countFuture = executorService.submit(this.countNodes());
            Assert.assertEquals((long)1L, (long)countFuture.get().intValue());
            transaction.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var3_3 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test(timeout=120000L)
    public void createIndexesFromDifferentTransactionsWithoutBlocking() throws ExecutionException, InterruptedException {
        long numberOfIndexesBeforeTest = this.countIndexes();
        Label nodeLabel = Label.label((String)"nodeLabel2");
        String testProperty = "testProperty";
        try (Transaction transaction = database.beginTx();){
            database.schema().indexFor(Label.label((String)"testLabel2")).on(testProperty).create();
            Future<?> creationFuture = executorService.submit(this.createIndexForLabelAndProperty(nodeLabel, testProperty));
            creationFuture.get();
            transaction.success();
        }
        this.waitForOnlineIndexes();
        Assert.assertEquals((long)(numberOfIndexesBeforeTest + 2L), (long)this.countIndexes());
    }

    @Test(timeout=120000L)
    public void indexCreationDoNotBlockWritesOnOtherLabel() throws ExecutionException, InterruptedException {
        Label markerLabel = Label.label((String)"testLabel3");
        Label nodesLabel = Label.label((String)"testLabel4");
        try (Transaction transaction = database.beginTx();){
            database.schema().indexFor(markerLabel).on("testProperty").create();
            Future<?> creation = executorService.submit(this.createNodeWithLabel(nodesLabel));
            creation.get();
            transaction.success();
        }
        transaction = database.beginTx();
        var4_4 = null;
        try (ResourceIterator nodes = database.findNodes(nodesLabel);){
            Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)nodes));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var4_4 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }

    @Test
    public void shutdownDatabaseDuringIndexPopulations() {
        AssertableLogProvider assertableLogProvider = new AssertableLogProvider(true);
        File storeDir = directory.directory("shutdownDbTest");
        Label testLabel = Label.label((String)"testLabel");
        String propertyName = "testProperty";
        GraphDatabaseService shutDownDb = new TestGraphDatabaseFactory().setInternalLogProvider((LogProvider)assertableLogProvider).newEmbeddedDatabase(storeDir);
        this.prePopulateDatabase(shutDownDb, testLabel, propertyName);
        try (Transaction transaction = shutDownDb.beginTx();){
            shutDownDb.schema().indexFor(testLabel).on(propertyName).create();
            transaction.success();
        }
        shutDownDb.shutdown();
        assertableLogProvider.assertNone(AssertableLogProvider.inLog(IndexPopulationJob.class).anyError());
    }

    private void prePopulateDatabase(GraphDatabaseService database, Label testLabel, String propertyName) {
        RandomValues randomValues = RandomValues.create();
        for (int j = 0; j < 10000; ++j) {
            try (Transaction transaction = database.beginTx();){
                Node node = database.createNode(new Label[]{testLabel});
                Object property = randomValues.nextValue().asObject();
                node.setProperty(propertyName, property);
                transaction.success();
                continue;
            }
        }
    }

    private Runnable createNodeWithLabel(Label label) {
        return () -> {
            try (Transaction transaction = database.beginTx();){
                database.createNode(new Label[]{label});
                transaction.success();
            }
        };
    }

    private long countIndexes() {
        try (Transaction transaction = database.beginTx();){
            long l = Iterables.count((Iterable)database.schema().getIndexes());
            return l;
        }
    }

    private Runnable createIndexForLabelAndProperty(Label label, String propertyKey) {
        return () -> {
            try (Transaction transaction = database.beginTx();){
                database.schema().indexFor(label).on(propertyKey).create();
                transaction.success();
            }
            this.waitForOnlineIndexes();
        };
    }

    private void waitForOnlineIndexes() {
        try (Transaction transaction = database.beginTx();){
            database.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            transaction.success();
        }
    }

    private Callable<Number> countNodes() {
        return () -> {
            try (Transaction transaction = database.beginTx();){
                Result result = database.execute("MATCH (n) RETURN count(n) as count");
                Map resultMap = result.next();
                Number number = (Number)resultMap.get("count");
                return number;
            }
        };
    }
}

