/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class BigPropertyIndexValidationIT {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private Label LABEL;
    private String longString;
    private String propertyKey;

    @Before
    public void setup() {
        this.LABEL = Label.label((String)"LABEL");
        char[] chars = new char[32768];
        Arrays.fill(chars, 'c');
        this.longString = new String(chars);
        this.propertyKey = "name";
    }

    @Test
    public void shouldFailTransactionThatIndexesLargePropertyDuringNodeCreation() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        IndexDefinition index = Neo4jMatchers.createIndex((GraphDatabaseService)db, (Label)this.LABEL, (String[])new String[]{this.propertyKey});
        this.expectedException.expect(TransactionFailureException.class);
        try (Transaction tx = db.beginTx();){
            try {
                db.execute("CREATE (n:" + this.LABEL + " {name: \"" + this.longString + "\"})");
                Assert.fail((String)"Argument was illegal");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            ResourceIterator nodes = db.getAllNodes().iterator();
            Assert.assertFalse((boolean)nodes.hasNext());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
    }

    @Test
    public void shouldFailTransactionThatIndexesLargePropertyAfterNodeCreation() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        IndexDefinition index = Neo4jMatchers.createIndex((GraphDatabaseService)db, (Label)this.LABEL, (String[])new String[]{this.propertyKey});
        this.expectedException.expect(TransactionFailureException.class);
        try (Transaction tx = db.beginTx();){
            db.execute("CREATE (n:" + this.LABEL + ")");
            try {
                db.execute("match (n:" + this.LABEL + ")set n.name= \"" + this.longString + "\"");
                Assert.fail((String)"Argument was illegal");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            ResourceIterator nodes = db.getAllNodes().iterator();
            Assert.assertFalse((boolean)nodes.hasNext());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
    }

    @Test
    public void shouldFailTransactionThatIndexesLargePropertyOnLabelAdd() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        IndexDefinition index = Neo4jMatchers.createIndex((GraphDatabaseService)db, (Label)this.LABEL, (String[])new String[]{this.propertyKey});
        this.expectedException.expect(TransactionFailureException.class);
        try (Transaction tx = db.beginTx();){
            String otherLabel = "SomethingElse";
            db.execute("CREATE (n:" + otherLabel + " {name: \"" + this.longString + "\"})");
            try {
                db.execute("match (n:" + otherLabel + ")set n:" + this.LABEL);
                Assert.fail((String)"Argument was illegal");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            ResourceIterator nodes = db.getAllNodes().iterator();
            Assert.assertFalse((boolean)nodes.hasNext());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
    }
}

