/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class MandatoryTransactionsForIndexHitsFacadeTest {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    private IndexHits<Node> indexHits;

    @Before
    public void before() {
        Index<Node> index = this.createIndex();
        this.indexHits = this.queryIndex(index);
    }

    @Test
    public void shouldMandateTransactionsForUsingIterator() {
        try (ResourceIterator iterator = this.indexHits.iterator();){
            try {
                iterator.hasNext();
                Assert.fail((String)"Transactions are mandatory, also for reads");
            }
            catch (NotInTransactionException notInTransactionException) {
                // empty catch block
            }
            try {
                iterator.next();
                Assert.fail((String)"Transactions are mandatory, also for reads");
            }
            catch (NotInTransactionException notInTransactionException) {
                // empty catch block
            }
        }
    }

    @Test
    public void shouldMandateTransactionsForGetSingle() {
        try {
            this.indexHits.getSingle();
            Assert.fail((String)"Transactions are mandatory, also for reads");
        }
        catch (NotInTransactionException notInTransactionException) {
            // empty catch block
        }
    }

    private Index<Node> createIndex() {
        GraphDatabaseAPI graphDatabaseService = this.dbRule.getGraphDatabaseAPI();
        try (Transaction transaction = graphDatabaseService.beginTx();){
            Index index = graphDatabaseService.index().forNodes("foo");
            transaction.success();
            Index index2 = index;
            return index2;
        }
    }

    private IndexHits<Node> queryIndex(Index<Node> index) {
        GraphDatabaseAPI graphDatabaseService = this.dbRule.getGraphDatabaseAPI();
        try (Transaction ignored = graphDatabaseService.beginTx();){
            IndexHits hits = index.get("foo", (Object)42);
            hits.close();
            IndexHits indexHits = hits;
            return indexHits;
        }
    }
}

