/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Optional;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextConfig;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProviderFactory;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.storageengine.api.EntityType;

public class FulltextAnalyzerTest
extends LuceneFulltextTestSupport {
    public static final String ENGLISH = "english";
    public static final String SWEDISH = "swedish";
    public static final String FOLDING = "standard-folding";

    @Test
    public void shouldBeAbleToSpecifyEnglishAnalyzer() throws Exception {
        long id;
        IndexReference nodes;
        this.applySetting((Setting<String>)FulltextConfig.fulltext_default_analyzer, ENGLISH);
        SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            SchemaWrite schemaWrite = transaction.schemaWrite();
            nodes = schemaWrite.indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of("nodes"));
            transaction.success();
        }
        this.await(nodes);
        try (Transaction tx = this.db.beginTx();){
            this.createNodeIndexableByPropertyValue(LABEL, "Hello and hello again, in the end.");
            id = this.createNodeIndexableByPropertyValue(LABEL, "En apa och en tomte bodde i ett hus.");
            tx.success();
        }
        tx = this.db.beginTx();
        var6_10 = null;
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            this.assertQueryFindsNothing(ktx, "nodes", "and");
            this.assertQueryFindsNothing(ktx, "nodes", "in");
            this.assertQueryFindsNothing(ktx, "nodes", "the");
            this.assertQueryFindsIds(ktx, "nodes", "en", id);
            this.assertQueryFindsIds(ktx, "nodes", "och", id);
            this.assertQueryFindsIds(ktx, "nodes", "ett", id);
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_10 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_10.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToSpecifySwedishAnalyzer() throws Exception {
        long id;
        IndexReference nodes;
        this.applySetting((Setting<String>)FulltextConfig.fulltext_default_analyzer, SWEDISH);
        SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            SchemaWrite schemaWrite = transaction.schemaWrite();
            nodes = schemaWrite.indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of("nodes"));
            transaction.success();
        }
        this.await(nodes);
        try (Transaction tx = this.db.beginTx();){
            id = this.createNodeIndexableByPropertyValue(LABEL, "Hello and hello again, in the end.");
            this.createNodeIndexableByPropertyValue(LABEL, "En apa och en tomte bodde i ett hus.");
            tx.success();
        }
        tx = this.db.beginTx();
        var6_10 = null;
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, "nodes", "and", id);
            this.assertQueryFindsIds(ktx, "nodes", "in", id);
            this.assertQueryFindsIds(ktx, "nodes", "the", id);
            this.assertQueryFindsNothing(ktx, "nodes", "en");
            this.assertQueryFindsNothing(ktx, "nodes", "och");
            this.assertQueryFindsNothing(ktx, "nodes", "ett");
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_10 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_10.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToSpecifyFoldingAnalyzer() throws Exception {
        long id;
        IndexReference nodes;
        this.applySetting((Setting<String>)FulltextConfig.fulltext_default_analyzer, FOLDING);
        SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            SchemaWrite schemaWrite = transaction.schemaWrite();
            nodes = schemaWrite.indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of("nodes"));
            transaction.success();
        }
        this.await(nodes);
        try (Transaction tx = this.db.beginTx();){
            id = this.createNodeIndexableByPropertyValue(LABEL, "P\u0159\u00edli\u0161 \u017elu\u0165ou\u010dk\u00fd k\u016f\u0148 \u00fap\u011bl \u010f\u00e1belsk\u00e9 \u00f3dy.");
            tx.success();
        }
        tx = this.db.beginTx();
        var6_10 = null;
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, "nodes", "prilis", id);
            this.assertQueryFindsIds(ktx, "nodes", "zlutoucky", id);
            this.assertQueryFindsIds(ktx, "nodes", "kun", id);
            this.assertQueryFindsIds(ktx, "nodes", "upel", id);
            this.assertQueryFindsIds(ktx, "nodes", "dabelske", id);
            this.assertQueryFindsIds(ktx, "nodes", "ody", id);
        }
        catch (Throwable throwable) {
            var6_10 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_10 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_10.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotReindexNodesWhenDefaultAnalyzerIsChanged() throws Exception {
        long secondID;
        IndexReference nodes;
        this.applySetting((Setting<String>)FulltextConfig.fulltext_default_analyzer, ENGLISH);
        SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            SchemaWrite schemaWrite = transaction.schemaWrite();
            nodes = schemaWrite.indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of("nodes"));
            transaction.success();
        }
        this.await(nodes);
        var8_3 = null;
        try (Transaction tx = this.db.beginTx();){
            long firstID = this.createNodeIndexableByPropertyValue(LABEL, "Hello and hello again, in the end.");
            secondID = this.createNodeIndexableByPropertyValue(LABEL, "En apa och en tomte bodde i ett hus.");
            tx.success();
        }
        catch (Throwable schemaWrite) {
            var8_3 = schemaWrite;
            throw schemaWrite;
        }
        tx = this.db.beginTx();
        var8_3 = null;
        try {
            KernelTransaction ktx = FulltextAnalyzerTest.kernelTransaction(tx);
            this.assertQueryFindsNothing(ktx, "nodes", "and");
            this.assertQueryFindsNothing(ktx, "nodes", "in");
            this.assertQueryFindsNothing(ktx, "nodes", "the");
            this.assertQueryFindsIds(ktx, "nodes", "en", secondID);
            this.assertQueryFindsIds(ktx, "nodes", "och", secondID);
            this.assertQueryFindsIds(ktx, "nodes", "ett", secondID);
        }
        catch (Throwable ktx) {
            var8_3 = ktx;
            throw ktx;
        }
        finally {
            if (tx != null) {
                if (var8_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable ktx) {
                        var8_3.addSuppressed(ktx);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.applySetting((Setting<String>)FulltextConfig.fulltext_default_analyzer, SWEDISH);
        var8_3 = null;
        try (KernelTransactionImplementation ktx = this.getKernelTransaction();){
            SchemaRead schemaRead = ktx.schemaRead();
            this.await(schemaRead.indexGetForName("nodes"));
            this.assertQueryFindsNothing((KernelTransaction)ktx, "nodes", "and");
            this.assertQueryFindsNothing((KernelTransaction)ktx, "nodes", "in");
            this.assertQueryFindsNothing((KernelTransaction)ktx, "nodes", "the");
            this.assertQueryFindsIds((KernelTransaction)ktx, "nodes", "en", secondID);
            this.assertQueryFindsIds((KernelTransaction)ktx, "nodes", "och", secondID);
            this.assertQueryFindsIds((KernelTransaction)ktx, "nodes", "ett", secondID);
        }
        catch (Throwable throwable) {
            var8_3 = throwable;
            throw throwable;
        }
    }
}

