/*
 * Decompiled with CFR 0.152.
 */
package schema;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.index.schema.config.SpatialIndexValueTestUtil;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.PointValue;

@ExtendWith(value={TestDirectoryExtension.class})
class UniqueSpatialIndexIT {
    private static final String KEY = "prop";
    private static final TestLabels LABEL = TestLabels.LABEL_ONE;
    @Inject
    private TestDirectory directory;
    private GraphDatabaseService db;
    private PointValue point1;
    private PointValue point2;

    UniqueSpatialIndexIT() {
    }

    @BeforeEach
    void setup() {
        Pair collidingPoints = SpatialIndexValueTestUtil.pointsWithSameValueOnSpaceFillingCurve((Config)Config.defaults());
        this.point1 = (PointValue)collidingPoints.first();
        this.point2 = (PointValue)collidingPoints.other();
    }

    @AfterEach
    void tearDown() {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"providerSettings"})
    void shouldPopulateIndexWithUniquePointsThatCollideOnSpaceFillingCurve(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.setupDb(schemaIndex);
        Pair<Long, Long> nodeIds = this.createUniqueNodes();
        this.createUniquenessConstraint();
        this.assertBothNodesArePresent(nodeIds);
    }

    @ParameterizedTest
    @MethodSource(value={"providerSettings"})
    void shouldAddPointsThatCollideOnSpaceFillingCurveToUniqueIndexInSameTx(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.setupDb(schemaIndex);
        this.createUniquenessConstraint();
        Pair<Long, Long> nodeIds = this.createUniqueNodes();
        this.assertBothNodesArePresent(nodeIds);
    }

    @ParameterizedTest
    @MethodSource(value={"providerSettings"})
    void shouldThrowWhenPopulatingWithNonUniquePoints(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.setupDb(schemaIndex);
        this.createNonUniqueNodes();
        Assertions.assertThrows(ConstraintViolationException.class, this::createUniquenessConstraint);
    }

    @ParameterizedTest
    @MethodSource(value={"providerSettings"})
    void shouldThrowWhenAddingNonUniquePoints(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        this.setupDb(schemaIndex);
        this.createUniquenessConstraint();
        Assertions.assertThrows(ConstraintViolationException.class, this::createNonUniqueNodes);
    }

    private static Stream<GraphDatabaseSettings.SchemaIndex> providerSettings() {
        return Arrays.stream(GraphDatabaseSettings.SchemaIndex.values());
    }

    private void createNonUniqueNodes() {
        try (Transaction tx = this.db.beginTx();){
            Node originNode = this.db.createNode(new Label[]{LABEL});
            originNode.setProperty(KEY, (Object)this.point1);
            Node centerNode = this.db.createNode(new Label[]{LABEL});
            centerNode.setProperty(KEY, (Object)this.point1);
            tx.success();
        }
    }

    private Pair<Long, Long> createUniqueNodes() {
        Pair nodeIds;
        try (Transaction tx = this.db.beginTx();){
            Node originNode = this.db.createNode(new Label[]{LABEL});
            originNode.setProperty(KEY, (Object)this.point1);
            Node centerNode = this.db.createNode(new Label[]{LABEL});
            centerNode.setProperty(KEY, (Object)this.point2);
            nodeIds = Pair.of((Object)originNode.getId(), (Object)centerNode.getId());
            tx.success();
        }
        return nodeIds;
    }

    private void assertBothNodesArePresent(Pair<Long, Long> nodeIds) {
        try (Transaction tx = this.db.beginTx();){
            ResourceIterator origin = this.db.findNodes((Label)LABEL, KEY, (Object)this.point1);
            Assertions.assertTrue((boolean)origin.hasNext());
            Assert.assertEquals((long)((Long)nodeIds.first()), (long)((Node)origin.next()).getId());
            Assertions.assertFalse((boolean)origin.hasNext());
            ResourceIterator center = this.db.findNodes((Label)LABEL, KEY, (Object)this.point2);
            Assertions.assertTrue((boolean)center.hasNext());
            Assert.assertEquals((long)((Long)nodeIds.other()), (long)((Node)center.next()).getId());
            Assertions.assertFalse((boolean)center.hasNext());
            tx.success();
        }
    }

    private void createUniquenessConstraint() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor((Label)TestLabels.LABEL_ONE).assertPropertyIsUnique(KEY).create();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void setupDb(GraphDatabaseSettings.SchemaIndex schemaIndex) {
        TestGraphDatabaseFactory dbFactory = new TestGraphDatabaseFactory();
        GraphDatabaseBuilder builder = dbFactory.newEmbeddedDatabaseBuilder(this.directory.storeDir()).setConfig(GraphDatabaseSettings.default_schema_provider, schemaIndex.providerName());
        this.db = builder.newGraphDatabase();
    }
}

