/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.recovery;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class UniqueIndexRecoveryTest {
    @Rule
    public final TestDirectory storeDir = TestDirectory.testDirectory();
    private static final String PROPERTY_KEY = "key";
    private static final String PROPERTY_VALUE = "value";
    private static final Label LABEL = Label.label((String)"label");
    private final TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
    private GraphDatabaseAPI db;
    @Parameterized.Parameter
    public GraphDatabaseSettings.SchemaIndex schemaIndex;

    @Parameterized.Parameters(name="{0}")
    public static GraphDatabaseSettings.SchemaIndex[] parameters() {
        return GraphDatabaseSettings.SchemaIndex.values();
    }

    @Before
    public void before() {
        this.db = (GraphDatabaseAPI)this.newDb();
    }

    @After
    public void after() {
        this.db.shutdown();
    }

    @Test
    public void shouldRecoverCreationOfUniquenessConstraintFollowedByDeletionOfThatSameConstraint() throws Exception {
        this.createUniqueConstraint();
        this.dropConstraints();
        this.restart(UniqueIndexRecoveryTest.snapshot(this.storeDir.absolutePath()));
        try (Transaction tx = this.db.beginTx();){
            Assert.assertFalse((boolean)this.db.schema().getConstraints(LABEL).iterator().hasNext());
            tx.success();
        }
    }

    @Test
    public void shouldRecoverWhenCommandsTemporarilyViolateConstraints() throws Exception {
        Node unLabeledNode = this.createUnLabeledNodeWithProperty();
        Node labeledNode = this.createLabeledNode();
        this.createUniqueConstraint();
        this.rotateLogAndCheckPoint();
        this.setPropertyOnLabeledNode(labeledNode);
        this.deletePropertyOnLabeledNode(labeledNode);
        this.addLabelToUnLabeledNode(unLabeledNode);
        this.flushAll();
        this.restart(UniqueIndexRecoveryTest.snapshot(this.storeDir.absolutePath()));
        try (Transaction tx = this.db.beginTx();){
            MatcherAssert.assertThat((Object)this.db.findNode(LABEL, PROPERTY_KEY, (Object)PROPERTY_VALUE), (Matcher)IsEqual.equalTo((Object)unLabeledNode));
            tx.success();
        }
    }

    private void restart(File newStore) {
        this.db.shutdown();
        this.db = (GraphDatabaseAPI)this.newDb();
    }

    private GraphDatabaseService newDb() {
        return this.factory.newEmbeddedDatabaseBuilder(this.storeDir.absolutePath()).setConfig(GraphDatabaseSettings.default_schema_provider, this.schemaIndex.providerName()).newGraphDatabase();
    }

    private static File snapshot(File path) throws IOException {
        File snapshotDir = new File(path, "snapshot-" + new Random().nextInt());
        FileUtils.copyRecursively((File)path, (File)snapshotDir, pathName -> {
            String subPath = pathName.getAbsolutePath().substring(path.getPath().length() + 1);
            return !"store_lock".equals(subPath) && !subPath.endsWith("write.lock");
        });
        return snapshotDir;
    }

    private void addLabelToUnLabeledNode(Node unLabeledNode) {
        try (Transaction tx = this.db.beginTx();){
            unLabeledNode.addLabel(LABEL);
            tx.success();
        }
    }

    private void setPropertyOnLabeledNode(Node labeledNode) {
        try (Transaction tx = this.db.beginTx();){
            labeledNode.setProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE);
            tx.success();
        }
    }

    private void deletePropertyOnLabeledNode(Node labeledNode) {
        try (Transaction tx = this.db.beginTx();){
            labeledNode.removeProperty(PROPERTY_KEY);
            tx.success();
        }
    }

    private void createUniqueConstraint() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().constraintFor(LABEL).assertPropertyIsUnique(PROPERTY_KEY).create();
            tx.success();
        }
    }

    private Node createLabeledNode() {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{LABEL});
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private Node createUnLabeledNodeWithProperty() {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.setProperty(PROPERTY_KEY, (Object)PROPERTY_VALUE);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private void dropConstraints() {
        try (Transaction tx = this.db.beginTx();){
            for (ConstraintDefinition constraint : this.db.schema().getConstraints(LABEL)) {
                constraint.drop();
            }
            tx.success();
        }
    }

    private void rotateLogAndCheckPoint() throws IOException {
        ((LogRotation)this.db.getDependencyResolver().resolveDependency(LogRotation.class)).rotateLogFile();
        ((CheckPointer)this.db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }

    private void flushAll() {
        ((StorageEngine)this.db.getDependencyResolver().resolveDependency(StorageEngine.class)).flushAndForce(IOLimiter.UNLIMITED);
    }
}

