/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.tracking;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.annotations.ReporterFactory;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.tracking.TrackingIndexReader;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.values.storable.Value;

public class TrackingReadersIndexAccessor
implements IndexAccessor {
    private final IndexAccessor accessor;
    private static final AtomicLong openReaders = new AtomicLong();
    private static final AtomicLong closedReaders = new AtomicLong();

    public static long numberOfOpenReaders() {
        return openReaders.get();
    }

    public static long numberOfClosedReaders() {
        return closedReaders.get();
    }

    TrackingReadersIndexAccessor(IndexAccessor accessor) {
        this.accessor = accessor;
    }

    public void drop() {
        this.accessor.drop();
    }

    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        return this.accessor.newUpdater(mode);
    }

    public void force(IOLimiter ioLimiter) {
        this.accessor.force(ioLimiter);
    }

    public void refresh() {
        this.accessor.refresh();
    }

    public void close() {
        this.accessor.close();
    }

    public IndexReader newReader() {
        openReaders.incrementAndGet();
        return new TrackingIndexReader(this.accessor.newReader(), closedReaders);
    }

    public BoundedIterable<Long> newAllEntriesReader() {
        return this.accessor.newAllEntriesReader();
    }

    public ResourceIterator<File> snapshotFiles() {
        return this.accessor.snapshotFiles();
    }

    public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
        this.accessor.verifyDeferredConstraints(nodePropertyAccessor);
    }

    public boolean isDirty() {
        return this.accessor.isDirty();
    }

    public void validateBeforeCommit(Value[] tuple) {
        this.accessor.validateBeforeCommit(tuple);
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory) {
        return this.accessor.consistencyCheck(reporterFactory);
    }
}

