/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

public class ShutdownOnIndexUpdateIT {
    @Rule
    public DatabaseRule database = new ImpermanentDatabaseRule();
    private static final String UNIQUE_PROPERTY_NAME = "uniquePropertyName";
    private static final AtomicLong indexProvider = new AtomicLong();
    private static Label constraintIndexLabel = Label.label((String)"ConstraintIndexLabel");

    @Test
    public void shutdownWhileFinishingTransactionWithIndexUpdates() {
        this.createConstraint((GraphDatabaseService)this.database);
        this.waitIndexesOnline((GraphDatabaseService)this.database);
        try (Transaction transaction = this.database.beginTx();){
            Node node = this.database.createNode(new Label[]{constraintIndexLabel});
            node.setProperty(UNIQUE_PROPERTY_NAME, (Object)indexProvider.getAndIncrement());
            DependencyResolver dependencyResolver = this.database.getDependencyResolver();
            NeoStoreDataSource dataSource = (NeoStoreDataSource)dependencyResolver.resolveDependency(NeoStoreDataSource.class);
            LifeSupport dataSourceLife = dataSource.getLife();
            TransactionCloseListener closeListener = new TransactionCloseListener(transaction);
            dataSourceLife.addLifecycleListener((LifecycleListener)closeListener);
            dataSource.stop();
            Assert.assertTrue((String)"Transaction should be closed and no exception should be thrown.", (boolean)closeListener.isTransactionClosed());
        }
    }

    private void waitIndexesOnline(GraphDatabaseService database) {
        try (Transaction ignored = database.beginTx();){
            database.schema().awaitIndexesOnline(5L, TimeUnit.MINUTES);
        }
    }

    private void createConstraint(GraphDatabaseService database) {
        try (Transaction transaction = database.beginTx();){
            Schema schema = database.schema();
            schema.constraintFor(constraintIndexLabel).assertPropertyIsUnique(UNIQUE_PROPERTY_NAME).create();
            transaction.success();
        }
    }

    private static class TransactionCloseListener
    implements LifecycleListener {
        private final Transaction transaction;
        private boolean transactionClosed;

        TransactionCloseListener(Transaction transaction) {
            this.transaction = transaction;
        }

        public void notifyStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
            if (LifecycleStatus.STOPPED == to && instance instanceof RecordStorageEngine) {
                this.transaction.success();
                this.transaction.close();
                this.transactionClosed = true;
            }
        }

        boolean isTransactionClosed() {
            return this.transactionClosed;
        }
    }
}

