/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.backup;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.commons.io.FilenameUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;

public class IndexBackupIT {
    private static final String PROPERTY_PREFIX = "property";
    private static final int NUMBER_OF_INDEXES = 10;
    @Rule
    public RandomRule randomRule = new RandomRule();
    @Rule
    public EmbeddedDatabaseRule database = new EmbeddedDatabaseRule().startLazily();
    private CheckPointer checkPointer;
    private IndexingService indexingService;
    private FileSystemAbstraction fileSystem;

    @Test
    public void concurrentLuceneIndexSnapshotUseDifferentSnapshots() throws Exception {
        Label label = Label.label((String)"testLabel");
        this.database.withSetting(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE20.providerName());
        this.prepareDatabase(label);
        this.forceCheckpoint(this.checkPointer);
        ResourceIterator firstCheckpointSnapshot = this.indexingService.snapshotIndexFiles();
        this.generateData(label);
        this.removeOldNodes(LongStream.range(1L, 20L));
        this.updateOldNodes(LongStream.range(30L, 40L));
        this.forceCheckpoint(this.checkPointer);
        ResourceIterator secondCheckpointSnapshot = this.indexingService.snapshotIndexFiles();
        this.generateData(label);
        this.removeOldNodes(LongStream.range(50L, 60L));
        this.updateOldNodes(LongStream.range(70L, 80L));
        this.forceCheckpoint(this.checkPointer);
        ResourceIterator thirdCheckpointSnapshot = this.indexingService.snapshotIndexFiles();
        Set<String> firstSnapshotFileNames = this.getFileNames((ResourceIterator<File>)firstCheckpointSnapshot);
        Set<String> secondSnapshotFileNames = this.getFileNames((ResourceIterator<File>)secondCheckpointSnapshot);
        Set<String> thirdSnapshotFileNames = this.getFileNames((ResourceIterator<File>)thirdCheckpointSnapshot);
        this.compareSnapshotFiles(firstSnapshotFileNames, secondSnapshotFileNames, this.fileSystem);
        this.compareSnapshotFiles(secondSnapshotFileNames, thirdSnapshotFileNames, this.fileSystem);
        this.compareSnapshotFiles(thirdSnapshotFileNames, firstSnapshotFileNames, this.fileSystem);
        firstCheckpointSnapshot.close();
        secondCheckpointSnapshot.close();
        thirdCheckpointSnapshot.close();
    }

    @Test
    public void snapshotFilesDeletedWhenSnapshotReleased() throws IOException {
        Label label = Label.label((String)"testLabel");
        this.prepareDatabase(label);
        ResourceIterator firstCheckpointSnapshot = this.indexingService.snapshotIndexFiles();
        this.generateData(label);
        ResourceIterator secondCheckpointSnapshot = this.indexingService.snapshotIndexFiles();
        this.generateData(label);
        ResourceIterator thirdCheckpointSnapshot = this.indexingService.snapshotIndexFiles();
        Set<String> firstSnapshotFileNames = this.getFileNames((ResourceIterator<File>)firstCheckpointSnapshot);
        Set<String> secondSnapshotFileNames = this.getFileNames((ResourceIterator<File>)secondCheckpointSnapshot);
        Set<String> thirdSnapshotFileNames = this.getFileNames((ResourceIterator<File>)thirdCheckpointSnapshot);
        this.generateData(label);
        this.forceCheckpoint(this.checkPointer);
        Assert.assertTrue((boolean)firstSnapshotFileNames.stream().map(File::new).allMatch(arg_0 -> ((FileSystemAbstraction)this.fileSystem).fileExists(arg_0)));
        Assert.assertTrue((boolean)secondSnapshotFileNames.stream().map(File::new).allMatch(arg_0 -> ((FileSystemAbstraction)this.fileSystem).fileExists(arg_0)));
        Assert.assertTrue((boolean)thirdSnapshotFileNames.stream().map(File::new).allMatch(arg_0 -> ((FileSystemAbstraction)this.fileSystem).fileExists(arg_0)));
        firstCheckpointSnapshot.close();
        secondCheckpointSnapshot.close();
        thirdCheckpointSnapshot.close();
        this.generateData(label);
        this.forceCheckpoint(this.checkPointer);
        Assert.assertFalse((boolean)firstSnapshotFileNames.stream().map(File::new).anyMatch(arg_0 -> ((FileSystemAbstraction)this.fileSystem).fileExists(arg_0)));
        Assert.assertFalse((boolean)secondSnapshotFileNames.stream().map(File::new).anyMatch(arg_0 -> ((FileSystemAbstraction)this.fileSystem).fileExists(arg_0)));
        Assert.assertFalse((boolean)thirdSnapshotFileNames.stream().map(File::new).anyMatch(arg_0 -> ((FileSystemAbstraction)this.fileSystem).fileExists(arg_0)));
    }

    private void compareSnapshotFiles(Set<String> firstSnapshotFileNames, Set<String> secondSnapshotFileNames, FileSystemAbstraction fileSystem) {
        Assert.assertThat((String)String.format("Should have %d modified index segment files. Snapshot segment files are: %s", 10, firstSnapshotFileNames), firstSnapshotFileNames, (Matcher)Matchers.hasSize((int)10));
        for (String fileName : firstSnapshotFileNames) {
            Assert.assertFalse((String)("Snapshot segments fileset should not have files from another snapshot set." + this.describeFileSets(firstSnapshotFileNames, secondSnapshotFileNames)), (boolean)secondSnapshotFileNames.contains(fileName));
            String path = FilenameUtils.getFullPath((String)fileName);
            Assert.assertTrue((String)("Snapshot should contain files for index in path: " + path + "." + this.describeFileSets(firstSnapshotFileNames, secondSnapshotFileNames)), (boolean)secondSnapshotFileNames.stream().anyMatch(name -> name.startsWith(path)));
            Assert.assertTrue((String)String.format("Snapshot segment file '%s' should exist.", fileName), (boolean)fileSystem.fileExists(new File(fileName)));
        }
    }

    private void removeOldNodes(LongStream idRange) {
        try (Transaction transaction = this.database.beginTx();){
            idRange.mapToObj(id -> this.database.getNodeById(id)).forEach(Node::delete);
            transaction.success();
        }
    }

    private void updateOldNodes(LongStream idRange) {
        try (Transaction transaction = this.database.beginTx();){
            List<Node> nodes = idRange.mapToObj(id -> this.database.getNodeById(id)).collect(Collectors.toList());
            for (int i = 0; i < 10; ++i) {
                String propertyName = PROPERTY_PREFIX + i;
                nodes.forEach(node -> node.setProperty(propertyName, (Object)this.randomRule.nextLong()));
            }
            transaction.success();
        }
    }

    private String describeFileSets(Set<String> firstFileSet, Set<String> secondFileSet) {
        return "First snapshot files are: " + firstFileSet + System.lineSeparator() + "second snapshot files are: " + secondFileSet;
    }

    private Set<String> getFileNames(ResourceIterator<File> files) {
        return files.stream().map(File::getAbsolutePath).filter(this::segmentsFilePredicate).collect(Collectors.toSet());
    }

    private void forceCheckpoint(CheckPointer checkPointer) throws IOException {
        checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("testForcedCheckpoint"));
    }

    private void prepareDatabase(Label label) {
        this.generateData(label);
        try (Transaction transaction = this.database.beginTx();){
            for (int i = 0; i < 10; ++i) {
                this.database.schema().indexFor(label).on(PROPERTY_PREFIX + i).create();
            }
            transaction.success();
        }
        var3_3 = null;
        try (Transaction ignored = this.database.beginTx();){
            this.database.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        this.checkPointer = this.resolveDependency(CheckPointer.class);
        this.indexingService = this.resolveDependency(IndexingService.class);
        this.fileSystem = this.resolveDependency(FileSystemAbstraction.class);
    }

    private void generateData(Label label) {
        for (int i = 0; i < 100; ++i) {
            this.testNodeCreationTransaction(label, i);
        }
    }

    private void testNodeCreationTransaction(Label label, int i) {
        try (Transaction transaction = this.database.beginTx();){
            Node node = this.database.createNode(new Label[]{label});
            node.setProperty(PROPERTY_PREFIX + i, (Object)i);
            transaction.success();
        }
    }

    private <T> T resolveDependency(Class<T> clazz) {
        return (T)this.getDatabaseResolver().resolveDependency(clazz);
    }

    private DependencyResolver getDatabaseResolver() {
        return this.database.getDependencyResolver();
    }

    private boolean segmentsFilePredicate(String fileName) {
        return FilenameUtils.getName((String)fileName).startsWith("segments");
    }
}

