/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

@RunWith(value=Parameterized.class)
public class IndexingServiceIntegrationTest {
    private static final String FOOD_LABEL = "food";
    private static final String CLOTHES_LABEL = "clothes";
    private static final String WEATHER_LABEL = "weather";
    private static final String PROPERTY_NAME = "name";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private GraphDatabaseService database;
    @Parameterized.Parameter
    public GraphDatabaseSettings.SchemaIndex schemaIndex;

    @Parameterized.Parameters(name="{0}")
    public static GraphDatabaseSettings.SchemaIndex[] parameters() {
        return GraphDatabaseSettings.SchemaIndex.values();
    }

    @Before
    public void setUp() {
        EphemeralFileSystemAbstraction fileSystem = (EphemeralFileSystemAbstraction)this.fileSystemRule.get();
        this.database = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fileSystem).newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.default_schema_provider, this.schemaIndex.providerName()).newGraphDatabase();
        this.createData(this.database, 100);
    }

    @After
    public void tearDown() {
        try {
            this.database.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testManualIndexPopulation() throws InterruptedException, IndexNotFoundKernelException {
        try (org.neo4j.graphdb.Transaction tx = this.database.beginTx();){
            this.database.schema().indexFor(Label.label((String)FOOD_LABEL)).on(PROPERTY_NAME).create();
            tx.success();
        }
        int labelId = this.getLabelId(FOOD_LABEL);
        int propertyKeyId = this.getPropertyKeyId(PROPERTY_NAME);
        IndexingService indexingService = this.getIndexingService(this.database);
        IndexProxy indexProxy = indexingService.getIndexProxy((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId}));
        this.waitIndexOnline(indexProxy);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
        PopulationProgress progress = indexProxy.getIndexPopulationProgress();
        Assert.assertEquals((long)progress.getCompleted(), (long)progress.getTotal());
    }

    @Test
    public void testManualRelationshipIndexPopulation() throws Exception {
        RelationTypeSchemaDescriptor descriptor;
        try (Transaction tx = ((Kernel)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(Kernel.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);){
            int foodId = tx.tokenWrite().relationshipTypeGetOrCreateForName(FOOD_LABEL);
            int propertyId = tx.tokenWrite().propertyKeyGetOrCreateForName(PROPERTY_NAME);
            descriptor = SchemaDescriptorFactory.forRelType((int)foodId, (int[])new int[]{propertyId});
            tx.schemaWrite().indexCreate((SchemaDescriptor)descriptor);
            tx.success();
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        IndexProxy indexProxy = indexingService.getIndexProxy((SchemaDescriptor)descriptor);
        this.waitIndexOnline(indexProxy);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
        PopulationProgress progress = indexProxy.getIndexPopulationProgress();
        Assert.assertEquals((long)progress.getCompleted(), (long)progress.getTotal());
    }

    @Test
    public void testSchemaIndexMatchIndexingService() throws IndexNotFoundKernelException {
        try (org.neo4j.graphdb.Transaction transaction = this.database.beginTx();){
            this.database.schema().constraintFor(Label.label((String)CLOTHES_LABEL)).assertPropertyIsUnique(PROPERTY_NAME).create();
            this.database.schema().indexFor(Label.label((String)WEATHER_LABEL)).on(PROPERTY_NAME).create();
            transaction.success();
        }
        var2_2 = null;
        try (org.neo4j.graphdb.Transaction ignored = this.database.beginTx();){
            this.database.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        int clothedLabelId = this.getLabelId(CLOTHES_LABEL);
        int weatherLabelId = this.getLabelId(WEATHER_LABEL);
        int propertyId = this.getPropertyKeyId(PROPERTY_NAME);
        IndexProxy clothesIndex = indexingService.getIndexProxy((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)clothedLabelId, (int[])new int[]{propertyId}));
        IndexProxy weatherIndex = indexingService.getIndexProxy((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)weatherLabelId, (int[])new int[]{propertyId}));
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)clothesIndex.getState());
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)weatherIndex.getState());
    }

    @Test
    public void failForceIndexesWhenOneOfTheIndexesIsBroken() throws Exception {
        Object transaction;
        String constraintLabelPrefix = "ConstraintLabel";
        String constraintPropertyPrefix = "ConstraintProperty";
        String indexLabelPrefix = "Label";
        String indexPropertyPrefix = "Property";
        for (int i = 0; i < 10; ++i) {
            transaction = this.database.beginTx();
            Throwable throwable = null;
            try {
                this.database.schema().constraintFor(Label.label((String)(constraintLabelPrefix + i))).assertPropertyIsUnique(constraintPropertyPrefix + i).create();
                this.database.schema().indexFor(Label.label((String)(indexLabelPrefix + i))).on(indexPropertyPrefix + i).create();
                transaction.success();
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (transaction != null) {
                    if (throwable != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        transaction.close();
                    }
                }
            }
        }
        org.neo4j.graphdb.Transaction ignored = this.database.beginTx();
        transaction = null;
        try {
            this.database.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        catch (Throwable throwable) {
            transaction = throwable;
            throw throwable;
        }
        finally {
            if (ignored != null) {
                if (transaction != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)transaction).addSuppressed(throwable);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        int indexLabel7 = this.getLabelId(indexLabelPrefix + 7);
        int indexProperty7 = this.getPropertyKeyId(indexPropertyPrefix + 7);
        IndexProxy index = indexingService.getIndexProxy(TestIndexDescriptorFactory.forLabel((int)indexLabel7, (int[])new int[]{indexProperty7}).schema());
        index.drop();
        this.expectedException.expect(UnderlyingStorageException.class);
        this.expectedException.expectMessage("Unable to force");
        indexingService.forceAll(IOLimiter.UNLIMITED);
    }

    private void waitIndexOnline(IndexProxy indexProxy) throws InterruptedException {
        while (InternalIndexState.ONLINE != indexProxy.getState()) {
            Thread.sleep(10L);
        }
    }

    private IndexingService getIndexingService(GraphDatabaseService database) {
        return (IndexingService)this.getDependencyResolver(database).resolveDependency(IndexingService.class);
    }

    private DependencyResolver getDependencyResolver(GraphDatabaseService database) {
        return ((GraphDatabaseAPI)database).getDependencyResolver();
    }

    private void createData(GraphDatabaseService database, int numberOfNodes) {
        for (int i = 0; i < numberOfNodes; ++i) {
            try (org.neo4j.graphdb.Transaction transaction = database.beginTx();){
                Node node = database.createNode(new Label[]{Label.label((String)FOOD_LABEL), Label.label((String)CLOTHES_LABEL), Label.label((String)WEATHER_LABEL)});
                node.setProperty(PROPERTY_NAME, (Object)("Node" + i));
                Relationship relationship = node.createRelationshipTo(node, RelationshipType.withName((String)FOOD_LABEL));
                relationship.setProperty(PROPERTY_NAME, (Object)("Relationship" + i));
                transaction.success();
                continue;
            }
        }
    }

    private int getPropertyKeyId(String name) {
        try (org.neo4j.graphdb.Transaction tx = this.database.beginTx();){
            KernelTransaction transaction = ((ThreadToStatementContextBridge)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
            int n = transaction.tokenRead().propertyKey(name);
            return n;
        }
    }

    private int getLabelId(String name) {
        try (org.neo4j.graphdb.Transaction tx = this.database.beginTx();){
            KernelTransaction transaction = ((ThreadToStatementContextBridge)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
            int n = transaction.tokenRead().nodeLabel(name);
            return n;
        }
    }
}

