/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class IndexFreshDataReadIT {
    @Rule
    public EmbeddedDatabaseRule databaseRule = new EmbeddedDatabaseRule();
    private ExecutorService executor = Executors.newCachedThreadPool();

    @After
    public void tearDown() {
        this.executor.shutdown();
    }

    @Test
    public void readLatestIndexDataAfterUsingExhaustedNodeRelationshipIterator() throws Exception {
        try (Transaction transaction = this.databaseRule.beginTx();){
            this.addStaffMember("Fry");
            Assert.assertEquals((long)1L, (long)this.countStaff().intValue());
            Node fry = this.databaseRule.getNodeById(0L);
            Iterable fryRelationships = fry.getRelationships();
            Assert.assertFalse((boolean)fryRelationships.iterator().hasNext());
            this.addStaffMember("Lila");
            Assert.assertEquals((long)2L, (long)this.countStaff().intValue());
            this.addStaffMember("Bender");
            Assert.assertEquals((long)3L, (long)this.countStaff().intValue());
        }
    }

    private void addStaffMember(String name) throws InterruptedException, ExecutionException {
        this.executor.submit(new CreateNamedNodeTask(name)).get();
    }

    private Number countStaff() {
        try (Result countResult = this.databaseRule.execute("MATCH (n:staff) return count(n.name) as count");){
            Number number = (Number)countResult.columnAs("count").next();
            return number;
        }
    }

    private class CreateNamedNodeTask
    implements Runnable {
        private final String name;

        CreateNamedNodeTask(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            try (Transaction transaction = IndexFreshDataReadIT.this.databaseRule.beginTx();){
                IndexFreshDataReadIT.this.databaseRule.execute("CREATE (n:staff {name:{name}})", MapUtil.map((Object[])new Object[]{"name", this.name}));
                transaction.success();
            }
        }
    }
}

