/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;

@RunWith(value=Parameterized.class)
public class IndexTxStateLookupTest {
    private static final String TRIGGER_LAZY = "this is supposed to be a really long property to trigger lazy loading";
    private static final Random random = new Random();
    @ClassRule
    public static final DatabaseRule db = new ImpermanentDatabaseRule();
    private final Object store;
    private final Object lookup;

    @Parameterized.Parameters(name="store=<{0}> lookup=<{1}>")
    public static Iterable<Object[]> parameters() {
        Class[] numberTypes;
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.addAll(Arrays.asList({new String("name"), new String("name")}, {7, 7L}, {9L, 9}, {2, 2.0}, {3L, 3.0}, {4, Float.valueOf(4.0f)}, {5L, Float.valueOf(5.0f)}, {12.0, 12}, {13.0, 13L}, {Float.valueOf(14.0f), 14}, {Float.valueOf(15.0f), 15L}, {Float.valueOf(2.5f), 2.5}, {16.25, Float.valueOf(16.25f)}, {IndexTxStateLookupTest.stringArray("a", "b", "c"), IndexTxStateLookupTest.charArray('a', 'b', 'c')}, {IndexTxStateLookupTest.charArray('d', 'e', 'f'), IndexTxStateLookupTest.stringArray("d", "e", "f")}, {IndexTxStateLookupTest.splitStrings(TRIGGER_LAZY), IndexTxStateLookupTest.splitChars(TRIGGER_LAZY)}, {IndexTxStateLookupTest.splitChars(TRIGGER_LAZY), IndexTxStateLookupTest.splitStrings(TRIGGER_LAZY)}, {IndexTxStateLookupTest.stringArray("foo", "bar"), IndexTxStateLookupTest.stringArray("foo", "bar")}));
        for (Class lhs : numberTypes = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
            for (Class rhs : numberTypes) {
                parameters.add(IndexTxStateLookupTest.randomNumbers(3, lhs, rhs));
                parameters.add(IndexTxStateLookupTest.randomNumbers(200, lhs, rhs));
            }
        }
        return parameters;
    }

    private static NamedObject stringArray(String ... items) {
        return new NamedObject(items, IndexTxStateLookupTest.arrayToString(items));
    }

    private static NamedObject charArray(char ... items) {
        return new NamedObject(items, IndexTxStateLookupTest.arrayToString(items));
    }

    private static Object[] randomNumbers(int length, Class<?> lhsType, Class<?> rhsType) {
        Object lhs = Array.newInstance(lhsType, length);
        Object rhs = Array.newInstance(rhsType, length);
        for (int i = 0; i < length; ++i) {
            int value = random.nextInt(128);
            Array.set(lhs, i, IndexTxStateLookupTest.convert(value, lhsType));
            Array.set(rhs, i, IndexTxStateLookupTest.convert(value, rhsType));
        }
        return new Object[]{new NamedObject(lhs, IndexTxStateLookupTest.arrayToString(lhs)), new NamedObject(rhs, IndexTxStateLookupTest.arrayToString(rhs))};
    }

    private static String arrayToString(Object arrayObject) {
        int length = Array.getLength(arrayObject);
        String type = arrayObject.getClass().getComponentType().getSimpleName();
        StringBuilder builder = new StringBuilder("(" + type + ") {");
        for (int i = 0; i < length; ++i) {
            builder.append(i > 0 ? "," : "").append(Array.get(arrayObject, i));
        }
        return builder.append("}").toString();
    }

    private static Object convert(int value, Class<?> type) {
        switch (type.getName()) {
            case "byte": {
                return (byte)value;
            }
            case "short": {
                return (short)value;
            }
            case "int": {
                return value;
            }
            case "long": {
                return (long)value;
            }
            case "float": {
                return Float.valueOf(value);
            }
            case "double": {
                return (double)value;
            }
        }
        return value;
    }

    private static NamedObject splitStrings(String string) {
        char[] chars = IndexTxStateLookupTest.internalSplitChars(string);
        String[] result = new String[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = Character.toString(chars[i]);
        }
        return IndexTxStateLookupTest.stringArray(result);
    }

    private static char[] internalSplitChars(String string) {
        char[] result = new char[string.length()];
        string.getChars(0, result.length, result, 0);
        return result;
    }

    private static NamedObject splitChars(String string) {
        char[] result = IndexTxStateLookupTest.internalSplitChars(string);
        return IndexTxStateLookupTest.charArray(result);
    }

    public IndexTxStateLookupTest(Object store, Object lookup) {
        this.store = this.realValue(store);
        this.lookup = this.realValue(lookup);
    }

    private Object realValue(Object object) {
        return object instanceof NamedObject ? ((NamedObject)object).object : object;
    }

    @BeforeClass
    public static void given() {
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(Label.label((String)"Node")).on("prop").create();
            tx.success();
        }
        tx = db.beginTx();
        var1_1 = null;
        try {
            db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var1_1 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var1_1 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var1_1.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void lookupWithinTransaction() {
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{Label.label((String)"Node")}).setProperty("prop", this.store);
            Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)db.findNodes(Label.label((String)"Node"), "prop", this.lookup)));
        }
    }

    @Test
    public void lookupWithinTransactionWithCacheEviction() {
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{Label.label((String)"Node")}).setProperty("prop", this.store);
            Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)db.findNodes(Label.label((String)"Node"), "prop", this.lookup)));
        }
    }

    @Test
    public void lookupWithoutTransaction() {
        Node node;
        try (Transaction tx = db.beginTx();){
            node = db.createNode(new Label[]{Label.label((String)"Node")});
            node.setProperty("prop", this.store);
            tx.success();
        }
        tx = db.beginTx();
        var3_2 = null;
        try {
            Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)db.findNodes(Label.label((String)"Node"), "prop", this.lookup)));
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.deleteNode(node);
    }

    private void deleteNode(Node node) {
        try (Transaction tx = db.beginTx();){
            node.delete();
            tx.success();
        }
    }

    @Test
    public void lookupWithoutTransactionWithCacheEviction() {
        Node node;
        try (Transaction tx = db.beginTx();){
            node = db.createNode(new Label[]{Label.label((String)"Node")});
            node.setProperty("prop", this.store);
            tx.success();
        }
        tx = db.beginTx();
        var3_2 = null;
        try {
            Assert.assertEquals((long)1L, (long)Iterators.count((Iterator)db.findNodes(Label.label((String)"Node"), "prop", this.lookup)));
            tx.success();
        }
        catch (Throwable throwable) {
            var3_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.deleteNode(node);
    }

    private static class NamedObject {
        private final Object object;
        private final String name;

        NamedObject(Object object, String name) {
            this.object = object;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

