/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexProvider;
import org.neo4j.test.rule.DatabaseRule;

public class SabotageNativeIndex
implements DatabaseRule.RestartAction {
    private final Random random;

    SabotageNativeIndex(Random random) {
        this.random = random;
    }

    public void run(FileSystemAbstraction fs, DatabaseLayout databaseLayout) throws IOException {
        int files = this.scrambleIndexFiles(fs, SabotageNativeIndex.nativeIndexDirectoryStructure(databaseLayout).rootDirectory());
        MatcherAssert.assertThat((String)"there is no index to sabotage", (Object)files, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    private int scrambleIndexFiles(FileSystemAbstraction fs, File fileOrDir) throws IOException {
        if (fs.isDirectory(fileOrDir)) {
            int count = 0;
            File[] children = fs.listFiles(fileOrDir);
            if (children != null) {
                for (File child : children) {
                    count += this.scrambleIndexFiles(fs, child);
                }
            }
            return count;
        }
        try (StoreChannel channel = fs.open(fileOrDir, OpenMode.READ_WRITE);){
            if (channel.size() > ByteUnit.mebiBytes((long)10L)) {
                throw new IllegalArgumentException("Was expecting small files here");
            }
            byte[] bytes = new byte[(int)channel.size()];
            this.random.nextBytes(bytes);
            channel.writeAll(ByteBuffer.wrap(bytes));
        }
        return 1;
    }

    static IndexDirectoryStructure nativeIndexDirectoryStructure(DatabaseLayout databaseLayout) {
        return IndexDirectoryStructure.directoriesByProvider((File)databaseLayout.databaseDirectory()).forProvider(GenericNativeIndexProvider.DESCRIPTOR);
    }
}

