/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.index.impl.lucene.explicit.Contains;
import org.neo4j.index.impl.lucene.explicit.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.explicit.WorkThread;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestIndexDeletion {
    private static final String INDEX_NAME = "index";
    private static GraphDatabaseService graphDb;
    private Index<Node> index;
    private Transaction tx;
    private String key;
    private Node node;
    private String value;
    private List<WorkThread> workers;

    @BeforeClass
    public static void setUpStuff() {
        graphDb = new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @AfterClass
    public static void tearDownStuff() {
        graphDb.shutdown();
    }

    @After
    public void commitTx() throws Exception {
        this.finishTx(true);
        for (WorkThread worker : this.workers) {
            worker.rollback();
            worker.die();
            worker.close();
        }
    }

    public void rollbackTx() {
        this.finishTx(false);
    }

    public void finishTx(boolean success) {
        if (this.tx != null) {
            if (success) {
                this.tx.success();
            }
            this.tx.close();
            this.tx = null;
        }
    }

    @Before
    public void createInitialData() {
        this.beginTx();
        this.index = graphDb.index().forNodes(INDEX_NAME);
        this.index.delete();
        this.restartTx();
        this.index = graphDb.index().forNodes(INDEX_NAME);
        this.key = "key";
        this.value = "my own value";
        this.node = graphDb.createNode();
        this.index.add((PropertyContainer)this.node, this.key, (Object)this.value);
        this.workers = new ArrayList<WorkThread>();
    }

    public void beginTx() {
        if (this.tx == null) {
            this.tx = graphDb.beginTx();
        }
    }

    void restartTx() {
        this.finishTx(true);
        this.beginTx();
    }

    @Test
    public void shouldBeAbleToDeleteAndRecreateIndex() {
        this.restartTx();
        Neo4jTestCase.assertContains(this.index.query(this.key, (Object)"own"), new Node[0]);
        this.index.delete();
        this.restartTx();
        Index recreatedIndex = graphDb.index().forNodes(INDEX_NAME, LuceneIndexImplementation.FULLTEXT_CONFIG);
        Assert.assertNull((Object)recreatedIndex.get(this.key, (Object)this.value).getSingle());
        recreatedIndex.add((PropertyContainer)this.node, this.key, (Object)this.value);
        this.restartTx();
        Neo4jTestCase.assertContains(recreatedIndex.query(this.key, (Object)"own"), new Node[]{this.node});
        recreatedIndex.delete();
    }

    @Test
    public void shouldNotBeDeletedWhenDeletionRolledBack() {
        this.restartTx();
        this.index.delete();
        this.rollbackTx();
        this.beginTx();
        IndexHits indexHits = this.index.get(this.key, (Object)this.value);
        Throwable throwable = null;
        if (indexHits != null) {
            if (throwable != null) {
                try {
                    indexHits.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                indexHits.close();
            }
        }
    }

    @Test
    public void shouldThrowIllegalStateForActionsAfterDeletedOnIndex() {
        this.restartTx();
        this.index.delete();
        this.restartTx();
        try {
            this.index.query(this.key, (Object)"own");
            Assert.fail((String)"Should fail");
        }
        catch (NotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"doesn't exist"));
        }
    }

    @Test
    public void shouldThrowIllegalStateForActionsAfterDeletedOnIndex2() {
        this.restartTx();
        this.index.delete();
        this.restartTx();
        try {
            this.index.add((PropertyContainer)this.node, this.key, (Object)this.value);
            Assert.fail();
        }
        catch (NotFoundException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"doesn't exist"));
        }
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateForActionsAfterDeletedOnIndex3() {
        this.restartTx();
        this.index.delete();
        this.index.query(this.key, (Object)"own");
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateForActionsAfterDeletedOnIndex4() {
        this.restartTx();
        this.index.delete();
        Index newIndex = graphDb.index().forNodes(INDEX_NAME);
        newIndex.query(this.key, (Object)"own");
    }

    @Test
    public void deleteInOneTxShouldNotAffectTheOther() throws Exception {
        this.index.delete();
        WorkThread firstTx = this.createWorker("Single");
        firstTx.beginTransaction();
        firstTx.createNodeAndIndexBy(this.key, "another value");
        firstTx.commit();
    }

    @Test
    public void deleteAndCommitShouldBePublishedToOtherTransaction2() throws Exception {
        WorkThread firstTx = this.createWorker("First");
        WorkThread secondTx = this.createWorker("Second");
        firstTx.beginTransaction();
        secondTx.beginTransaction();
        firstTx.createNodeAndIndexBy(this.key, "some value");
        secondTx.createNodeAndIndexBy(this.key, "some other value");
        firstTx.deleteIndex();
        firstTx.commit();
        try {
            secondTx.queryIndex(this.key, "some other value");
            Assert.fail((String)"Should throw exception");
        }
        catch (ExecutionException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)IsInstanceOf.instanceOf(NotFoundException.class));
            Assert.assertThat((Object)e.getCause().getMessage().toLowerCase(), (Matcher)Matchers.containsString((String)"index 'index' doesn't exist"));
        }
        secondTx.rollback();
        this.rollbackTx();
    }

    @Test
    public void indexDeletesShouldNotByVisibleUntilCommit() throws Exception {
        this.commitTx();
        WorkThread firstTx = this.createWorker("First");
        firstTx.beginTransaction();
        firstTx.removeFromIndex(this.key, this.value);
        try (Transaction transaction = graphDb.beginTx();){
            IndexHits indexHits = this.index.get(this.key, (Object)this.value);
            Assert.assertThat((Object)indexHits, Contains.contains(this.node));
        }
        firstTx.rollback();
    }

    @Test
    public void canDeleteIndexEvenIfEntitiesAreFoundToBeAbandonedInTheSameTx() {
        Index nodeIndex = graphDb.index().forNodes(INDEX_NAME);
        Node node = graphDb.createNode();
        nodeIndex.add((PropertyContainer)node, "key", (Object)"value");
        this.restartTx();
        node.delete();
        this.restartTx();
        for (Node node2 : nodeIndex.get("key", (Object)"value")) {
        }
        nodeIndex.delete();
        this.restartTx();
    }

    private WorkThread createWorker(String name) {
        WorkThread workThread = new WorkThread(name, this.index, graphDb, this.node);
        this.workers.add(workThread);
        return workThread;
    }
}

