/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProviderFactory;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.test.Race;
import org.neo4j.test.rule.RepeatRule;

public class ConcurrentLuceneFulltextUpdaterTest
extends LuceneFulltextTestSupport {
    private final int aliceThreads = 1;
    private final int bobThreads = 1;
    private final int nodesCreatedPerThread = 500;
    private Race race;
    private CountDownLatch aliceLatch = new CountDownLatch(2);
    private CountDownLatch bobLatch = new CountDownLatch(2);

    @Override
    protected RepeatRule createRepeatRule() {
        return new RepeatRule(false, 1);
    }

    @Before
    public void createRace() {
        this.race = new Race();
    }

    private SchemaDescriptor getNewDescriptor(String[] entityTokens) {
        return this.fulltextAdapter.schemaFor(EntityType.NODE, entityTokens, this.settings, new String[]{"otherProp"});
    }

    private SchemaDescriptor getExistingDescriptor(String[] entityTokens) {
        return this.fulltextAdapter.schemaFor(EntityType.NODE, entityTokens, this.settings, new String[]{"prop"});
    }

    private IndexReference createInitialIndex(SchemaDescriptor descriptor) throws Exception {
        IndexReference index;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            SchemaWrite schemaWrite = transaction.schemaWrite();
            index = schemaWrite.indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of("nodes"));
            transaction.success();
        }
        this.await(index);
        return index;
    }

    private void raceContestantsAndVerifyResults(SchemaDescriptor newDescriptor, Runnable aliceWork, Runnable changeConfig, Runnable bobWork) throws Throwable {
        this.race.addContestants(1, aliceWork);
        this.race.addContestant(changeConfig);
        this.race.addContestants(1, bobWork);
        this.race.go();
        this.await((IndexReference)IndexDescriptorFactory.forSchema((SchemaDescriptor)newDescriptor, Optional.of("nodes"), (IndexProviderDescriptor)FulltextIndexProviderFactory.DESCRIPTOR));
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = ConcurrentLuceneFulltextUpdaterTest.kernelTransaction(tx);
            ScoreEntityIterator bob = this.fulltextAdapter.query(ktx, "nodes", "bob");
            List list = bob.stream().collect(Collectors.toList());
            try {
                Assert.assertEquals((long)500L, (long)list.size());
            }
            catch (Throwable e) {
                StringBuilder sb = new StringBuilder(e.getMessage()).append(System.lineSeparator()).append("Nodes found in query for bob:");
                for (ScoreEntityIterator.ScoreEntry entry : list) {
                    sb.append(System.lineSeparator()).append("\t").append(this.db.getNodeById(entry.entityId()));
                }
                throw e;
            }
            ScoreEntityIterator alice = this.fulltextAdapter.query(ktx, "nodes", "alice");
            Assert.assertEquals((long)0L, (long)alice.stream().count());
        }
    }

    private Runnable work(int iterations, ThrowingAction<Exception> work) {
        return () -> {
            try {
                for (int i = 0; i < iterations; ++i) {
                    Thread.yield();
                    try (Transaction tx = this.db.beginTx();){
                        Thread.yield();
                        work.apply();
                        Thread.yield();
                        tx.success();
                        continue;
                    }
                }
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        };
    }

    private ThrowingAction<Exception> dropAndReCreateIndex(IndexReference descriptor, SchemaDescriptor newDescriptor) {
        return () -> {
            this.aliceLatch.await();
            this.bobLatch.await();
            try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
                SchemaWrite schemaWrite = transaction.schemaWrite();
                schemaWrite.indexDrop(descriptor);
                schemaWrite.indexCreate(newDescriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of("nodes"));
                transaction.success();
            }
        };
    }

    @Test
    public void labelledNodesCoreAPI() throws Throwable {
        String[] entityTokens = new String[]{LABEL.name()};
        SchemaDescriptor descriptor = this.getExistingDescriptor(entityTokens);
        SchemaDescriptor newDescriptor = this.getNewDescriptor(entityTokens);
        IndexReference initialIndex = this.createInitialIndex(descriptor);
        Runnable aliceWork = this.work(500, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.db.getNodeById(this.createNodeIndexableByPropertyValue(LABEL, "alice"));
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.db.getNodeById(this.createNodeWithProperty(LABEL, "otherProp", "bob"));
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, this.dropAndReCreateIndex(initialIndex, newDescriptor));
        this.raceContestantsAndVerifyResults(newDescriptor, aliceWork, changeConfig, bobWork);
    }

    @Test
    public void labelledNodesCypherCurrent() throws Throwable {
        String[] entityTokens = new String[]{LABEL.name()};
        SchemaDescriptor descriptor = this.getExistingDescriptor(entityTokens);
        SchemaDescriptor newDescriptor = this.getNewDescriptor(entityTokens);
        IndexReference initialIndex = this.createInitialIndex(descriptor);
        Runnable aliceWork = this.work(500, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.db.execute("create (:LABEL {prop: \"alice\"})").close();
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.db.execute("create (:LABEL {otherProp: \"bob\"})").close();
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, this.dropAndReCreateIndex(initialIndex, newDescriptor));
        this.raceContestantsAndVerifyResults(newDescriptor, aliceWork, changeConfig, bobWork);
    }

    @Test
    public void labelledNodesCypher31() throws Throwable {
        String[] entityTokens = new String[]{LABEL.name()};
        SchemaDescriptor descriptor = this.getExistingDescriptor(entityTokens);
        SchemaDescriptor newDescriptor = this.getNewDescriptor(entityTokens);
        IndexReference initialIndex = this.createInitialIndex(descriptor);
        Runnable aliceWork = this.work(500, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.db.execute("CYPHER 3.1 create (:LABEL {prop: \"alice\"})").close();
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.db.execute("CYPHER 3.1 create (:LABEL {otherProp: \"bob\"})").close();
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, this.dropAndReCreateIndex(initialIndex, newDescriptor));
        this.raceContestantsAndVerifyResults(newDescriptor, aliceWork, changeConfig, bobWork);
    }

    @Test
    public void labelledNodesCypher23() throws Throwable {
        String[] entityTokens = new String[]{LABEL.name()};
        SchemaDescriptor descriptor = this.getExistingDescriptor(entityTokens);
        SchemaDescriptor newDescriptor = this.getNewDescriptor(entityTokens);
        IndexReference initialIndex = this.createInitialIndex(descriptor);
        Runnable aliceWork = this.work(500, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.db.execute("CYPHER 2.3 create (:LABEL {prop: \"alice\"})").close();
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.db.execute("CYPHER 2.3 create (:LABEL {otherProp: \"bob\"})").close();
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, this.dropAndReCreateIndex(initialIndex, newDescriptor));
        this.raceContestantsAndVerifyResults(newDescriptor, aliceWork, changeConfig, bobWork);
    }

    @Test
    public void labelledNodesCypherRule() throws Throwable {
        String[] entityTokens = new String[]{LABEL.name()};
        SchemaDescriptor descriptor = this.getExistingDescriptor(entityTokens);
        SchemaDescriptor newDescriptor = this.getNewDescriptor(entityTokens);
        IndexReference initialIndex = this.createInitialIndex(descriptor);
        Runnable aliceWork = this.work(500, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.db.execute("CYPHER planner=rule create (:LABEL {prop: \"alice\"})").close();
            this.aliceLatch.countDown();
        }));
        Runnable bobWork = this.work(500, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.db.execute("CYPHER planner=rule create (:LABEL {otherProp: \"bob\"})").close();
            this.bobLatch.countDown();
        }));
        Runnable changeConfig = this.work(1, this.dropAndReCreateIndex(initialIndex, newDescriptor));
        this.raceContestantsAndVerifyResults(newDescriptor, aliceWork, changeConfig, bobWork);
    }
}

