/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProvider;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProviderFactory;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTest;
import org.neo4j.kernel.api.impl.fulltext.FulltextSchemaDescriptor;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.kernel.api.schema.MultiTokenSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.VerboseTimeout;

public class FulltextIndexProviderTest {
    private static final String NAME = "fulltext";
    @Rule
    public Timeout timeout = VerboseTimeout.builder().withTimeout(1L, TimeUnit.MINUTES).build();
    @Rule
    public DatabaseRule db = new EmbeddedDatabaseRule();
    private Node node1;
    private Node node2;

    @Before
    public void prepDB() {
        try (Transaction transaction = this.db.beginTx();){
            this.node1 = this.db.createNode(new Label[]{Label.label((String)"hej"), Label.label((String)"ha"), Label.label((String)"he")});
            this.node1.setProperty("hej", (Object)"value");
            this.node1.setProperty("ha", (Object)"value1");
            this.node1.setProperty("he", (Object)"value2");
            this.node1.setProperty("ho", (Object)"value3");
            this.node1.setProperty("hi", (Object)"value4");
            this.node2 = this.db.createNode();
            Relationship rel = this.node1.createRelationshipTo(this.node2, RelationshipType.withName((String)"hej"));
            rel.setProperty("hej", (Object)"valuuu");
            rel.setProperty("ha", (Object)"value1");
            rel.setProperty("he", (Object)"value2");
            rel.setProperty("ho", (Object)"value3");
            rel.setProperty("hi", (Object)"value4");
            transaction.success();
        }
    }

    @Test
    public void createFulltextIndex() throws Exception {
        IndexReference fulltextIndex = this.createIndex(new int[]{7, 8, 9}, new int[]{2, 3, 4});
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexReference descriptor = transaction.schemaRead().indexGetForName(NAME);
            Assert.assertEquals((Object)descriptor.schema(), (Object)fulltextIndex.schema());
            transaction.success();
        }
    }

    @Test
    public void createAndRetainFulltextIndex() throws Exception {
        IndexReference fulltextIndex = this.createIndex(new int[]{7, 8, 9}, new int[]{2, 3, 4});
        this.db.restartDatabase(DatabaseRule.RestartAction.EMPTY, new String[0]);
        this.verifyThatFulltextIndexIsPresent(fulltextIndex);
    }

    @Test
    public void createAndRetainRelationshipFulltextIndex() throws Exception {
        IndexReference indexReference;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            MultiTokenSchemaDescriptor multiTokenSchemaDescriptor = SchemaDescriptorFactory.multiToken((int[])new int[]{0, 1, 2}, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{0, 1, 2, 3});
            FulltextSchemaDescriptor schema = new FulltextSchemaDescriptor((SchemaDescriptor)multiTokenSchemaDescriptor, new Properties());
            indexReference = transaction.schemaWrite().indexCreate((SchemaDescriptor)schema, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NAME));
            transaction.success();
        }
        this.await(indexReference);
        this.db.restartDatabase(DatabaseRule.RestartAction.EMPTY, new String[0]);
        this.verifyThatFulltextIndexIsPresent(indexReference);
    }

    @Test
    public void createAndQueryFulltextIndex() throws Exception {
        FulltextIndexProvider provider = (FulltextIndexProvider)((IndexProviderMap)this.db.resolveDependency(IndexProviderMap.class)).lookup(FulltextIndexProviderFactory.DESCRIPTOR);
        IndexReference indexReference = this.createIndex(new int[]{0, 1, 2}, new int[]{0, 1, 2, 3});
        this.await(indexReference);
        long thirdNodeid = this.createTheThirdNode();
        this.verifyNodeData(provider, thirdNodeid);
        this.db.restartDatabase(DatabaseRule.RestartAction.EMPTY, new String[0]);
        provider = (FulltextIndexProvider)((IndexProviderMap)this.db.resolveDependency(IndexProviderMap.class)).lookup(FulltextIndexProviderFactory.DESCRIPTOR);
        this.verifyNodeData(provider, thirdNodeid);
    }

    @Test
    public void createAndQueryFulltextRelationshipIndex() throws Exception {
        long secondRelId;
        IndexReference indexReference;
        FulltextIndexProvider provider = (FulltextIndexProvider)((IndexProviderMap)this.db.resolveDependency(IndexProviderMap.class)).lookup(FulltextIndexProviderFactory.DESCRIPTOR);
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            MultiTokenSchemaDescriptor multiTokenSchemaDescriptor = SchemaDescriptorFactory.multiToken((int[])new int[]{0, 1, 2}, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{0, 1, 2, 3});
            FulltextSchemaDescriptor schema = new FulltextSchemaDescriptor((SchemaDescriptor)multiTokenSchemaDescriptor, new Properties());
            indexReference = transaction.schemaWrite().indexCreate((SchemaDescriptor)schema, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NAME));
            transaction.success();
        }
        this.await(indexReference);
        try (Transaction transaction = this.db.beginTx();){
            Relationship ho = this.node1.createRelationshipTo(this.node2, RelationshipType.withName((String)"ho"));
            secondRelId = ho.getId();
            ho.setProperty("hej", (Object)"villa");
            ho.setProperty("ho", (Object)"value3");
            transaction.success();
        }
        this.verifyRelationshipData(provider, secondRelId);
        this.db.restartDatabase(DatabaseRule.RestartAction.EMPTY, new String[0]);
        provider = (FulltextIndexProvider)((IndexProviderMap)this.db.resolveDependency(IndexProviderMap.class)).lookup(FulltextIndexProviderFactory.DESCRIPTOR);
        this.verifyRelationshipData(provider, secondRelId);
    }

    @Test
    public void multiTokenFulltextIndexesMustShowUpInSchemaGetIndexes() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodeIndex", FulltextProceduresTest.array("Label1", "Label2"), FulltextProceduresTest.array("prop1", "prop2"))).close();
            this.db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relIndex", FulltextProceduresTest.array("RelType1", "RelType2"), FulltextProceduresTest.array("prop1", "prop2"))).close();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            for (IndexDefinition index : this.db.schema().getIndexes()) {
                Assert.assertFalse((boolean)index.isConstraintIndex());
                Assert.assertTrue((boolean)index.isMultiTokenIndex());
                Assert.assertTrue((boolean)index.isCompositeIndex());
                if (index.isNodeIndex()) {
                    Assert.assertFalse((boolean)index.isRelationshipIndex());
                    Assert.assertThat((Object)index.getLabels(), (Matcher)Matchers.containsInAnyOrder((Object[])new Label[]{Label.label((String)"Label1"), Label.label((String)"Label2")}));
                    try {
                        index.getLabel();
                        Assert.fail((String)"index.getLabel() on multi-token IndexDefinition should have thrown.");
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    try {
                        index.getRelationshipTypes();
                        Assert.fail((String)"index.getRelationshipTypes() on node IndexDefinition should have thrown.");
                    }
                    catch (IllegalStateException illegalStateException) {}
                    continue;
                }
                Assert.assertTrue((boolean)index.isRelationshipIndex());
                Assert.assertThat((Object)index.getRelationshipTypes(), (Matcher)Matchers.containsInAnyOrder((Object[])new RelationshipType[]{RelationshipType.withName((String)"RelType1"), RelationshipType.withName((String)"RelType2")}));
                try {
                    index.getRelationshipType();
                    Assert.fail((String)"index.getRelationshipType() on multi-token IndexDefinition should have thrown.");
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    index.getLabels();
                    Assert.fail((String)"index.getLabels() on node IndexDefinition should have thrown.");
                }
                catch (IllegalStateException illegalStateException) {}
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void awaitIndexesOnlineMustWorkOnFulltextIndexes() {
        String prop1 = "prop1";
        String prop2 = "prop2";
        String prop3 = "prop3";
        String val1 = "foo foo";
        String val2 = "bar bar";
        String val3 = "baz baz";
        Label label1 = Label.label((String)"FirstLabel");
        Label label2 = Label.label((String)"SecondLabel");
        Label label3 = Label.label((String)"ThirdLabel");
        RelationshipType relType1 = RelationshipType.withName((String)"FirstRelType");
        RelationshipType relType2 = RelationshipType.withName((String)"SecondRelType");
        RelationshipType relType3 = RelationshipType.withName((String)"ThirdRelType");
        LongHashSet nodes1 = new LongHashSet();
        LongHashSet nodes2 = new LongHashSet();
        LongHashSet nodes3 = new LongHashSet();
        LongHashSet rels1 = new LongHashSet();
        LongHashSet rels2 = new LongHashSet();
        LongHashSet rels3 = new LongHashSet();
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 100; ++i) {
                Node node1 = this.db.createNode(new Label[]{label1});
                node1.setProperty(prop1, (Object)val1);
                nodes1.add(node1.getId());
                Relationship rel1 = node1.createRelationshipTo(node1, relType1);
                rel1.setProperty(prop1, (Object)val1);
                rels1.add(rel1.getId());
                Node node2 = this.db.createNode(new Label[]{label2});
                node2.setProperty(prop2, (Object)val2);
                nodes2.add(node2.getId());
                Relationship rel2 = node1.createRelationshipTo(node2, relType2);
                rel2.setProperty(prop2, (Object)val2);
                rels2.add(rel2.getId());
                Node node3 = this.db.createNode(new Label[]{label3});
                node3.setProperty(prop3, (Object)val3);
                nodes3.add(node3.getId());
                Relationship rel3 = node1.createRelationshipTo(node3, relType3);
                rel3.setProperty(prop3, (Object)val3);
                rels3.add(rel3.getId());
            }
            tx.success();
        }
        tx = this.db.beginTx();
        var20_20 = null;
        try {
            this.db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodeIndex", FulltextProceduresTest.array(label1.name(), label2.name(), label3.name()), FulltextProceduresTest.array(prop1, prop2, prop3))).close();
            tx.success();
        }
        catch (Throwable throwable) {
            var20_20 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var20_20 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var20_20.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var20_20 = null;
        try {
            this.db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var20_20 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var20_20 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var20_20.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var20_20 = null;
        try {
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "foo", nodes1);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "bar", nodes2);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, true, "nodeIndex", "baz", nodes3);
            tx.success();
        }
        catch (Throwable throwable) {
            var20_20 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var20_20 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var20_20.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var20_20 = null;
        try {
            this.db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "relIndex", FulltextProceduresTest.array(relType1.name(), relType2.name(), relType3.name()), FulltextProceduresTest.array(prop1, prop2, prop3))).close();
            tx.success();
        }
        catch (Throwable throwable) {
            var20_20 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var20_20 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var20_20.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var20_20 = null;
        try {
            this.db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var20_20 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var20_20 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var20_20.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var20_20 = null;
        try {
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "foo", rels1);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "bar", rels2);
            FulltextProceduresTest.assertQueryFindsIds((GraphDatabaseService)this.db, false, "relIndex", "baz", rels3);
            tx.success();
        }
        catch (Throwable throwable) {
            var20_20 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var20_20 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var20_20.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private KernelTransactionImplementation getKernelTransaction() {
        try {
            return (KernelTransactionImplementation)((KernelImpl)this.db.resolveDependency(KernelImpl.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException("oops");
        }
    }

    private IndexReference createIndex(int[] entityTokens, int[] propertyIds) throws TransactionFailureException, InvalidTransactionTypeKernelException, SchemaKernelException {
        IndexReference fulltext;
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            MultiTokenSchemaDescriptor multiTokenSchemaDescriptor = SchemaDescriptorFactory.multiToken((int[])entityTokens, (EntityType)EntityType.NODE, (int[])propertyIds);
            FulltextSchemaDescriptor schema = new FulltextSchemaDescriptor((SchemaDescriptor)multiTokenSchemaDescriptor, new Properties());
            fulltext = transaction.schemaWrite().indexCreate((SchemaDescriptor)schema, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NAME));
            transaction.success();
        }
        return fulltext;
    }

    private void verifyThatFulltextIndexIsPresent(IndexReference fulltextIndexDescriptor) throws TransactionFailureException {
        try (KernelTransactionImplementation transaction = this.getKernelTransaction();){
            IndexReference descriptor = transaction.schemaRead().indexGetForName(NAME);
            Assert.assertEquals((Object)fulltextIndexDescriptor.schema(), (Object)descriptor.schema());
            Assert.assertEquals((Object)((IndexDescriptor)fulltextIndexDescriptor).type(), (Object)((IndexDescriptor)descriptor).type());
            transaction.success();
        }
    }

    private long createTheThirdNode() {
        long secondNodeId;
        try (Transaction transaction = this.db.beginTx();){
            Node hej = this.db.createNode(new Label[]{Label.label((String)"hej")});
            secondNodeId = hej.getId();
            hej.setProperty("hej", (Object)"villa");
            hej.setProperty("ho", (Object)"value3");
            transaction.success();
        }
        return secondNodeId;
    }

    private void verifyNodeData(FulltextIndexProvider provider, long thirdNodeid) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            ScoreEntityIterator result = provider.query(ktx, NAME, "value");
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((long)0L, (long)result.next().entityId());
            Assert.assertFalse((boolean)result.hasNext());
            result = provider.query(ktx, NAME, "villa");
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((long)thirdNodeid, (long)result.next().entityId());
            Assert.assertFalse((boolean)result.hasNext());
            result = provider.query(ktx, NAME, "value3");
            PrimitiveLongSet ids = Primitive.longSet();
            ids.add(0L);
            ids.add(thirdNodeid);
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertTrue((boolean)ids.remove(result.next().entityId()));
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertTrue((boolean)ids.remove(result.next().entityId()));
            Assert.assertFalse((boolean)result.hasNext());
            tx.success();
        }
    }

    private void verifyRelationshipData(FulltextIndexProvider provider, long secondRelId) throws Exception {
        try (Transaction tx = this.db.beginTx();){
            KernelTransaction ktx = LuceneFulltextTestSupport.kernelTransaction(tx);
            ScoreEntityIterator result = provider.query(ktx, NAME, "valuuu");
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((long)0L, (long)result.next().entityId());
            Assert.assertFalse((boolean)result.hasNext());
            result = provider.query(ktx, NAME, "villa");
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((long)secondRelId, (long)result.next().entityId());
            Assert.assertFalse((boolean)result.hasNext());
            result = provider.query(ktx, NAME, "value3");
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((long)0L, (long)result.next().entityId());
            Assert.assertTrue((boolean)result.hasNext());
            Assert.assertEquals((long)secondRelId, (long)result.next().entityId());
            Assert.assertFalse((boolean)result.hasNext());
            tx.success();
        }
    }

    private void await(IndexReference descriptor) throws IndexNotFoundKernelException {
        try (Transaction ignore = this.db.beginTx();){
            while (this.getKernelTransaction().schemaRead().indexGetState(descriptor) != InternalIndexState.ONLINE) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

