/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Optional;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProviderFactory;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.storageengine.api.EntityType;

public class LuceneFulltextIndexTest
extends LuceneFulltextTestSupport {
    private static final String NODE_INDEX_NAME = "nodes";
    private static final String REL_INDEX_NAME = "rels";

    @Test
    public void shouldFindNodeWithString() throws Exception {
        long secondID;
        long firstID;
        IndexReference index;
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        this.await(index);
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(LABEL, "Hello. Hello again.");
            secondID = this.createNodeIndexableByPropertyValue(LABEL, "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            tx.success();
        }
        tx = this.db.beginTx();
        var7_12 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "hello", firstID);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "zebra", secondID);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "zedonk", secondID);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "cross", secondID);
        }
        catch (Throwable throwable) {
            var7_12 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_12.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldRepresentPropertyChanges() throws Exception {
        long secondID;
        long firstID;
        IndexReference index;
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        this.await(index);
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(LABEL, "Hello. Hello again.");
            secondID = this.createNodeIndexableByPropertyValue(LABEL, "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            tx.success();
        }
        tx = this.db.beginTx();
        var7_12 = null;
        try {
            this.setNodeProp(firstID, "Finally! Potato!");
            this.setNodeProp(secondID, "This one is a potato farmer.");
            tx.success();
        }
        catch (Throwable throwable) {
            var7_12 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_12.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var7_12 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "hello");
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "zebra");
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "zedonk");
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "cross");
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "finally", firstID);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "farmer", secondID);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "potato", firstID, secondID);
        }
        catch (Throwable throwable) {
            var7_12 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_12.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotFindRemovedNodes() throws Exception {
        long secondID;
        long firstID;
        IndexReference index;
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        this.await(index);
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(LABEL, "Hello. Hello again.");
            secondID = this.createNodeIndexableByPropertyValue(LABEL, "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            tx.success();
        }
        tx = this.db.beginTx();
        var7_12 = null;
        try {
            this.db.getNodeById(firstID).delete();
            this.db.getNodeById(secondID).delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var7_12 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_12.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var7_12 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "hello");
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "zebra");
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "zedonk");
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "cross");
        }
        catch (Throwable throwable) {
            var7_12 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_12.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotFindRemovedProperties() throws Exception {
        long thirdID;
        long secondID;
        long firstID;
        IndexReference index;
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop", "prop2"});
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        this.await(index);
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(LABEL, "Hello. Hello again.");
            secondID = this.createNodeIndexableByPropertyValue(LABEL, "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            thirdID = this.createNodeIndexableByPropertyValue(LABEL, "Hello. Hello again.");
            this.setNodeProp(firstID, "zebra");
            this.setNodeProp(secondID, "Hello. Hello again.");
            tx.success();
        }
        tx = this.db.beginTx();
        var9_13 = null;
        try {
            Node node = this.db.getNodeById(firstID);
            Node node2 = this.db.getNodeById(secondID);
            Node node3 = this.db.getNodeById(thirdID);
            node.setProperty("prop", (Object)"tomtar");
            node.setProperty("prop2", (Object)"tomtar");
            node2.setProperty("prop", (Object)"tomtar");
            node2.setProperty("prop2", (Object)"Hello");
            node3.removeProperty("prop");
            tx.success();
        }
        catch (Throwable node) {
            var9_13 = node;
            throw node;
        }
        finally {
            if (tx != null) {
                if (var9_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable node) {
                        var9_13.addSuppressed(node);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var9_13 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "hello", secondID);
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "zebra");
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "zedonk");
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "cross");
        }
        catch (Throwable throwable) {
            var9_13 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_13.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldOnlyIndexIndexedProperties() throws Exception {
        long firstID;
        IndexReference index;
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        this.await(index);
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(LABEL, "Hello. Hello again.");
            this.setNodeProp(firstID, "prop2", "zebra");
            Node node2 = this.db.createNode(new Label[]{LABEL});
            node2.setProperty("prop2", (Object)"zebra");
            node2.setProperty("prop3", (Object)"hello");
            tx.success();
        }
        tx = this.db.beginTx();
        var5_9 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "hello", firstID);
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "zebra");
        }
        catch (Throwable throwable) {
            var5_9 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_9 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_9.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldSearchAcrossMultipleProperties() throws Exception {
        long thirdID;
        long secondID;
        long firstID;
        IndexReference index;
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop", "prop2"});
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        this.await(index);
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(LABEL, "Tomtar tomtar oftsat i tomteutstyrsel.");
            secondID = this.createNodeIndexableByPropertyValue(LABEL, "Olof och Hans");
            this.setNodeProp(secondID, "prop2", "och karl");
            Node node3 = this.db.createNode(new Label[]{LABEL});
            thirdID = node3.getId();
            node3.setProperty("prop2", (Object)"Tomtar som inte tomtar ser upp till tomtar som tomtar.");
            tx.success();
        }
        tx = this.db.beginTx();
        var9_13 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "tomtar Karl", firstID, secondID, thirdID);
        }
        catch (Throwable throwable) {
            var9_13 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var9_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var9_13.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldOrderResultsBasedOnRelevance() throws Exception {
        long fourthID;
        long thirdID;
        long secondID;
        long firstID;
        IndexReference index;
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"first", "last"});
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        this.await(index);
        try (Transaction tx = this.db.beginTx();){
            firstID = this.db.createNode(new Label[]{LABEL}).getId();
            secondID = this.db.createNode(new Label[]{LABEL}).getId();
            thirdID = this.db.createNode(new Label[]{LABEL}).getId();
            fourthID = this.db.createNode(new Label[]{LABEL}).getId();
            this.setNodeProp(firstID, "first", "Full");
            this.setNodeProp(firstID, "last", "Hanks");
            this.setNodeProp(secondID, "first", "Tom");
            this.setNodeProp(secondID, "last", "Hunk");
            this.setNodeProp(thirdID, "first", "Tom");
            this.setNodeProp(thirdID, "last", "Hanks");
            this.setNodeProp(fourthID, "first", "Tom Hanks");
            this.setNodeProp(fourthID, "last", "Tom Hanks");
            tx.success();
        }
        tx = this.db.beginTx();
        var11_13 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIdsInOrder(ktx, NODE_INDEX_NAME, "Tom Hanks", fourthID, thirdID, firstID, secondID);
        }
        catch (Throwable throwable) {
            var11_13 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var11_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var11_13.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldDifferentiateNodesAndRelationships() throws Exception {
        long secondRelID;
        long firstRelID;
        long secondNodeID;
        long firstNodeID;
        IndexReference relsIndex;
        IndexReference nodesIndex;
        SchemaDescriptor nodes = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
        SchemaDescriptor rels = this.fulltextAdapter.schemaFor(EntityType.RELATIONSHIP, new String[]{RELTYPE.name()}, this.settings, new String[]{"prop"});
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            nodesIndex = tx.schemaWrite().indexCreate(nodes, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            relsIndex = tx.schemaWrite().indexCreate(rels, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(REL_INDEX_NAME));
            tx.success();
        }
        this.await(nodesIndex);
        this.await(relsIndex);
        try (Transaction tx = this.db.beginTx();){
            firstNodeID = this.createNodeIndexableByPropertyValue(LABEL, "Hello. Hello again.");
            secondNodeID = this.createNodeIndexableByPropertyValue(LABEL, "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            firstRelID = this.createRelationshipIndexableByPropertyValue(firstNodeID, secondNodeID, "Hello. Hello again.");
            secondRelID = this.createRelationshipIndexableByPropertyValue(secondNodeID, firstNodeID, "And now, something completely different");
            tx.success();
        }
        tx = this.db.beginTx();
        var14_15 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "hello", firstNodeID);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "zebra", secondNodeID);
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "different");
            this.assertQueryFindsIds(ktx, REL_INDEX_NAME, "hello", firstRelID);
            this.assertQueryFindsNothing(ktx, REL_INDEX_NAME, "zebra");
            this.assertQueryFindsIds(ktx, REL_INDEX_NAME, "different", secondRelID);
        }
        catch (Throwable throwable) {
            var14_15 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var14_15 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var14_15.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldNotReturnNonMatches() throws Exception {
        IndexReference relsIndex;
        IndexReference nodesIndex;
        SchemaDescriptor nodes = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
        SchemaDescriptor rels = this.fulltextAdapter.schemaFor(EntityType.RELATIONSHIP, new String[]{RELTYPE.name()}, this.settings, new String[]{"prop"});
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            nodesIndex = tx.schemaWrite().indexCreate(nodes, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            relsIndex = tx.schemaWrite().indexCreate(rels, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(REL_INDEX_NAME));
            tx.success();
        }
        this.await(nodesIndex);
        this.await(relsIndex);
        tx = this.db.beginTx();
        var6_4 = null;
        try {
            long firstNode = this.createNodeIndexableByPropertyValue(LABEL, "Hello. Hello again.");
            long secondNode = this.createNodeWithProperty(LABEL, "prop2", "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            this.createRelationshipIndexableByPropertyValue(firstNode, secondNode, "Hello. Hello again.");
            this.createRelationshipWithProperty(secondNode, firstNode, "prop2", "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
            tx.success();
        }
        catch (Throwable firstNode) {
            var6_4 = firstNode;
            throw firstNode;
        }
        finally {
            if (tx != null) {
                if (var6_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable firstNode) {
                        var6_4.addSuppressed(firstNode);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var6_4 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction((Transaction)tx);
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "zebra");
            this.assertQueryFindsNothing(ktx, REL_INDEX_NAME, "zebra");
        }
        catch (Throwable throwable) {
            var6_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var6_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var6_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldPopulateIndexWithExistingNodesAndRelationships() throws Exception {
        IndexReference relsIndex;
        IndexReference nodesIndex;
        long secondRelID;
        long firstRelID;
        long secondNodeID;
        long firstNodeID;
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.createRelationshipTo(node, RELTYPE);
            node.createRelationshipTo(node, RELTYPE);
            node.createRelationshipTo(node, RELTYPE);
            firstNodeID = this.createNodeIndexableByPropertyValue(LABEL, "Hello. Hello again.");
            secondNodeID = this.createNodeIndexableByPropertyValue(LABEL, "This string is slightly shorter than the zebra one");
            firstRelID = this.createRelationshipIndexableByPropertyValue(firstNodeID, secondNodeID, "Goodbye");
            secondRelID = this.createRelationshipIndexableByPropertyValue(secondNodeID, firstNodeID, "And now, something completely different");
            tx.success();
        }
        SchemaDescriptor nodes = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
        SchemaDescriptor rels = this.fulltextAdapter.schemaFor(EntityType.RELATIONSHIP, new String[]{RELTYPE.name()}, this.settings, new String[]{"prop"});
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            nodesIndex = tx.schemaWrite().indexCreate(nodes, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            relsIndex = tx.schemaWrite().indexCreate(rels, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(REL_INDEX_NAME));
            tx.success();
        }
        this.await(nodesIndex);
        this.await(relsIndex);
        tx = this.db.beginTx();
        var14_14 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction((Transaction)tx);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "hello", firstNodeID);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "string", secondNodeID);
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "goodbye");
            this.assertQueryFindsNothing(ktx, NODE_INDEX_NAME, "different");
            this.assertQueryFindsNothing(ktx, REL_INDEX_NAME, "hello");
            this.assertQueryFindsNothing(ktx, REL_INDEX_NAME, "string");
            this.assertQueryFindsIds(ktx, REL_INDEX_NAME, "goodbye", firstRelID);
            this.assertQueryFindsIds(ktx, REL_INDEX_NAME, "different", secondRelID);
        }
        catch (Throwable throwable) {
            var14_14 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var14_14 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var14_14.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToUpdateAndQueryAfterIndexChange() throws Exception {
        long fourthID;
        KernelTransaction ktx2;
        long thirdID;
        long secondID;
        long firstID;
        IndexReference index;
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        this.await(index);
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(LABEL, "thing");
            secondID = this.db.createNode(new Label[]{LABEL}).getId();
            this.setNodeProp(secondID, "prop2", "zebra");
            thirdID = this.createNodeIndexableByPropertyValue(LABEL, "zebra");
            tx.success();
        }
        tx = this.db.beginTx();
        var11_13 = null;
        try {
            ktx2 = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx2, NODE_INDEX_NAME, "thing zebra", firstID, thirdID);
        }
        catch (Throwable ktx2) {
            var11_13 = ktx2;
            throw ktx2;
        }
        finally {
            if (tx != null) {
                if (var11_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable ktx2) {
                        var11_13.addSuppressed(ktx2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.getKernelTransaction();
        var11_13 = null;
        try {
            SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop2"});
            tx.schemaWrite().indexDrop(index);
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        catch (Throwable descriptor) {
            var11_13 = descriptor;
            throw descriptor;
        }
        finally {
            if (tx != null) {
                if (var11_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable descriptor) {
                        var11_13.addSuppressed(descriptor);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.await(index);
        tx = this.db.beginTx();
        var11_13 = null;
        try {
            this.setNodeProp(firstID, "prop2", "thing");
            fourthID = this.db.createNode(new Label[]{LABEL}).getId();
            this.setNodeProp(fourthID, "prop2", "zebra");
            tx.success();
        }
        catch (Throwable descriptor) {
            var11_13 = descriptor;
            throw descriptor;
        }
        finally {
            if (tx != null) {
                if (var11_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable descriptor) {
                        var11_13.addSuppressed(descriptor);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var11_13 = null;
        try {
            ktx2 = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx2, NODE_INDEX_NAME, "thing zebra", firstID, secondID, fourthID);
        }
        catch (Throwable throwable) {
            var11_13 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var11_13 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var11_13.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToDropAndReadIndex() throws Exception {
        long secondID;
        long firstID;
        IndexReference index;
        SchemaDescriptor descriptor = this.fulltextAdapter.schemaFor(EntityType.NODE, new String[]{LABEL.name()}, this.settings, new String[]{"prop"});
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        this.await(index);
        try (Transaction tx = this.db.beginTx();){
            firstID = this.createNodeIndexableByPropertyValue(LABEL, "thing");
            secondID = this.createNodeIndexableByPropertyValue(LABEL, "zebra");
            tx.success();
        }
        tx = this.getKernelTransaction();
        var8_12 = null;
        try {
            tx.schemaWrite().indexDrop(index);
            tx.success();
        }
        catch (Throwable throwable) {
            var8_12 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_12.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.getKernelTransaction();
        var8_12 = null;
        try {
            index = tx.schemaWrite().indexCreate(descriptor, FulltextIndexProviderFactory.DESCRIPTOR.name(), Optional.of(NODE_INDEX_NAME));
            tx.success();
        }
        catch (Throwable throwable) {
            var8_12 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_12.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.await(index);
        tx = this.db.beginTx();
        var8_12 = null;
        try {
            KernelTransaction ktx = LuceneFulltextIndexTest.kernelTransaction(tx);
            this.assertQueryFindsIds(ktx, NODE_INDEX_NAME, "thing zebra", firstID, secondID);
        }
        catch (Throwable throwable) {
            var8_12 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_12 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var8_12.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

