/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.lucene.queryparser.classic.ParseException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextAdapter;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexProviderFactory;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.coreapi.TopLevelTransaction;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RepeatRule;

public class LuceneFulltextTestSupport {
    static final Label LABEL = Label.label((String)"LABEL");
    static final RelationshipType RELTYPE = RelationshipType.withName((String)"type");
    static final String PROP = "prop";
    DatabaseRule db = new EmbeddedDatabaseRule();
    private RepeatRule repeatRule = this.createRepeatRule();
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.repeatRule).around((TestRule)this.db);
    Properties settings;
    FulltextAdapter fulltextAdapter;

    protected RepeatRule createRepeatRule() {
        return new RepeatRule(false, 1);
    }

    @Before
    public void setUp() {
        this.settings = new Properties();
        this.fulltextAdapter = this.getAccessor();
    }

    void applySetting(Setting<String> setting, String value) throws IOException {
        this.db.restartDatabase(new String[]{setting.name(), value});
        this.db.ensureStarted();
        this.fulltextAdapter = this.getAccessor();
    }

    KernelTransactionImplementation getKernelTransaction() {
        try {
            return (KernelTransactionImplementation)((KernelImpl)this.db.resolveDependency(KernelImpl.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException("oops");
        }
    }

    private FulltextAdapter getAccessor() {
        return (FulltextAdapter)((IndexProviderMap)this.db.resolveDependency(IndexProviderMap.class)).lookup(FulltextIndexProviderFactory.DESCRIPTOR);
    }

    long createNodeIndexableByPropertyValue(Label label, Object propertyValue) {
        return this.createNodeWithProperty(label, PROP, propertyValue);
    }

    long createNodeWithProperty(Label label, String propertyKey, Object propertyValue) {
        Node node = this.db.createNode(new Label[]{label});
        node.setProperty(propertyKey, propertyValue);
        return node.getId();
    }

    long createRelationshipIndexableByPropertyValue(long firstNodeId, long secondNodeId, Object propertyValue) {
        return this.createRelationshipWithProperty(firstNodeId, secondNodeId, PROP, propertyValue);
    }

    long createRelationshipWithProperty(long firstNodeId, long secondNodeId, String propertyKey, Object propertyValue) {
        Node first = this.db.getNodeById(firstNodeId);
        Node second = this.db.getNodeById(secondNodeId);
        Relationship relationship = first.createRelationshipTo(second, RELTYPE);
        relationship.setProperty(propertyKey, propertyValue);
        return relationship.getId();
    }

    public static KernelTransaction kernelTransaction(Transaction tx) throws Exception {
        Assert.assertThat((Object)tx, (Matcher)Matchers.instanceOf(TopLevelTransaction.class));
        Field transactionField = TopLevelTransaction.class.getDeclaredField("transaction");
        transactionField.setAccessible(true);
        return (KernelTransaction)transactionField.get(tx);
    }

    void assertQueryFindsNothing(KernelTransaction ktx, String indexName, String query) throws Exception {
        this.assertQueryFindsIds(ktx, indexName, query, new long[0]);
    }

    void assertQueryFindsIds(KernelTransaction ktx, String indexName, String query, long ... ids) throws Exception {
        ScoreEntityIterator result = this.fulltextAdapter.query(ktx, indexName, query);
        LuceneFulltextTestSupport.assertQueryResultsMatch(result, ids);
    }

    void assertQueryFindsIdsInOrder(KernelTransaction ktx, String indexName, String query, long ... ids) throws IOException, IndexNotFoundKernelException, ParseException {
        ScoreEntityIterator result = this.fulltextAdapter.query(ktx, indexName, query);
        LuceneFulltextTestSupport.assertQueryResultsMatchInOrder(result, ids);
    }

    private static void assertQueryResultsMatch(ScoreEntityIterator result, long[] ids) {
        PrimitiveLongSet set = PrimitiveLongCollections.setOf((long[])ids);
        while (result.hasNext()) {
            long next = result.next().entityId();
            Assert.assertTrue((String)String.format("Result returned node id %d, expected one of %s", next, Arrays.toString(ids)), (boolean)set.remove(next));
        }
        if (!set.isEmpty()) {
            ArrayList list = new ArrayList();
            set.visitKeys(k -> !list.add(k));
            Assert.fail((String)("Number of results differ from expected. " + set.size() + " IDs were not found in the result: " + list));
        }
    }

    private static void assertQueryResultsMatchInOrder(ScoreEntityIterator result, long[] ids) {
        int num = 0;
        float score = Float.MAX_VALUE;
        while (result.hasNext()) {
            ScoreEntityIterator.ScoreEntry scoredResult = result.next();
            long nextId = scoredResult.entityId();
            float nextScore = scoredResult.score();
            Assert.assertThat((Object)Float.valueOf(nextScore), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Float.valueOf(score)));
            score = nextScore;
            Assert.assertEquals((String)String.format("Result returned node id %d, expected %d", nextId, ids[num]), (long)ids[num], (long)nextId);
            ++num;
        }
        Assert.assertEquals((String)"Number of results differ from expected", (long)ids.length, (long)num);
    }

    void setNodeProp(long nodeId, String value) {
        this.setNodeProp(nodeId, PROP, value);
    }

    void setNodeProp(long nodeId, String propertyKey, String value) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.getNodeById(nodeId);
            node.setProperty(propertyKey, (Object)value);
            tx.success();
        }
    }

    void await(IndexReference descriptor) throws Exception {
        try (KernelTransactionImplementation tx = this.getKernelTransaction();){
            while (tx.schemaRead().index(descriptor.schema()) == IndexReference.NO_INDEX) {
                Thread.sleep(100L);
            }
            while (tx.schemaRead().indexGetState(descriptor) != InternalIndexState.ONLINE) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

