/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.PointValue;

public class GenericIndexValidationIT {
    private static final String[] PROP_KEYS = new String[]{"prop0", "prop1", "prop2", "prop3", "prop4"};
    private static final int KEY_SIZE_LIMIT = TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)8192);
    private static final int ESTIMATED_OVERHEAD_PER_SLOT = 2;
    private static final int WIGGLE_ROOM = 50;
    @Rule
    public DatabaseRule db = new EmbeddedDatabaseRule().withSetting(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerName());
    @ClassRule
    public static RandomRule random = new RandomRule();

    @Test
    public void shouldEnforceSizeCapSingleValueSingleType() {
        NamedDynamicValueGenerator[] dynamicValueGenerators;
        for (NamedDynamicValueGenerator generator : dynamicValueGenerators = NamedDynamicValueGenerator.values()) {
            String propKey = PROP_KEYS[0] + generator.name();
            this.createIndex(propKey);
            BinarySearch binarySearch = new BinarySearch();
            while (!binarySearch.finished()) {
                Object propValue = generator.dynamicValue(binarySearch.arrayLength);
                long expectedNodeId = -1L;
                boolean wasAbleToWrite = true;
                try (Transaction tx = this.db.beginTx();){
                    Node node = this.db.createNode(new Label[]{TestLabels.LABEL_ONE});
                    node.setProperty(propKey, propValue);
                    expectedNodeId = node.getId();
                    tx.success();
                }
                catch (Exception e) {
                    wasAbleToWrite = false;
                }
                this.verifyReadExpected(propKey, propValue, expectedNodeId, wasAbleToWrite);
                binarySearch.progress(wasAbleToWrite);
            }
            Assert.assertEquals((String)String.format("expected longest successful array length for type %s, to be %d but was %d. This is a strong indication that documentation of max limit needs to be updated.", generator.name(), generator.expectedMax, binarySearch.longestSuccessful), (long)generator.expectedMax, (long)binarySearch.longestSuccessful);
        }
    }

    @Test
    public void shouldEnforceSizeCapMixedTypes() {
        for (int numberOfSlots = 1; numberOfSlots < 5; ++numberOfSlots) {
            String[] propKeys = this.generatePropertyKeys(numberOfSlots);
            this.createIndex(propKeys);
            int keySizeLimitPerSlot = KEY_SIZE_LIMIT / propKeys.length - 2;
            int wiggleRoomPerSlot = 50 / propKeys.length;
            SuccessAndFail successAndFail = new SuccessAndFail();
            for (int i = 0; i < 1000; ++i) {
                Object[] propValues = this.generatePropertyValues(propKeys, keySizeLimitPerSlot, wiggleRoomPerSlot);
                long expectedNodeId = -1L;
                boolean ableToWrite = true;
                try (Transaction tx = this.db.beginTx();){
                    Node node = this.db.createNode(new Label[]{TestLabels.LABEL_ONE});
                    this.setProperties(propKeys, propValues, node);
                    expectedNodeId = node.getId();
                    tx.success();
                }
                catch (Exception e) {
                    ableToWrite = false;
                }
                successAndFail.ableToWrite(ableToWrite);
                this.verifyReadExpected(propKeys, propValues, expectedNodeId, ableToWrite);
            }
            successAndFail.verifyBothSuccessAndFail();
        }
    }

    private void setProperties(String[] propKeys, Object[] propValues, Node node) {
        for (int propKey = 0; propKey < propKeys.length; ++propKey) {
            node.setProperty(propKeys[propKey], propValues[propKey]);
        }
    }

    private String[] generatePropertyKeys(int numberOfSlots) {
        String[] propKeys = new String[numberOfSlots];
        for (int i = 0; i < numberOfSlots; ++i) {
            propKeys[i] = PROP_KEYS[i] + "numberOfSlots" + numberOfSlots;
        }
        return propKeys;
    }

    private Object[] generatePropertyValues(String[] propKeys, int keySizeLimitPerSlot, int wiggleRoomPerSlot) {
        Object[] propValues = new Object[propKeys.length];
        for (int propKey = 0; propKey < propKeys.length; ++propKey) {
            NamedDynamicValueGenerator among = (NamedDynamicValueGenerator)((Object)random.among((Object[])NamedDynamicValueGenerator.values()));
            propValues[propKey] = among.dynamicValue(keySizeLimitPerSlot, wiggleRoomPerSlot);
        }
        return propValues;
    }

    private void verifyReadExpected(String propKey, Object propValue, long expectedNodeId, boolean ableToWrite) {
        this.verifyReadExpected(new String[]{propKey}, new Object[]{propValue}, expectedNodeId, ableToWrite);
    }

    private void verifyReadExpected(String[] propKeys, Object[] propValues, long expectedNodeId, boolean ableToWrite) {
        try (Transaction tx = this.db.beginTx();){
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (int propKey = 0; propKey < propKeys.length; ++propKey) {
                values.put(propKeys[propKey], propValues[propKey]);
            }
            ResourceIterator nodes = this.db.findNodes((Label)TestLabels.LABEL_ONE, values);
            if (ableToWrite) {
                Assert.assertTrue((boolean)nodes.hasNext());
                Node node = (Node)nodes.next();
                Assert.assertNotNull((Object)node);
                Assert.assertEquals((String)"node id", (long)expectedNodeId, (long)node.getId());
            } else {
                Assert.assertFalse((boolean)nodes.hasNext());
            }
            tx.success();
        }
    }

    private void createIndex(String ... propKeys) {
        try (Transaction tx = this.db.beginTx();){
            IndexCreator indexCreator = this.db.schema().indexFor((Label)TestLabels.LABEL_ONE);
            for (String propKey : propKeys) {
                indexCreator = indexCreator.on(propKey);
            }
            indexCreator.create();
            tx.success();
        }
        tx = this.db.beginTx();
        var3_3 = null;
        try {
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private static enum NamedDynamicValueGenerator {
        string(1, 4036, i -> random.randomValues().nextAlphaNumericTextValue(i, i).stringValue()),
        byteArray(1, 4035, i -> random.randomValues().nextByteArrayRaw(i, i)),
        shortArray(2, 2017, i -> random.randomValues().nextShortArrayRaw(i, i)),
        intArray(4, 1008, i -> random.randomValues().nextIntArrayRaw(i, i)),
        longArray(8, 504, i -> random.randomValues().nextLongArrayRaw(i, i)),
        floatArray(4, 1008, i -> random.randomValues().nextFloatArrayRaw(i, i)),
        doubleArray(8, 504, i -> random.randomValues().nextDoubleArrayRaw(i, i)),
        booleanArray(1, 4036, i -> random.randomValues().nextBooleanArrayRaw(i, i)),
        charArray(1, 1345, i -> random.randomValues().nextAlphaNumericTextValue(i, i).stringValue().toCharArray()),
        stringArray1(3, 1345, i -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 1, 1)),
        stringArray10(12, 336, i -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 10, 10)),
        stringArray100(102, 39, i -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 100, 100)),
        stringArray1000(1002, 4, i -> random.randomValues().nextAlphaNumericStringArrayRaw(i, i, 1000, 1000)),
        dateArray(8, 504, i -> random.randomValues().nextDateArrayRaw(i, i)),
        timeArray(12, 336, i -> random.randomValues().nextTimeArrayRaw(i, i)),
        localTimeArray(8, 504, i -> random.randomValues().nextLocalTimeArrayRaw(i, i)),
        dateTimeArray(16, 252, i -> random.randomValues().nextDateTimeArrayRaw(i, i)),
        localDateTimeArray(12, 336, i -> random.randomValues().nextLocalDateTimeArrayRaw(i, i)),
        durationArray(28, 144, i -> random.randomValues().nextDurationArrayRaw(i, i)),
        periodArray(28, 144, i -> random.randomValues().nextPeriodArrayRaw(i, i)),
        cartesianPointArray(8, 168, i -> (PointValue[])random.randomValues().nextCartesianPointArray(i, i).asObjectCopy()),
        cartesian3DPointArray(8, 126, i -> (PointValue[])random.randomValues().nextCartesian3DPointArray(i, i).asObjectCopy()),
        geographicPointArray(8, 168, i -> (PointValue[])random.randomValues().nextGeographicPointArray(i, i).asObjectCopy()),
        geographic3DPointArray(8, 126, i -> (PointValue[])random.randomValues().nextGeographic3DPointArray(i, i).asObjectCopy());

        private final int singleArrayEntrySize;
        private final DynamicValueGenerator generator;
        private final int expectedMax;

        private NamedDynamicValueGenerator(int singleArrayEntrySize, int expectedLongestArrayLength, DynamicValueGenerator generator) {
            this.singleArrayEntrySize = singleArrayEntrySize;
            this.expectedMax = expectedLongestArrayLength;
            this.generator = generator;
        }

        Object dynamicValue(int length) {
            return this.generator.dynamicValue(length);
        }

        Object dynamicValue(int keySizeLimit, int wiggleRoom) {
            int lowLimit = this.lowLimit(keySizeLimit, wiggleRoom, this.singleArrayEntrySize);
            int highLimit = this.highLimit(keySizeLimit, wiggleRoom, this.singleArrayEntrySize);
            return this.dynamicValue(random.intBetween(lowLimit, highLimit));
        }

        private int lowLimit(int keySizeLimit, int wiggleRoom, int singleEntrySize) {
            return (keySizeLimit - wiggleRoom) / singleEntrySize;
        }

        private int highLimit(int keySizeLimit, int wiggleRoom, int singleEntrySize) {
            return (keySizeLimit + wiggleRoom) / singleEntrySize;
        }

        @FunctionalInterface
        private static interface DynamicValueGenerator {
            public Object dynamicValue(int var1);
        }
    }

    private class SuccessAndFail {
        boolean atLeastOneSuccess;
        boolean atLeastOneFail;

        private SuccessAndFail() {
        }

        void ableToWrite(boolean ableToWrite) {
            if (ableToWrite) {
                this.atLeastOneSuccess = true;
            } else {
                this.atLeastOneFail = true;
            }
        }

        void verifyBothSuccessAndFail() {
            Assert.assertTrue((String)"not a single successful write, need to adjust parameters", (boolean)this.atLeastOneSuccess);
            Assert.assertTrue((String)"not a single failed write, need to adjust parameters", (boolean)this.atLeastOneFail);
        }
    }

    private class BinarySearch {
        private int longestSuccessful;
        private int minArrayLength;
        private int maxArrayLength = 1;
        private int arrayLength = 1;
        private boolean foundMaxLimit;

        private BinarySearch() {
        }

        boolean finished() {
            return this.arrayLength == this.minArrayLength;
        }

        void progress(boolean wasAbleToWrite) {
            if (wasAbleToWrite) {
                this.longestSuccessful = Math.max(this.arrayLength, this.longestSuccessful);
                if (!this.foundMaxLimit) {
                    this.minArrayLength = this.arrayLength;
                    this.maxArrayLength *= 2;
                    this.arrayLength = this.maxArrayLength;
                } else {
                    this.minArrayLength = this.arrayLength;
                    this.arrayLength = (this.minArrayLength + this.maxArrayLength) / 2;
                }
            } else {
                this.foundMaxLimit = true;
                this.maxArrayLength = this.arrayLength;
                this.arrayLength = (this.minArrayLength + this.maxArrayLength) / 2;
            }
        }
    }
}

