/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.UncloseableDelegatingFileSystemAbstraction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.mockito.matcher.Neo4jMatchers;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class SchemaIndexAcceptanceTest {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private GraphDatabaseService db;
    private final Label label = Label.label((String)"PERSON");
    private final String propertyKey = "key";

    @Before
    public void before() {
        this.db = this.newDb();
    }

    @After
    public void after() {
        this.db.shutdown();
    }

    @Test
    public void creatingIndexOnExistingDataBuildsIndexWhichWillBeOnlineNextStartup() {
        Node node3;
        Node node2;
        Node node1;
        try (Transaction tx = this.db.beginTx();){
            node1 = this.createNode(this.label, "name", "One");
            node2 = this.createNode(this.label, "name", "Two");
            node3 = this.createNode(this.label, "name", "Three");
            tx.success();
        }
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, (Label)this.label, (String[])new String[]{"key"});
        this.restart();
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"name", (Object)"One", (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{node1}));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"name", (Object)"Two", (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{node2}));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"name", (Object)"Three", (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{node3}));
    }

    @Test
    public void shouldIndexArrays() {
        Node node1;
        long[] arrayPropertyValue = new long[]{42L, 23L, 87L};
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, (Label)this.label, (String[])new String[]{"key"});
        try (Transaction tx = this.db.beginTx();){
            node1 = this.createNode(this.label, "key", arrayPropertyValue);
            tx.success();
        }
        this.restart();
        Assert.assertThat((Object)Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, (Label)this.label), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.haveState((GraphDatabaseService)this.db, (Schema.IndexState)Schema.IndexState.ONLINE)));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"key", (Object)arrayPropertyValue, (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{node1}));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"key", (Object)new long[]{42L, 23L}, (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"key", (Object)Arrays.toString(arrayPropertyValue), (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.isEmpty());
    }

    @Test
    public void shouldIndexStringArrays() {
        Node node1;
        Object[] arrayPropertyValue = new String[]{"A, B", "C"};
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, (Label)this.label, (String[])new String[]{"key"});
        try (Transaction tx = this.db.beginTx();){
            node1 = this.createNode(this.label, "key", arrayPropertyValue);
            tx.success();
        }
        this.restart();
        Assert.assertThat((Object)Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, (Label)this.label), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.haveState((GraphDatabaseService)this.db, (Schema.IndexState)Schema.IndexState.ONLINE)));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"key", (Object)arrayPropertyValue, (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{node1}));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"key", (Object)new String[]{"A", "B, C"}, (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"key", (Object)Arrays.toString(arrayPropertyValue), (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.isEmpty());
    }

    @Test
    public void shouldIndexArraysPostPopulation() {
        Node node1;
        long[] arrayPropertyValue = new long[]{42L, 23L, 87L};
        try (Transaction tx = this.db.beginTx();){
            node1 = this.createNode(this.label, "key", arrayPropertyValue);
            tx.success();
        }
        Neo4jMatchers.createIndex((GraphDatabaseService)this.db, (Label)this.label, (String[])new String[]{"key"});
        this.restart();
        Assert.assertThat((Object)Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, (Label)this.label), (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.db, (Matcher)Neo4jMatchers.haveState((GraphDatabaseService)this.db, (Schema.IndexState)Schema.IndexState.ONLINE)));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"key", (Object)arrayPropertyValue, (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.containsOnly((Object[])new Node[]{node1}));
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"key", (Object)new long[]{42L, 23L}, (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.isEmpty());
        Assert.assertThat((Object)Neo4jMatchers.findNodesByLabelAndProperty((Label)this.label, (String)"key", (Object)Arrays.toString(arrayPropertyValue), (GraphDatabaseService)this.db), (Matcher)Neo4jMatchers.isEmpty());
    }

    @Test
    public void recoveryAfterCreateAndDropIndex() throws Exception {
        IndexDefinition indexDefinition = Neo4jMatchers.createIndex((GraphDatabaseService)this.db, (Label)this.label, (String[])new String[]{"key"});
        this.createSomeData(this.label, "key");
        SchemaIndexAcceptanceTest.doStuff(this.db, this.label, "key");
        this.dropIndex(indexDefinition);
        SchemaIndexAcceptanceTest.doStuff(this.db, this.label, "key");
        this.crashAndRestart();
        Assert.assertThat((Object)Neo4jMatchers.getIndexes((GraphDatabaseService)this.db, (Label)this.label), (Matcher)Neo4jMatchers.isEmpty());
    }

    private GraphDatabaseService newDb() {
        return new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)new UncloseableDelegatingFileSystemAbstraction(this.fsRule.get())).newImpermanentDatabase();
    }

    private void crashAndRestart() throws Exception {
        this.fsRule.snapshot(() -> ((GraphDatabaseService)this.db).shutdown());
        this.db = this.newDb();
    }

    private void restart() {
        this.db.shutdown();
        this.db = this.newDb();
    }

    private Node createNode(Label label, Object ... properties) {
        Node node = this.db.createNode(new Label[]{label});
        for (Map.Entry property : MapUtil.map((Object[])properties).entrySet()) {
            node.setProperty((String)property.getKey(), property.getValue());
        }
        return node;
    }

    private void dropIndex(IndexDefinition indexDefinition) {
        try (Transaction tx = this.db.beginTx();){
            indexDefinition.drop();
            tx.success();
        }
    }

    private static void doStuff(GraphDatabaseService db, Label label, String propertyKey) {
        try (Transaction tx = db.beginTx();){
            for (Node node : Iterators.loop((Iterator)db.findNodes(label, propertyKey, (Object)3323))) {
                Iterables.count((Iterable)node.getLabels());
            }
        }
    }

    private void createSomeData(Label label, String propertyKey) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{label});
            node.setProperty(propertyKey, (Object)"yeah");
            tx.success();
        }
    }
}

