/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.constraints;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.impl.index.storage.layout.IndexFolderLayout;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class ConstraintCreationIT {
    @Rule
    public EmbeddedDatabaseRule db = new EmbeddedDatabaseRule().startLazily();
    private static final Label LABEL = Label.label((String)"label1");
    private static final long indexId = 1L;

    @Test
    public void shouldNotLeaveLuceneIndexFilesHangingAroundIfConstraintCreationFails() {
        this.db.withSetting(GraphDatabaseSettings.default_schema_provider, GraphDatabaseSettings.SchemaIndex.NATIVE20.providerName());
        this.attemptAndFailConstraintCreation();
        IndexProvider indexProvider = ((IndexProviderMap)this.db.getDependencyResolver().resolveDependency(IndexProviderMap.class)).getDefaultProvider();
        File indexDir = indexProvider.directoryStructure().directoryForIndex(1L);
        Assert.assertFalse((boolean)new IndexFolderLayout(indexDir).getIndexFolder().exists());
    }

    @Test
    public void shouldNotLeaveNativeIndexFilesHangingAroundIfConstraintCreationFails() {
        this.attemptAndFailConstraintCreation();
        IndexProvider indexProvider = ((IndexProviderMap)this.db.getDependencyResolver().resolveDependency(IndexProviderMap.class)).getDefaultProvider();
        File indexDir = indexProvider.directoryStructure().directoryForIndex(1L);
        Assert.assertFalse((boolean)indexDir.exists());
    }

    private void attemptAndFailConstraintCreation() {
        try (Transaction tx = this.db.beginTx();){
            for (int i = 0; i < 2; ++i) {
                Node node1 = this.db.createNode(new Label[]{LABEL});
                node1.setProperty("prop", (Object)true);
            }
            tx.success();
        }
        try {
            tx = this.db.beginTx();
            var2_3 = null;
            try {
                this.db.schema().constraintFor(LABEL).assertPropertyIsUnique("prop").create();
                Assert.fail((String)"Should have failed with ConstraintViolationException");
                tx.success();
            }
            catch (Throwable throwable) {
                var2_3 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var2_3 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var2_3.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (ConstraintViolationException tx2) {
            // empty catch block
        }
        var2_3 = null;
        try (Transaction ignore = this.db.beginTx();){
            Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)this.db.schema().getIndexes()));
        }
        catch (Throwable throwable) {
            var2_3 = throwable;
            throw throwable;
        }
    }
}

