/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.SchemaWrite;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.schema.RepeatedLabelInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInSchemaException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedRelationshipTypeInSchemaException;
import org.neo4j.kernel.api.schema.MultiTokenSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexProviderNotFoundException;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.storageengine.api.EntityType;

public class IndexCreateIT
extends KernelIntegrationTest {
    private static final IndexCreator INDEX_CREATOR = (schemaWrite, descriptor, providerName) -> schemaWrite.indexCreate((SchemaDescriptor)descriptor, providerName, Optional.empty());
    private static final IndexCreator UNIQUE_CONSTRAINT_CREATOR = SchemaWrite::uniquePropertyConstraintCreate;

    @Test
    public void shouldCreateIndexWithSpecificExistingProviderName() throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(INDEX_CREATOR);
    }

    @Test
    public void shouldCreateUniquePropertyConstraintWithSpecificExistingProviderName() throws KernelException {
        this.shouldCreateWithSpecificExistingProviderName(UNIQUE_CONSTRAINT_CREATOR);
    }

    @Test
    public void shouldFailCreateIndexWithNonExistentProviderName() throws KernelException {
        this.shouldFailWithNonExistentProviderName(INDEX_CREATOR);
    }

    @Test
    public void shouldFailCreateUniquePropertyConstraintWithNonExistentProviderName() throws KernelException {
        this.shouldFailWithNonExistentProviderName(UNIQUE_CONSTRAINT_CREATOR);
    }

    @Test
    public void shouldNotBePossibleToCreateIndexWithDuplicateLabel() throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        try {
            MultiTokenSchemaDescriptor descriptor = SchemaDescriptorFactory.multiToken((int[])new int[]{0, 0}, (EntityType)EntityType.NODE, (int[])new int[]{1});
            schemaWrite.indexCreate((SchemaDescriptor)descriptor);
            Assert.fail((String)"Should have failed");
        }
        catch (RepeatedLabelInSchemaException repeatedLabelInSchemaException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotBePossibleToCreateIndexWithDuplicateRelationshipTypes() throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        try {
            MultiTokenSchemaDescriptor descriptor = SchemaDescriptorFactory.multiToken((int[])new int[]{0, 0}, (EntityType)EntityType.RELATIONSHIP, (int[])new int[]{1});
            schemaWrite.indexCreate((SchemaDescriptor)descriptor);
            Assert.fail((String)"Should have failed");
        }
        catch (RepeatedRelationshipTypeInSchemaException repeatedRelationshipTypeInSchemaException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotBePossibleToCreateIndexWithDuplicateProperties() throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        try {
            org.neo4j.kernel.api.schema.LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1, 1});
            schemaWrite.indexCreate((SchemaDescriptor)descriptor);
            Assert.fail((String)"Should have failed");
        }
        catch (RepeatedPropertyInSchemaException repeatedPropertyInSchemaException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotBePossibleToCreateConstraintWithDuplicateProperties() throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        try {
            org.neo4j.kernel.api.schema.LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{1, 1});
            schemaWrite.uniquePropertyConstraintCreate((SchemaDescriptor)descriptor);
            Assert.fail((String)"Should have failed");
        }
        catch (RepeatedPropertyInSchemaException repeatedPropertyInSchemaException) {
            // empty catch block
        }
    }

    void shouldFailWithNonExistentProviderName(IndexCreator creator) throws KernelException {
        SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
        try {
            creator.create(schemaWrite, (LabelSchemaDescriptor)SchemaDescriptorFactory.forLabel((int)0, (int[])new int[]{0}), "something-completely-different");
            Assert.fail((String)"Should have failed");
        }
        catch (IndexProviderNotFoundException indexProviderNotFoundException) {
            // empty catch block
        }
    }

    void shouldCreateWithSpecificExistingProviderName(IndexCreator creator) throws KernelException {
        int labelId = 0;
        for (GraphDatabaseSettings.SchemaIndex indexSetting : GraphDatabaseSettings.SchemaIndex.values()) {
            SchemaWrite schemaWrite = this.schemaWriteInNewTransaction();
            String provider = indexSetting.providerName();
            org.neo4j.kernel.api.schema.LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)labelId++, (int[])new int[]{0});
            creator.create(schemaWrite, (LabelSchemaDescriptor)descriptor, provider);
            this.commit();
            Assert.assertEquals((Object)provider, (Object)this.indexingService.getIndexProxy((SchemaDescriptor)descriptor).getDescriptor().providerDescriptor().name());
        }
    }

    static interface IndexCreator {
        public void create(SchemaWrite var1, LabelSchemaDescriptor var2, String var3) throws SchemaKernelException;
    }
}

