/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.CombinableMatcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.impl.schema.NativeLuceneFusionIndexProviderFactory20;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.index.schema.tracking.TrackingIndexExtensionFactory;
import org.neo4j.kernel.impl.index.schema.tracking.TrackingReadersIndexAccessor;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class UniqueIndexSeekIT {
    @Rule
    public final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void uniqueIndexSeekDoNotLeakIndexReaders() throws KernelException {
        TrackingIndexExtensionFactory indexExtensionFactory = new TrackingIndexExtensionFactory();
        GraphDatabaseAPI database = this.createDatabase(indexExtensionFactory);
        try {
            Label label = Label.label((String)"spaceship");
            String nameProperty = "name";
            UniqueIndexSeekIT.createUniqueConstraint(database, label, nameProperty);
            UniqueIndexSeekIT.generateRandomData(database, label, nameProperty);
            Assert.assertNotNull((Object)((Object)indexExtensionFactory.getIndexProvider()));
            Assert.assertThat((Object)TrackingReadersIndexAccessor.numberOfClosedReaders(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            Assert.assertThat((Object)TrackingReadersIndexAccessor.numberOfOpenReaders(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
            Assert.assertThat((Object)TrackingReadersIndexAccessor.numberOfClosedReaders(), UniqueIndexSeekIT.closeTo(TrackingReadersIndexAccessor.numberOfOpenReaders(), 1L));
            UniqueIndexSeekIT.lockNodeUsingUniqueIndexSeek(database, label, nameProperty);
            Assert.assertThat((Object)TrackingReadersIndexAccessor.numberOfClosedReaders(), UniqueIndexSeekIT.closeTo(TrackingReadersIndexAccessor.numberOfOpenReaders(), 1L));
        }
        finally {
            database.shutdown();
        }
    }

    private static CombinableMatcher<Long> closeTo(long from, long delta) {
        return Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(from - delta))).and(Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(from + delta)));
    }

    private GraphDatabaseAPI createDatabase(TrackingIndexExtensionFactory indexExtensionFactory) {
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().setKernelExtensions(Collections.singletonList(indexExtensionFactory)).newEmbeddedDatabaseBuilder(this.directory.databaseDir()).setConfig(GraphDatabaseSettings.default_schema_provider, NativeLuceneFusionIndexProviderFactory20.DESCRIPTOR.name()).newGraphDatabase();
    }

    private static void lockNodeUsingUniqueIndexSeek(GraphDatabaseAPI database, Label label, String nameProperty) throws KernelException {
        try (Transaction transaction = database.beginTx();){
            ThreadToStatementContextBridge contextBridge = (ThreadToStatementContextBridge)database.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            KernelTransaction kernelTransaction = contextBridge.getKernelTransactionBoundToThisThread(true);
            TokenRead tokenRead = kernelTransaction.tokenRead();
            Read dataRead = kernelTransaction.dataRead();
            int labelId = tokenRead.nodeLabel(label.name());
            int propertyId = tokenRead.propertyKey(nameProperty);
            IndexReference indexReference = kernelTransaction.schemaRead().index(labelId, new int[]{propertyId});
            dataRead.lockingNodeUniqueIndexSeek(indexReference, new IndexQuery.ExactPredicate[]{IndexQuery.ExactPredicate.exact((int)propertyId, (Object)"value")});
            transaction.success();
        }
    }

    private static void generateRandomData(GraphDatabaseAPI database, Label label, String nameProperty) {
        for (int i = 0; i < 1000; ++i) {
            try (Transaction transaction = database.beginTx();){
                Node node = database.createNode(new Label[]{label});
                node.setProperty(nameProperty, (Object)("PlanetExpress" + i));
                transaction.success();
                continue;
            }
        }
    }

    private static void createUniqueConstraint(GraphDatabaseAPI database, Label label, String nameProperty) {
        try (Transaction transaction = database.beginTx();){
            database.schema().constraintFor(label).assertPropertyIsUnique(nameProperty).create();
            transaction.success();
        }
        transaction = database.beginTx();
        var4_4 = null;
        try {
            database.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            transaction.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var4_4 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }
}

