/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.index.internal.gbptree.TreeNodeDynamicSize;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.index.schema.LayoutTestUtil;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class StringLengthIndexValidationIT {
    @Parameterized.Parameter
    public static GraphDatabaseSettings.SchemaIndex schemaIndex;
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    private static final String propKey = "largeString";
    private static final int keySizeLimit;
    private static final AtomicBoolean trapPopulation;
    private static final Barrier.Control populationScanFinished;
    private GraphDatabaseService db;

    @Parameterized.Parameters(name="{0}")
    public static GraphDatabaseSettings.SchemaIndex[] parameters() {
        return new GraphDatabaseSettings.SchemaIndex[]{GraphDatabaseSettings.SchemaIndex.NATIVE20, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10};
    }

    @Before
    public void setup() {
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        Monitors monitors = new Monitors();
        IndexingService.MonitorAdapter trappingMonitor = new IndexingService.MonitorAdapter(){

            public void indexPopulationScanComplete() {
                if (trapPopulation.get()) {
                    populationScanFinished.reached();
                }
            }
        };
        monitors.addMonitorListener((Object)trappingMonitor, new String[0]);
        factory.setMonitors(monitors);
        this.db = factory.newEmbeddedDatabaseBuilder(this.testDirectory.storeDir()).setConfig(GraphDatabaseSettings.default_schema_provider, schemaIndex.providerName()).newGraphDatabase();
    }

    @After
    public void tearDown() {
        this.db.shutdown();
    }

    @Test
    public void shouldSuccessfullyWriteAndReadWithinIndexKeySizeLimit() {
        this.createIndex();
        String propValue = this.getString(keySizeLimit);
        long expectedNodeId = this.createNode(propValue);
        this.assertReadNode(propValue, expectedNodeId);
    }

    @Test
    public void shouldSuccessfullyPopulateIndexWithinIndexKeySizeLimit() {
        String propValue = this.getString(keySizeLimit);
        long expectedNodeId = this.createNode(propValue);
        this.createIndex();
        this.assertReadNode(propValue, expectedNodeId);
    }

    @Test
    public void txMustFailIfExceedingIndexKeySizeLimit() {
        this.createIndex();
        try (Transaction tx = this.db.beginTx();){
            String propValue = this.getString(keySizeLimit + 1);
            this.db.createNode(new Label[]{TestLabels.LABEL_ONE}).setProperty(propKey, (Object)propValue);
            tx.success();
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Please see index documentation for limitations."));
        }
    }

    @Test
    public void indexPopulationMustFailIfExceedingIndexKeySizeLimit() {
        String propValue = this.getString(keySizeLimit + 1);
        this.createNode(propValue);
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor((Label)TestLabels.LABEL_ONE).on(propKey).create();
            tx.success();
        }
        this.assertIndexFailToComeOnline();
        this.assertIndexInFailedState();
    }

    @Test
    public void externalUpdatesMustNotFailIndexPopulationIfWithinIndexKeySizeLimit() throws InterruptedException {
        trapPopulation.set(true);
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor((Label)TestLabels.LABEL_ONE).on(propKey).create();
            tx.success();
        }
        populationScanFinished.await();
        String propValue = this.getString(keySizeLimit);
        long nodeId = this.createNode(propValue);
        populationScanFinished.release();
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        this.assertReadNode(propValue, nodeId);
    }

    @Test
    public void externalUpdatesMustFailIndexPopulationIfExceedingIndexKeySizeLimit() throws InterruptedException {
        trapPopulation.set(true);
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor((Label)TestLabels.LABEL_ONE).on(propKey).create();
            tx.success();
        }
        populationScanFinished.await();
        String propValue = this.getString(keySizeLimit + 1);
        this.createNode(propValue);
        populationScanFinished.release();
        this.assertIndexFailToComeOnline();
        this.assertIndexInFailedState();
    }

    public void assertIndexFailToComeOnline() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)String.format("Index IndexDefinition[label:LABEL_ONE on:largeString] (IndexRule[id=1, descriptor=Index( GENERAL, :label[0](property[0]) ), provider={key=%s, version=%s}]) entered a FAILED state.", schemaIndex.providerKey(), schemaIndex.providerVersion())), (Matcher)Matchers.containsString((String)"Failed while trying to write to index, targetIndex=Index( GENERAL, :LABEL_ONE(largeString) ), nodeId=0")));
        }
    }

    public void assertIndexInFailedState() {
        try (Transaction tx = this.db.beginTx();){
            Iterator iterator = this.db.schema().getIndexes((Label)TestLabels.LABEL_ONE).iterator();
            Assert.assertTrue((boolean)iterator.hasNext());
            IndexDefinition next = (IndexDefinition)iterator.next();
            Assert.assertEquals((String)"state is FAILED", (Object)Schema.IndexState.FAILED, (Object)this.db.schema().getIndexState(next));
            Assert.assertThat((Object)this.db.schema().getIndexFailure(next), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Index key-value size it to large. Please see index documentation for limitations."), (Matcher)Matchers.containsString((String)"Failed while trying to write to index, targetIndex=Index( GENERAL, :LABEL_ONE(largeString) ), nodeId=0")));
            tx.success();
        }
    }

    private String getString(int keySize) {
        return LayoutTestUtil.generateStringResultingInSizeForIndexProvider((int)keySize, (GraphDatabaseSettings.SchemaIndex)schemaIndex);
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor((Label)TestLabels.LABEL_ONE).on(propKey).create();
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private long createNode(String propValue) {
        long expectedNodeId;
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{TestLabels.LABEL_ONE});
            node.setProperty(propKey, (Object)propValue);
            expectedNodeId = node.getId();
            tx.success();
        }
        return expectedNodeId;
    }

    private void assertReadNode(String propValue, long expectedNodeId) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.findNode((Label)TestLabels.LABEL_ONE, propKey, (Object)propValue);
            Assert.assertNotNull((Object)node);
            Assert.assertEquals((String)"node id", (long)expectedNodeId, (long)node.getId());
            tx.success();
        }
    }

    static {
        keySizeLimit = TreeNodeDynamicSize.keyValueSizeCapFromPageSize((int)8192);
        trapPopulation = new AtomicBoolean();
        populationScanFinished = new Barrier.Control();
    }
}

