/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema.tracking;

import java.io.IOException;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.tracking.TrackingReadersIndexAccessor;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public class TrackingReadersIndexProvider
extends IndexProvider {
    private final IndexProvider indexProvider;

    TrackingReadersIndexProvider(IndexProvider copySource) {
        super(copySource);
        this.indexProvider = copySource;
    }

    public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, ByteBufferFactory bufferFactory, TokenNameLookup tokenNameLookup) {
        return this.indexProvider.getPopulator(descriptor, samplingConfig, bufferFactory, tokenNameLookup);
    }

    public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig, TokenNameLookup tokenNameLookup) throws IOException {
        return new TrackingReadersIndexAccessor(this.indexProvider.getOnlineAccessor(descriptor, samplingConfig, tokenNameLookup));
    }

    public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
        return this.indexProvider.getPopulationFailure(descriptor);
    }

    public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
        return this.indexProvider.getInitialState(descriptor);
    }

    public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
        return this.indexProvider.getCapability(descriptor);
    }

    public IndexProviderDescriptor getProviderDescriptor() {
        return this.indexProvider.getProviderDescriptor();
    }

    public boolean equals(Object o) {
        return this.indexProvider.equals(o);
    }

    public int hashCode() {
        return this.indexProvider.hashCode();
    }

    public IndexDirectoryStructure directoryStructure() {
        return this.indexProvider.directoryStructure();
    }

    public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
        return this.indexProvider.storeMigrationParticipant(fs, pageCache);
    }
}

