/*
 * Decompiled with CFR 0.152.
 */
package schema;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.storable.Values;

public class IndexPopulationFlipRaceIT {
    private static final int NODES_PER_INDEX = 10;
    @Rule
    public final DatabaseRule db = new EmbeddedDatabaseRule();
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void shouldAtomicallyFlipMultipleIndexes() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.createIndexesButDontWaitForThemToFullyPopulate(i);
            Pair<long[], long[]> data = this.createDataThatGoesIntoToThoseIndexes(i);
            this.awaitIndexes();
            this.verifyThatThereAreExactlyOneIndexEntryPerNodeInTheIndexes(i, data);
        }
    }

    private void awaitIndexes() {
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(30L, TimeUnit.SECONDS);
            tx.success();
        }
    }

    private void createIndexesButDontWaitForThemToFullyPopulate(int i) {
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(IndexPopulationFlipRaceIT.labelA(i)).on(IndexPopulationFlipRaceIT.keyA(i)).create();
            if (this.random.nextBoolean()) {
                this.db.schema().indexFor(IndexPopulationFlipRaceIT.labelB(i)).on(IndexPopulationFlipRaceIT.keyB(i)).create();
            } else {
                this.db.schema().constraintFor(IndexPopulationFlipRaceIT.labelB(i)).assertPropertyIsUnique(IndexPopulationFlipRaceIT.keyB(i)).create();
            }
            tx.success();
        }
    }

    private static String keyB(int i) {
        return "key_b" + i;
    }

    private static Label labelB(int i) {
        return Label.label((String)("Label_b" + i));
    }

    private static String keyA(int i) {
        return "key_a" + i;
    }

    private static Label labelA(int i) {
        return Label.label((String)("Label_a" + i));
    }

    private Pair<long[], long[]> createDataThatGoesIntoToThoseIndexes(int i) {
        long[] dataA = new long[10];
        long[] dataB = new long[10];
        for (int t = 0; t < 10; ++t) {
            try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
                Node nodeA = this.db.createNode(new Label[]{IndexPopulationFlipRaceIT.labelA(i)});
                dataA[t] = nodeA.getId();
                nodeA.setProperty(IndexPopulationFlipRaceIT.keyA(i), (Object)dataA[t]);
                Node nodeB = this.db.createNode(new Label[]{IndexPopulationFlipRaceIT.labelB(i)});
                dataB[t] = nodeB.getId();
                nodeB.setProperty(IndexPopulationFlipRaceIT.keyB(i), (Object)dataB[t]);
                tx.success();
                continue;
            }
        }
        return Pair.of((Object)dataA, (Object)dataB);
    }

    private void verifyThatThereAreExactlyOneIndexEntryPerNodeInTheIndexes(int i, Pair<long[], long[]> data) throws Exception {
        Kernel kernel = (Kernel)this.db.getDependencyResolver().resolveDependency(Kernel.class);
        try (Transaction tx = kernel.beginTransaction(Transaction.Type.implicit, (LoginContext)AnonymousContext.read());){
            int labelAId = tx.tokenRead().nodeLabel(IndexPopulationFlipRaceIT.labelA(i).name());
            int keyAId = tx.tokenRead().propertyKey(IndexPopulationFlipRaceIT.keyA(i));
            int labelBId = tx.tokenRead().nodeLabel(IndexPopulationFlipRaceIT.labelB(i).name());
            int keyBId = tx.tokenRead().propertyKey(IndexPopulationFlipRaceIT.keyB(i));
            IndexDescriptor indexA = TestIndexDescriptorFactory.forLabel((int)labelAId, (int[])new int[]{keyAId});
            IndexDescriptor indexB = TestIndexDescriptorFactory.forLabel((int)labelBId, (int[])new int[]{keyBId});
            for (int j = 0; j < 10; ++j) {
                long nodeAId = ((long[])data.first())[j];
                Assert.assertEquals((long)1L, (long)tx.schemaRead().nodesCountIndexed((IndexReference)indexA, nodeAId, keyAId, Values.of((Object)nodeAId)));
                long nodeBId = ((long[])data.other())[j];
                Assert.assertEquals((long)1L, (long)tx.schemaRead().nodesCountIndexed((IndexReference)indexB, nodeBId, keyBId, Values.of((Object)nodeBId)));
            }
        }
    }
}

