/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.scheduler.CentralJobScheduler;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.NullLogService;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.test.rule.PageCacheAndDependenciesRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.test.rule.fs.FileSystemRule;

public class NonUniqueIndexTest {
    private static final String LABEL = "SomeLabel";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    @Rule
    public PageCacheAndDependenciesRule resources = new PageCacheAndDependenciesRule().with((FileSystemRule)new DefaultFileSystemRule());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void concurrentIndexPopulationAndInsertsShouldNotProduceDuplicates() throws Exception {
        Config config = Config.defaults();
        GraphDatabaseService db = this.newEmbeddedGraphDatabaseWithSlowJobScheduler(config);
        try {
            Node node;
            try (Transaction tx = db.beginTx();){
                db.schema().indexFor(Label.label((String)LABEL)).on(KEY).create();
                tx.success();
            }
            try (Transaction tx = db.beginTx();){
                node = db.createNode(new Label[]{Label.label((String)LABEL)});
                node.setProperty(KEY, (Object)VALUE);
                tx.success();
            }
            tx = db.beginTx();
            var5_7 = null;
            try {
                db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
                tx.success();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var5_7 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            tx = db.beginTx();
            var5_7 = null;
            try {
                KernelTransaction ktx = ((ThreadToStatementContextBridge)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
                IndexReference index = ktx.schemaRead().index(ktx.tokenRead().nodeLabel(LABEL), new int[]{ktx.tokenRead().propertyKey(KEY)});
                NodeValueIndexCursor cursor = ktx.cursors().allocateNodeValueIndexCursor();
                ktx.dataRead().nodeIndexSeek(index, cursor, IndexOrder.NONE, false, new IndexQuery[]{IndexQuery.exact((int)1, (Object)VALUE)});
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((long)node.getId(), (long)cursor.nodeReference());
                Assert.assertFalse((boolean)cursor.next());
                tx.success();
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var5_7 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            db.shutdown();
        }
    }

    private GraphDatabaseService newEmbeddedGraphDatabaseWithSlowJobScheduler(Config config) {
        GraphDatabaseFactoryState graphDatabaseFactoryState = new GraphDatabaseFactoryState();
        graphDatabaseFactoryState.setUserLogProvider(NullLogService.getInstance().getUserLogProvider());
        return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

            protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                return new PlatformModule(storeDir, config, this.databaseInfo, dependencies){

                    protected CentralJobScheduler createJobScheduler() {
                        return NonUniqueIndexTest.newSlowJobScheduler();
                    }

                    protected LogService createLogService(LogProvider userLogProvider) {
                        return NullLogService.getInstance();
                    }
                };
            }
        }.newFacade(this.resources.directory().storeDir(), config, graphDatabaseFactoryState.databaseDependencies());
    }

    private static CentralJobScheduler newSlowJobScheduler() {
        return new CentralJobScheduler(){

            public JobHandle schedule(Group group, Runnable job) {
                return super.schedule(group, NonUniqueIndexTest.slowRunnable(job));
            }
        };
    }

    private static Runnable slowRunnable(Runnable target) {
        return () -> {
            LockSupport.parkNanos(100000000L);
            target.run();
        };
    }
}

