/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.api.exceptions.schema.UnableToValidateConstraintException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.index.schema.FailingGenericNativeIndexProviderFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;

public class ConstraintIndexFailureIT {
    @Rule
    public final RandomRule random = new RandomRule();
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFailToValidateConstraintsIfUnderlyingIndexIsFailed() throws Exception {
        Throwable throwable;
        Transaction tx;
        File dir = this.directory.databaseDir();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(dir);
        try {
            tx = db.beginTx();
            throwable = null;
            try {
                db.schema().constraintFor(Label.label((String)"Label1")).assertPropertyIsUnique("key1").create();
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        finally {
            db.shutdown();
        }
        FileUtils.deleteRecursively((File)IndexDirectoryStructure.baseSchemaIndexFolder((File)dir));
        db = new TestGraphDatabaseFactory().removeKernelExtensions(TestGraphDatabaseFactory.INDEX_PROVIDERS_FILTER).addKernelExtension((KernelExtensionFactory)new FailingGenericNativeIndexProviderFactory(new FailingGenericNativeIndexProviderFactory.FailureType[]{FailingGenericNativeIndexProviderFactory.FailureType.INITIAL_STATE})).newEmbeddedDatabase(dir);
        try {
            tx = db.beginTx();
            throwable = null;
            try {
                db.createNode(new Label[]{Label.label((String)"Label1")}).setProperty("key1", (Object)"value1");
                Assert.fail((String)"expected exception");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (ConstraintViolationException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(UnableToValidateConstraintException.class));
            Assert.assertThat((Object)e.getCause().getCause().getMessage(), (Matcher)CoreMatchers.allOf((Matcher)Matchers.containsString((String)"The index is in a failed state:"), (Matcher)Matchers.containsString((String)"Override initial state as failed")));
        }
        finally {
            db.shutdown();
        }
    }
}

