/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.impl.fulltext.FulltextProceduresTest;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.CleanupRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class FulltextIndexConsistencyCheckIT {
    private final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final ExpectedException expectedException = ExpectedException.none();
    private final CleanupRule cleanup = new CleanupRule();
    @Rule
    public final RuleChain rules = RuleChain.outerRule((TestRule)this.fs).around((TestRule)this.testDirectory).around((TestRule)this.expectedException).around((TestRule)this.cleanup);
    private GraphDatabaseBuilder builder;

    @Before
    public void before() {
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        this.builder = factory.newEmbeddedDatabaseBuilder(this.testDirectory.databaseDir());
    }

    @Test
    public void mustBeAbleToConsistencyCheckEmptyDatabaseWithFulltextIndexingEnabled() throws Exception {
        this.createDatabase().shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckNodeIndexWithOneLabelAndOneProperty() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("Label"), FulltextProceduresTest.array("prop"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            db.createNode(new Label[]{Label.label((String)"Label")}).setProperty("prop", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckNodeIndexWithOneLabelAndMultipleProperties() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("Label"), FulltextProceduresTest.array("p1", "p2"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = db.createNode(new Label[]{Label.label((String)"Label")});
            node.setProperty("p1", (Object)"value");
            node.setProperty("p2", (Object)"value");
            db.createNode(new Label[]{Label.label((String)"Label")}).setProperty("p1", (Object)"value");
            db.createNode(new Label[]{Label.label((String)"Label")}).setProperty("p2", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckNodeIndexWithMultipleLabelsAndOneProperty() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("L1", "L2"), FulltextProceduresTest.array("prop"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            db.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")}).setProperty("prop", (Object)"value");
            db.createNode(new Label[]{Label.label((String)"L2")}).setProperty("prop", (Object)"value");
            db.createNode(new Label[]{Label.label((String)"L1")}).setProperty("prop", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckNodeIndexWithManyLabelsAndOneProperty() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        String[] labels = new String[]{"L1", "L2", "L3", "L4", "L5", "L6", "L7", "L8", "L9", "L10", "L11", "L12", "L13", "L14", "L15", "L16"};
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array(labels), FulltextProceduresTest.array("prop"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            db.createNode((Label[])Stream.of(labels).map(Label::label).toArray(Label[]::new)).setProperty("prop", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckNodeIndexWithMultipleLabelsAndMultipleProperties() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("L1", "L2"), FulltextProceduresTest.array("p1", "p2"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node n1 = db.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            n1.setProperty("p1", (Object)"value");
            n1.setProperty("p2", (Object)"value");
            Node n2 = db.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            n2.setProperty("p1", (Object)"value");
            Node n3 = db.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            n3.setProperty("p2", (Object)"value");
            Node n4 = db.createNode(new Label[]{Label.label((String)"L1")});
            n4.setProperty("p1", (Object)"value");
            n4.setProperty("p2", (Object)"value");
            Node n5 = db.createNode(new Label[]{Label.label((String)"L1")});
            n5.setProperty("p1", (Object)"value");
            Node n6 = db.createNode(new Label[]{Label.label((String)"L1")});
            n6.setProperty("p2", (Object)"value");
            Node n7 = db.createNode(new Label[]{Label.label((String)"L2")});
            n7.setProperty("p1", (Object)"value");
            n7.setProperty("p2", (Object)"value");
            Node n8 = db.createNode(new Label[]{Label.label((String)"L2")});
            n8.setProperty("p1", (Object)"value");
            Node n9 = db.createNode(new Label[]{Label.label((String)"L2")});
            n9.setProperty("p2", (Object)"value");
            db.createNode(new Label[]{Label.label((String)"L2")}).setProperty("p1", (Object)"value");
            db.createNode(new Label[]{Label.label((String)"L2")}).setProperty("p2", (Object)"value");
            db.createNode(new Label[]{Label.label((String)"L1")}).setProperty("p1", (Object)"value");
            db.createNode(new Label[]{Label.label((String)"L1")}).setProperty("p2", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckRelationshipIndexWithOneRelationshipTypeAndOneProperty() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        RelationshipType relationshipType = RelationshipType.withName((String)"R1");
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextProceduresTest.array("R1"), FulltextProceduresTest.array("p1"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = db.createNode();
            node.createRelationshipTo(node, relationshipType).setProperty("p1", (Object)"value");
            node.createRelationshipTo(node, relationshipType).setProperty("p1", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckRelationshipIndexWithOneRelationshipTypeAndMultipleProperties() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        RelationshipType relationshipType = RelationshipType.withName((String)"R1");
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextProceduresTest.array("R1"), FulltextProceduresTest.array("p1", "p2"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var4_4 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = db.createNode();
            Relationship r1 = node.createRelationshipTo(node, relationshipType);
            r1.setProperty("p1", (Object)"value");
            r1.setProperty("p2", (Object)"value");
            Relationship r2 = node.createRelationshipTo(node, relationshipType);
            r2.setProperty("p1", (Object)"value");
            r2.setProperty("p2", (Object)"value");
            node.createRelationshipTo(node, relationshipType).setProperty("p1", (Object)"value");
            node.createRelationshipTo(node, relationshipType).setProperty("p2", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckRelationshipIndexWithMultipleRelationshipTypesAndOneProperty() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        RelationshipType relType1 = RelationshipType.withName((String)"R1");
        RelationshipType relType2 = RelationshipType.withName((String)"R2");
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextProceduresTest.array("R1", "R2"), FulltextProceduresTest.array("p1"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var5_5 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node n1 = db.createNode();
            Node n2 = db.createNode();
            n1.createRelationshipTo(n1, relType1).setProperty("p1", (Object)"value");
            n1.createRelationshipTo(n1, relType2).setProperty("p1", (Object)"value");
            n2.createRelationshipTo(n2, relType1).setProperty("p1", (Object)"value");
            n2.createRelationshipTo(n2, relType2).setProperty("p1", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckRelationshipIndexWithMultipleRelationshipTypesAndMultipleProperties() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        RelationshipType relType1 = RelationshipType.withName((String)"R1");
        RelationshipType relType2 = RelationshipType.withName((String)"R2");
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextProceduresTest.array("R1", "R2"), FulltextProceduresTest.array("p1", "p2"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var5_5 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node n1 = db.createNode();
            Node n2 = db.createNode();
            Relationship r1 = n1.createRelationshipTo(n1, relType1);
            r1.setProperty("p1", (Object)"value");
            r1.setProperty("p2", (Object)"value");
            Relationship r2 = n1.createRelationshipTo(n1, relType2);
            r2.setProperty("p1", (Object)"value");
            r2.setProperty("p2", (Object)"value");
            Relationship r3 = n2.createRelationshipTo(n2, relType1);
            r3.setProperty("p1", (Object)"value");
            r3.setProperty("p2", (Object)"value");
            Relationship r4 = n2.createRelationshipTo(n2, relType2);
            r4.setProperty("p1", (Object)"value");
            r4.setProperty("p2", (Object)"value");
            n1.createRelationshipTo(n2, relType1).setProperty("p1", (Object)"value");
            n1.createRelationshipTo(n2, relType2).setProperty("p1", (Object)"value");
            n1.createRelationshipTo(n2, relType1).setProperty("p2", (Object)"value");
            n1.createRelationshipTo(n2, relType2).setProperty("p2", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_5 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckNodeAndRelationshipIndexesAtTheSameTime() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("L1", "L2", "L3"), FulltextProceduresTest.array("p1", "p2"))).close();
            db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextProceduresTest.array("R1", "R2"), FulltextProceduresTest.array("p1", "p2"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node n1 = db.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L3")});
            n1.setProperty("p1", (Object)"value");
            n1.setProperty("p2", (Object)"value");
            n1.createRelationshipTo(n1, RelationshipType.withName((String)"R2")).setProperty("p1", (Object)"value");
            Node n2 = db.createNode(new Label[]{Label.label((String)"L2")});
            n2.setProperty("p2", (Object)"value");
            Relationship r1 = n2.createRelationshipTo(n2, RelationshipType.withName((String)"R1"));
            r1.setProperty("p1", (Object)"value");
            r1.setProperty("p2", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencyCheckNodeIndexThatIsMissingNodesBecauseTheirPropertyValuesAreNotStrings() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("L1"), FulltextProceduresTest.array("p1"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            db.createNode(new Label[]{Label.label((String)"L1")}).setProperty("p1", (Object)1);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustBeAbleToConsistencycheckRelationshipIndexThatIsMissingRelationshipsBecauseTheirPropertyValuesaAreNotStrings() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextProceduresTest.array("R1"), FulltextProceduresTest.array("p1"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = db.createNode();
            node.createRelationshipTo(node, RelationshipType.withName((String)"R1")).setProperty("p1", (Object)1);
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void consistencyCheckerMustBeAbleToRunOnStoreWithFulltextIndexes() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        Label[] labels = (Label[])IntStream.range(1, 7).mapToObj(i -> Label.label((String)("LABEL" + i))).toArray(Label[]::new);
        RelationshipType[] relTypes = (RelationshipType[])IntStream.range(1, 5).mapToObj(i -> RelationshipType.withName((String)("REL" + i))).toArray(RelationshipType[]::new);
        String[] propertyKeys = (String[])IntStream.range(1, 7).mapToObj(i -> "PROP" + i).toArray(String[]::new);
        RandomValues randomValues = RandomValues.create();
        try (Transaction tx = db.beginTx();){
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            int nodeCount = 1000;
            ArrayList<Node> nodes = new ArrayList<Node>(nodeCount);
            for (int i2 = 0; i2 < nodeCount; ++i2) {
                Label[] nodeLabels = (Label[])rng.ints(rng.nextInt(labels.length), 0, labels.length).distinct().mapToObj(x -> labels[x]).toArray(Label[]::new);
                Node node = db.createNode(nodeLabels);
                Stream.of(propertyKeys).forEach(p -> node.setProperty(p, rng.nextBoolean() ? p : randomValues.nextValue().asObject()));
                nodes.add(node);
                int localRelCount = Math.min(nodes.size(), 5);
                rng.ints(localRelCount, 0, localRelCount).distinct().mapToObj(x -> node.createRelationshipTo((Node)nodes.get(x), relTypes[rng.nextInt(relTypes.length)])).forEach(r -> Stream.of(propertyKeys).forEach(p -> r.setProperty(p, rng.nextBoolean() ? p : randomValues.nextValue().asObject())));
            }
            tx.success();
        }
        tx = db.beginTx();
        var7_7 = null;
        try {
            int i3;
            for (i3 = 1; i3 < labels.length; ++i3) {
                db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes" + i3, FulltextProceduresTest.array((String[])Arrays.stream(labels).limit(i3).map(Label::name).toArray(String[]::new)), FulltextProceduresTest.array(Arrays.copyOf(propertyKeys, i3)))).close();
            }
            for (i3 = 1; i3 < relTypes.length; ++i3) {
                db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels" + i3, FulltextProceduresTest.array((String[])Arrays.stream(relTypes).limit(i3).map(RelationshipType::name).toArray(String[]::new)), FulltextProceduresTest.array(Arrays.copyOf(propertyKeys, i3)))).close();
            }
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = db.beginTx();
        var7_7 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            tx.success();
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var7_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustDiscoverNodeInStoreMissingFromIndex() throws Exception {
        long nodeId;
        StoreIndexDescriptor indexDescriptor;
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("Label"), FulltextProceduresTest.array("prop"))).close();
            tx.success();
        }
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            indexDescriptor = FulltextIndexConsistencyCheckIT.getIndexDescriptor((IndexDefinition)Iterables.first((Iterable)db.schema().getIndexes()));
            Node node = db.createNode(new Label[]{Label.label((String)"Label")});
            node.setProperty("prop", (Object)"value");
            nodeId = node.getId();
            tx.success();
        }
        IndexingService indexes = FulltextIndexConsistencyCheckIT.getIndexingService(db);
        IndexProxy indexProxy = indexes.getIndexProxy(indexDescriptor.schema());
        try (IndexUpdater updater = indexProxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(IndexEntryUpdate.remove((long)nodeId, (SchemaDescriptorSupplier)indexDescriptor, (Value[])new Value[]{Values.stringValue((String)"value")}));
        }
        db.shutdown();
        ConsistencyCheckService.Result result = this.checkConsistency();
        Assert.assertFalse((boolean)result.isSuccessful());
    }

    @Ignore(value="Turns out that this is not something that the consistency checker actually looks for, currently. The test is disabled until the consistency checker is extended with checks that will discover this sort of inconsistency.")
    @Test
    public void mustDiscoverNodeInIndexMissingFromStore() throws Exception {
        long nodeId;
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("Label"), FulltextProceduresTest.array("prop"))).close();
            tx.success();
        }
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = db.createNode(new Label[]{Label.label((String)"Label")});
            nodeId = node.getId();
            node.setProperty("prop", (Object)"value");
            tx.success();
        }
        NeoStores stores = FulltextIndexConsistencyCheckIT.getNeoStores(db);
        NodeRecord record = (NodeRecord)stores.getNodeStore().newRecord();
        record = (NodeRecord)stores.getNodeStore().getRecord(nodeId, (AbstractBaseRecord)record, RecordLoad.NORMAL);
        long propId = record.getNextProp();
        record.setNextProp(-1L);
        stores.getNodeStore().updateRecord(record);
        PropertyRecord propRecord = (PropertyRecord)stores.getPropertyStore().getRecord(propId, (AbstractBaseRecord)stores.getPropertyStore().newRecord(), RecordLoad.NORMAL);
        propRecord.setInUse(false);
        stores.getPropertyStore().updateRecord(propRecord);
        db.shutdown();
        ConsistencyCheckService.Result result = this.checkConsistency();
        Assert.assertFalse((boolean)result.isSuccessful());
    }

    @Test
    public void mustDiscoverNodePropertyIndexMismatch() throws Exception {
        long nodeId;
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("L1", "L2"), FulltextProceduresTest.array("p1", "p2"))).close();
            tx.success();
        }
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = db.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            nodeId = node.getId();
            node.setProperty("p1", (Object)"value");
            node.setProperty("p2", (Object)"value");
            tx.success();
        }
        NeoStores stores = FulltextIndexConsistencyCheckIT.getNeoStores(db);
        NodeRecord record = (NodeRecord)stores.getNodeStore().getRecord(nodeId, stores.getNodeStore().newRecord(), RecordLoad.NORMAL);
        long propId = record.getNextProp();
        PropertyRecord propRecord = (PropertyRecord)stores.getPropertyStore().getRecord(propId, (AbstractBaseRecord)stores.getPropertyStore().newRecord(), RecordLoad.NORMAL);
        propRecord.removePropertyBlock(1);
        stores.getPropertyStore().updateRecord(propRecord);
        db.shutdown();
        ConsistencyCheckService.Result result = this.checkConsistency();
        Assert.assertFalse((boolean)result.isSuccessful());
    }

    @Test
    public void shouldNotReportNodesWithoutAllPropertiesInIndex() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("L1", "L2"), FulltextProceduresTest.array("p1", "p2"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = db.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            node.setProperty("p1", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void shouldNotReportNodesWithMorePropertiesThanInIndex() throws Exception {
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createNodeIndex(\"%s\", %s, %s )", "nodes", FulltextProceduresTest.array("L1", "L2"), FulltextProceduresTest.array("p1"))).close();
            tx.success();
        }
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = db.createNode(new Label[]{Label.label((String)"L1"), Label.label((String)"L2")});
            node.setProperty("p1", (Object)"value");
            node.setProperty("p2", (Object)"value");
            tx.success();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db.shutdown();
        FulltextIndexConsistencyCheckIT.assertIsConsistent(this.checkConsistency());
    }

    @Test
    public void mustDiscoverRelationshipInStoreMissingFromIndex() throws Exception {
        long relId;
        StoreIndexDescriptor indexDescriptor;
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextProceduresTest.array("REL"), FulltextProceduresTest.array("prop"))).close();
            tx.success();
        }
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            indexDescriptor = FulltextIndexConsistencyCheckIT.getIndexDescriptor((IndexDefinition)Iterables.first((Iterable)db.schema().getIndexes()));
            Node node = db.createNode();
            Relationship rel = node.createRelationshipTo(node, RelationshipType.withName((String)"REL"));
            rel.setProperty("prop", (Object)"value");
            relId = rel.getId();
            tx.success();
        }
        IndexingService indexes = FulltextIndexConsistencyCheckIT.getIndexingService(db);
        IndexProxy indexProxy = indexes.getIndexProxy(indexDescriptor.schema());
        try (IndexUpdater updater = indexProxy.newUpdater(IndexUpdateMode.ONLINE);){
            updater.process(IndexEntryUpdate.remove((long)relId, (SchemaDescriptorSupplier)indexDescriptor, (Value[])new Value[]{Values.stringValue((String)"value")}));
        }
        db.shutdown();
        ConsistencyCheckService.Result result = this.checkConsistency();
        Assert.assertFalse((boolean)result.isSuccessful());
    }

    @Test
    public void mustDiscoverRelationshipPropertyIndexMismatch() throws Exception {
        long relId;
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextProceduresTest.array("REL"), FulltextProceduresTest.array("p1", "p2"))).close();
            tx.success();
        }
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = db.createNode();
            Relationship rel = node.createRelationshipTo(node, RelationshipType.withName((String)"REL"));
            rel.setProperty("p1", (Object)"value");
            rel.setProperty("p2", (Object)"value");
            relId = rel.getId();
            tx.success();
        }
        NeoStores stores = FulltextIndexConsistencyCheckIT.getNeoStores(db);
        RelationshipRecord record = (RelationshipRecord)stores.getRelationshipStore().getRecord(relId, stores.getRelationshipStore().newRecord(), RecordLoad.NORMAL);
        long propId = record.getNextProp();
        PropertyRecord propRecord = (PropertyRecord)stores.getPropertyStore().getRecord(propId, (AbstractBaseRecord)stores.getPropertyStore().newRecord(), RecordLoad.NORMAL);
        propRecord.removePropertyBlock(1);
        stores.getPropertyStore().updateRecord(propRecord);
        db.shutdown();
        ConsistencyCheckService.Result result = this.checkConsistency();
        Assert.assertFalse((boolean)result.isSuccessful());
    }

    @Ignore(value="Turns out that this is not something that the consistency checker actually looks for, currently. The test is disabled until the consistency checker is extended with checks that will discover this sort of inconsistency.")
    @Test
    public void mustDiscoverRelationshipInIndexMissingFromStore() throws Exception {
        long relId;
        GraphDatabaseService db = this.createDatabase();
        try (Transaction tx = db.beginTx();){
            db.execute(String.format("CALL db.index.fulltext.createRelationshipIndex(\"%s\", %s, %s)", "rels", FulltextProceduresTest.array("REL"), FulltextProceduresTest.array("prop"))).close();
            tx.success();
        }
        try (Transaction tx = db.beginTx();){
            db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            Node node = db.createNode();
            Relationship rel = node.createRelationshipTo(node, RelationshipType.withName((String)"REL"));
            relId = rel.getId();
            rel.setProperty("prop", (Object)"value");
            tx.success();
        }
        NeoStores stores = FulltextIndexConsistencyCheckIT.getNeoStores(db);
        RelationshipRecord record = (RelationshipRecord)stores.getRelationshipStore().newRecord();
        record = (RelationshipRecord)stores.getRelationshipStore().getRecord(relId, (AbstractBaseRecord)record, RecordLoad.NORMAL);
        long propId = record.getNextProp();
        record.setNextProp(-1L);
        stores.getRelationshipStore().updateRecord((AbstractBaseRecord)record);
        PropertyRecord propRecord = (PropertyRecord)stores.getPropertyStore().getRecord(propId, (AbstractBaseRecord)stores.getPropertyStore().newRecord(), RecordLoad.NORMAL);
        propRecord.setInUse(false);
        stores.getPropertyStore().updateRecord(propRecord);
        db.shutdown();
        ConsistencyCheckService.Result result = this.checkConsistency();
        Assert.assertFalse((boolean)result.isSuccessful());
    }

    private GraphDatabaseService createDatabase() {
        return (GraphDatabaseService)this.cleanup.add((Object)this.builder.newGraphDatabase());
    }

    private ConsistencyCheckService.Result checkConsistency() throws ConsistencyCheckIncompleteException {
        Config config = Config.defaults();
        ConsistencyCheckService consistencyCheckService = new ConsistencyCheckService(new Date());
        ConsistencyFlags checkConsistencyConfig = new ConsistencyFlags(config);
        return consistencyCheckService.runFullConsistencyCheck(this.testDirectory.databaseLayout(), config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), true, checkConsistencyConfig);
    }

    private static StoreIndexDescriptor getIndexDescriptor(IndexDefinition definition) {
        IndexDefinitionImpl indexDefinition = (IndexDefinitionImpl)definition;
        StoreIndexDescriptor indexDescriptor = (StoreIndexDescriptor)indexDefinition.getIndexReference();
        return indexDescriptor;
    }

    private static IndexingService getIndexingService(GraphDatabaseService db) {
        DependencyResolver dependencyResolver = FulltextIndexConsistencyCheckIT.getDependencyResolver(db);
        return (IndexingService)dependencyResolver.resolveDependency(IndexingService.class, DependencyResolver.SelectionStrategy.ONLY);
    }

    private static NeoStores getNeoStores(GraphDatabaseService db) {
        DependencyResolver dependencyResolver = FulltextIndexConsistencyCheckIT.getDependencyResolver(db);
        return ((RecordStorageEngine)dependencyResolver.resolveDependency(RecordStorageEngine.class, DependencyResolver.SelectionStrategy.ONLY)).testAccessNeoStores();
    }

    private static DependencyResolver getDependencyResolver(GraphDatabaseService db) {
        GraphDatabaseAPI api = (GraphDatabaseAPI)db;
        return api.getDependencyResolver();
    }

    private static void assertIsConsistent(ConsistencyCheckService.Result result) throws IOException {
        if (!result.isSuccessful()) {
            FulltextIndexConsistencyCheckIT.printReport(result);
            Assert.fail((String)"Expected consistency check to be successful.");
        }
    }

    private static void printReport(ConsistencyCheckService.Result result) throws IOException {
        Files.readAllLines(result.reportFile().toPath()).forEach(System.err::println);
    }
}

