/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class PartialNodeIndexUpdateIT {
    @Rule
    public DatabaseRule db = new EmbeddedDatabaseRule();

    @Test
    public void partialIndexedNodePropertiesUpdate() {
        GraphDatabaseAPI database = this.db.getGraphDatabaseAPI();
        Label userLabel = Label.label((String)"User");
        try (Transaction transaction = database.beginTx();){
            database.execute("CALL db.index.fulltext.createNodeIndex('test', ['Card', '" + userLabel.name() + "'], ['title', 'plainText', 'username', 'screenName'] )");
            transaction.success();
        }
        String value = "asdf";
        try (Transaction transaction = database.beginTx();){
            database.execute("UNWIND [{_id:48, properties:{screenName:\"asdf\"}}] as row CREATE (n:L1{_id: row._id}) SET n += row.properties SET n:" + userLabel.name());
            transaction.success();
        }
        transaction = database.beginTx();
        var5_7 = null;
        try {
            Assert.assertNotNull((Object)database.findNode(userLabel, "screenName", (Object)"asdf"));
        }
        catch (Throwable throwable) {
            var5_7 = throwable;
            throw throwable;
        }
        finally {
            if (transaction != null) {
                if (var5_7 != null) {
                    try {
                        transaction.close();
                    }
                    catch (Throwable throwable) {
                        var5_7.addSuppressed(throwable);
                    }
                } else {
                    transaction.close();
                }
            }
        }
    }
}

