/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.collections.api.iterator.LongIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.Race;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

@RunWith(value=Parameterized.class)
public class IndexingServiceIntegrationTest {
    private static final String FOOD_LABEL = "food";
    private static final String CLOTHES_LABEL = "clothes";
    private static final String WEATHER_LABEL = "weather";
    private static final String PROPERTY_NAME = "name";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TestDirectory directory = TestDirectory.testDirectory();
    private GraphDatabaseService database;
    @Parameterized.Parameter
    public GraphDatabaseSettings.SchemaIndex schemaIndex;

    @Parameterized.Parameters(name="{0}")
    public static GraphDatabaseSettings.SchemaIndex[] parameters() {
        return GraphDatabaseSettings.SchemaIndex.values();
    }

    @Before
    public void setUp() {
        this.database = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.directory.storeDir()).setConfig(GraphDatabaseSettings.default_schema_provider, this.schemaIndex.providerName()).newGraphDatabase();
        this.createData(this.database, 100);
    }

    @After
    public void tearDown() {
        try {
            this.database.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testManualIndexPopulation() throws InterruptedException, IndexNotFoundKernelException {
        try (org.neo4j.graphdb.Transaction tx = this.database.beginTx();){
            this.database.schema().indexFor(Label.label((String)FOOD_LABEL)).on(PROPERTY_NAME).create();
            tx.success();
        }
        int labelId = this.getLabelId(FOOD_LABEL);
        int propertyKeyId = this.getPropertyKeyId(PROPERTY_NAME);
        IndexingService indexingService = this.getIndexingService(this.database);
        IndexProxy indexProxy = indexingService.getIndexProxy((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyKeyId}));
        this.waitIndexOnline(indexProxy);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
        PopulationProgress progress = indexProxy.getIndexPopulationProgress();
        Assert.assertEquals((long)progress.getCompleted(), (long)progress.getTotal());
    }

    @Test
    public void testManualRelationshipIndexPopulation() throws Exception {
        RelationTypeSchemaDescriptor descriptor;
        try (Transaction tx = ((Kernel)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(Kernel.class)).beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);){
            int foodId = tx.tokenWrite().relationshipTypeGetOrCreateForName(FOOD_LABEL);
            int propertyId = tx.tokenWrite().propertyKeyGetOrCreateForName(PROPERTY_NAME);
            descriptor = SchemaDescriptorFactory.forRelType((int)foodId, (int[])new int[]{propertyId});
            tx.schemaWrite().indexCreate((SchemaDescriptor)descriptor);
            tx.success();
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        IndexProxy indexProxy = indexingService.getIndexProxy((SchemaDescriptor)descriptor);
        this.waitIndexOnline(indexProxy);
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)indexProxy.getState());
        PopulationProgress progress = indexProxy.getIndexPopulationProgress();
        Assert.assertEquals((long)progress.getCompleted(), (long)progress.getTotal());
    }

    @Test
    public void testSchemaIndexMatchIndexingService() throws IndexNotFoundKernelException {
        try (org.neo4j.graphdb.Transaction transaction = this.database.beginTx();){
            this.database.schema().constraintFor(Label.label((String)CLOTHES_LABEL)).assertPropertyIsUnique(PROPERTY_NAME).create();
            this.database.schema().indexFor(Label.label((String)WEATHER_LABEL)).on(PROPERTY_NAME).create();
            transaction.success();
        }
        var2_2 = null;
        try (org.neo4j.graphdb.Transaction ignored = this.database.beginTx();){
            this.database.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        IndexingService indexingService = this.getIndexingService(this.database);
        int clothedLabelId = this.getLabelId(CLOTHES_LABEL);
        int weatherLabelId = this.getLabelId(WEATHER_LABEL);
        int propertyId = this.getPropertyKeyId(PROPERTY_NAME);
        IndexProxy clothesIndex = indexingService.getIndexProxy((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)clothedLabelId, (int[])new int[]{propertyId}));
        IndexProxy weatherIndex = indexingService.getIndexProxy((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)weatherLabelId, (int[])new int[]{propertyId}));
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)clothesIndex.getState());
        Assert.assertEquals((Object)InternalIndexState.ONLINE, (Object)weatherIndex.getState());
    }

    @Test
    public void dropIndexDirectlyOnIndexingServiceRaceWithCheckpoint() throws Throwable {
        IndexingService indexingService = this.getIndexingService(this.database);
        CheckPointer checkPointer = this.getCheckPointer(this.database);
        try (org.neo4j.graphdb.Transaction tx = this.database.beginTx();){
            this.database.schema().indexFor(Label.label((String)"label")).on("prop").create();
            tx.success();
        }
        tx = this.database.beginTx();
        var4_4 = null;
        try {
            this.database.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Race race = new Race();
        race.addContestant(Race.throwing(() -> checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test force"))));
        long indexId = this.oneIndex(indexingService);
        CapableIndexDescriptor indexDescriptor = this.asCapableIndexDescriptor(indexingService, indexId);
        race.addContestant(Race.throwing(() -> indexingService.dropIndex((StoreIndexDescriptor)indexDescriptor)));
        race.go();
    }

    @Test
    public void dropIndexRaceWithCheckpoint() throws Throwable {
        CheckPointer checkPointer = this.getCheckPointer(this.database);
        int nbrOfIndexes = 100;
        try (org.neo4j.graphdb.Transaction tx = this.database.beginTx();){
            for (int i = 0; i < nbrOfIndexes; ++i) {
                this.database.schema().indexFor(Label.label((String)"label")).on("prop" + i).create();
            }
            tx.success();
        }
        tx = this.database.beginTx();
        var4_4 = null;
        try {
            this.database.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            tx.success();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_4 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        AtomicBoolean allIndexesDropped = new AtomicBoolean();
        Race race = new Race();
        race.addContestant(Race.throwing(() -> {
            while (!allIndexesDropped.get()) {
                checkPointer.forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("Test force"));
            }
        }));
        race.addContestant(Race.throwing(() -> {
            try (org.neo4j.graphdb.Transaction tx = this.database.beginTx();){
                this.database.schema().getIndexes().forEach(IndexDefinition::drop);
                tx.success();
            }
            finally {
                allIndexesDropped.set(true);
            }
        }));
        race.go();
    }

    private long oneIndex(IndexingService indexingService) {
        LongIterator indexIds = indexingService.getIndexIds().longIterator();
        Assert.assertTrue((boolean)indexIds.hasNext());
        return indexIds.next();
    }

    private CapableIndexDescriptor asCapableIndexDescriptor(IndexingService indexingService, long indexId) throws IndexNotFoundKernelException {
        IndexProxy indexProxy = indexingService.getIndexProxy(indexId);
        return indexProxy.getDescriptor();
    }

    private void waitIndexOnline(IndexProxy indexProxy) throws InterruptedException {
        while (InternalIndexState.ONLINE != indexProxy.getState()) {
            Thread.sleep(10L);
        }
    }

    private IndexingService getIndexingService(GraphDatabaseService database) {
        return (IndexingService)this.getDependencyResolver(database).resolveDependency(IndexingService.class);
    }

    private CheckPointer getCheckPointer(GraphDatabaseService database) {
        return (CheckPointer)this.getDependencyResolver(database).resolveDependency(CheckPointer.class);
    }

    private DependencyResolver getDependencyResolver(GraphDatabaseService database) {
        return ((GraphDatabaseAPI)database).getDependencyResolver();
    }

    private void createData(GraphDatabaseService database, int numberOfNodes) {
        for (int i = 0; i < numberOfNodes; ++i) {
            try (org.neo4j.graphdb.Transaction transaction = database.beginTx();){
                Node node = database.createNode(new Label[]{Label.label((String)FOOD_LABEL), Label.label((String)CLOTHES_LABEL), Label.label((String)WEATHER_LABEL)});
                node.setProperty(PROPERTY_NAME, (Object)("Node" + i));
                Relationship relationship = node.createRelationshipTo(node, RelationshipType.withName((String)FOOD_LABEL));
                relationship.setProperty(PROPERTY_NAME, (Object)("Relationship" + i));
                transaction.success();
                continue;
            }
        }
    }

    private int getPropertyKeyId(String name) {
        try (org.neo4j.graphdb.Transaction tx = this.database.beginTx();){
            KernelTransaction transaction = ((ThreadToStatementContextBridge)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
            int n = transaction.tokenRead().propertyKey(name);
            return n;
        }
    }

    private int getLabelId(String name) {
        try (org.neo4j.graphdb.Transaction tx = this.database.beginTx();){
            KernelTransaction transaction = ((ThreadToStatementContextBridge)((GraphDatabaseAPI)this.database).getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class)).getKernelTransactionBoundToThisThread(true);
            int n = transaction.tokenRead().nodeLabel(name);
            return n;
        }
    }
}

