/*
 * Decompiled with CFR 0.152.
 */
package schema;

import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.index.IndexActivationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.NodeLabelUpdate;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.SchemaState;
import org.neo4j.kernel.impl.api.index.EntityUpdates;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.IndexingServiceFactory;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageReader;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.transaction.state.DirectIndexUpdates;
import org.neo4j.kernel.impl.transaction.state.IndexUpdates;
import org.neo4j.kernel.impl.transaction.state.storeview.DynamicIndexStoreView;
import org.neo4j.kernel.impl.transaction.state.storeview.EntityIdIterator;
import org.neo4j.kernel.impl.transaction.state.storeview.LabelScanViewNodeStoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.NeoStoreIndexStoreView;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.schema.IndexDescriptorFactory;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class MultiIndexPopulationConcurrentUpdatesIT {
    private static final String NAME_PROPERTY = "name";
    private static final String COUNTRY_LABEL = "country";
    private static final String COLOR_LABEL = "color";
    private static final String CAR_LABEL = "car";
    @Rule
    public EmbeddedDatabaseRule embeddedDatabase = new EmbeddedDatabaseRule();
    private StoreIndexDescriptor[] rules;
    @Parameterized.Parameter
    public GraphDatabaseSettings.SchemaIndex schemaIndex;
    private IndexingService indexService;
    private int propertyId;
    private Map<String, Integer> labelsNameIdMap;
    private Map<Integer, String> labelsIdNameMap;
    private Node country1;
    private Node country2;
    private Node color1;
    private Node color2;
    private Node car1;
    private Node car2;
    private Node[] otherNodes;

    @Parameterized.Parameters(name="{0}")
    public static GraphDatabaseSettings.SchemaIndex[] parameters() {
        return GraphDatabaseSettings.SchemaIndex.values();
    }

    @After
    public void tearDown() throws Throwable {
        if (this.indexService != null) {
            this.indexService.shutdown();
        }
    }

    @Before
    public void setUp() {
        this.prepareDb();
        this.labelsNameIdMap = this.getLabelsNameIdMap();
        this.labelsIdNameMap = this.labelsNameIdMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        this.propertyId = this.getPropertyId();
    }

    @Test
    public void applyConcurrentDeletesToPopulatedIndex() throws Throwable {
        ArrayList<EntityUpdates> updates = new ArrayList<EntityUpdates>(2);
        updates.add(EntityUpdates.forEntity((long)this.country1.getId()).withTokens(this.id(COUNTRY_LABEL)).removed(this.propertyId, Values.of((Object)"Sweden")).build());
        updates.add(EntityUpdates.forEntity((long)this.color2.getId()).withTokens(this.id(COLOR_LABEL)).removed(this.propertyId, Values.of((Object)"green")).build());
        this.launchCustomIndexPopulation(this.labelsNameIdMap, this.propertyId, new UpdateGenerator(updates));
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try (Transaction ignored = this.embeddedDatabase.beginTx();){
            Integer countryLabelId = this.labelsNameIdMap.get(COUNTRY_LABEL);
            Integer colorLabelId = this.labelsNameIdMap.get(COLOR_LABEL);
            try (IndexReader indexReader = this.getIndexReader(this.propertyId, countryLabelId);){
                Assert.assertEquals((String)"Should be removed by concurrent remove.", (long)0L, (long)indexReader.countIndexedNodes(0L, new int[]{this.propertyId}, new Value[]{Values.of((Object)"Sweden")}));
            }
            indexReader = this.getIndexReader(this.propertyId, colorLabelId);
            var7_9 = null;
            try {
                Assert.assertEquals((String)"Should be removed by concurrent remove.", (long)0L, (long)indexReader.countIndexedNodes(3L, new int[]{this.propertyId}, new Value[]{Values.of((Object)"green")}));
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (indexReader != null) {
                    if (var7_9 != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        indexReader.close();
                    }
                }
            }
        }
    }

    @Test
    public void applyConcurrentAddsToPopulatedIndex() throws Throwable {
        ArrayList<EntityUpdates> updates = new ArrayList<EntityUpdates>(2);
        updates.add(EntityUpdates.forEntity((long)this.otherNodes[0].getId()).withTokens(this.id(COUNTRY_LABEL)).added(this.propertyId, Values.of((Object)"Denmark")).build());
        updates.add(EntityUpdates.forEntity((long)this.otherNodes[1].getId()).withTokens(this.id(CAR_LABEL)).added(this.propertyId, Values.of((Object)"BMW")).build());
        this.launchCustomIndexPopulation(this.labelsNameIdMap, this.propertyId, new UpdateGenerator(updates));
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try (Transaction ignored = this.embeddedDatabase.beginTx();){
            Integer countryLabelId = this.labelsNameIdMap.get(COUNTRY_LABEL);
            Integer carLabelId = this.labelsNameIdMap.get(CAR_LABEL);
            try (IndexReader indexReader = this.getIndexReader(this.propertyId, countryLabelId);){
                Assert.assertEquals((String)"Should be added by concurrent add.", (long)1L, (long)indexReader.countIndexedNodes(this.otherNodes[0].getId(), new int[]{this.propertyId}, new Value[]{Values.of((Object)"Denmark")}));
            }
            indexReader = this.getIndexReader(this.propertyId, carLabelId);
            var7_9 = null;
            try {
                Assert.assertEquals((String)"Should be added by concurrent add.", (long)1L, (long)indexReader.countIndexedNodes(this.otherNodes[1].getId(), new int[]{this.propertyId}, new Value[]{Values.of((Object)"BMW")}));
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (indexReader != null) {
                    if (var7_9 != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        indexReader.close();
                    }
                }
            }
        }
    }

    @Test
    public void applyConcurrentChangesToPopulatedIndex() throws Exception {
        ArrayList<EntityUpdates> updates = new ArrayList<EntityUpdates>(2);
        updates.add(EntityUpdates.forEntity((long)this.color2.getId()).withTokens(this.id(COLOR_LABEL)).changed(this.propertyId, Values.of((Object)"green"), Values.of((Object)"pink")).build());
        updates.add(EntityUpdates.forEntity((long)this.car2.getId()).withTokens(this.id(CAR_LABEL)).changed(this.propertyId, Values.of((Object)"Ford"), Values.of((Object)"SAAB")).build());
        this.launchCustomIndexPopulation(this.labelsNameIdMap, this.propertyId, new UpdateGenerator(updates));
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try (Transaction ignored = this.embeddedDatabase.beginTx();){
            Integer colorLabelId = this.labelsNameIdMap.get(COLOR_LABEL);
            Integer carLabelId = this.labelsNameIdMap.get(CAR_LABEL);
            try (IndexReader indexReader = this.getIndexReader(this.propertyId, colorLabelId);){
                Assert.assertEquals((String)String.format("Should be deleted by concurrent change. Reader is: %s, ", indexReader), (long)0L, (long)indexReader.countIndexedNodes(this.color2.getId(), new int[]{this.propertyId}, new Value[]{Values.of((Object)"green")}));
            }
            indexReader = this.getIndexReader(this.propertyId, colorLabelId);
            var7_9 = null;
            try {
                Assert.assertEquals((String)"Should be updated by concurrent change.", (long)1L, (long)indexReader.countIndexedNodes(this.color2.getId(), new int[]{this.propertyId}, new Value[]{Values.of((Object)"pink")}));
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (indexReader != null) {
                    if (var7_9 != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        indexReader.close();
                    }
                }
            }
            indexReader = this.getIndexReader(this.propertyId, carLabelId);
            var7_9 = null;
            try {
                Assert.assertEquals((String)"Should be added by concurrent change.", (long)1L, (long)indexReader.countIndexedNodes(this.car2.getId(), new int[]{this.propertyId}, new Value[]{Values.of((Object)"SAAB")}));
            }
            catch (Throwable throwable) {
                var7_9 = throwable;
                throw throwable;
            }
            finally {
                if (indexReader != null) {
                    if (var7_9 != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable throwable) {
                            var7_9.addSuppressed(throwable);
                        }
                    } else {
                        indexReader.close();
                    }
                }
            }
        }
    }

    @Test
    public void dropOneOfTheIndexesWhilePopulationIsOngoingDoesInfluenceOtherPopulators() throws Exception {
        this.launchCustomIndexPopulation(this.labelsNameIdMap, this.propertyId, new IndexDropAction(this.labelsNameIdMap.get(COLOR_LABEL)));
        this.labelsNameIdMap.remove(COLOR_LABEL);
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        this.checkIndexIsOnline(this.labelsNameIdMap.get(CAR_LABEL));
        this.checkIndexIsOnline(this.labelsNameIdMap.get(COUNTRY_LABEL));
    }

    @Test
    public void indexDroppedDuringPopulationDoesNotExist() throws Exception {
        Integer labelToDropId = this.labelsNameIdMap.get(COLOR_LABEL);
        this.launchCustomIndexPopulation(this.labelsNameIdMap, this.propertyId, new IndexDropAction(labelToDropId));
        this.labelsNameIdMap.remove(COLOR_LABEL);
        this.waitAndActivateIndexes(this.labelsNameIdMap, this.propertyId);
        try {
            this.indexService.getIndexProxy((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelToDropId, (int[])new int[]{this.propertyId}));
            Assert.fail((String)"Index does not exist, we should fail to find it.");
        }
        catch (IndexNotFoundKernelException indexNotFoundKernelException) {
            // empty catch block
        }
    }

    private void checkIndexIsOnline(int labelId) throws IndexNotFoundKernelException {
        IndexProxy indexProxy = this.indexService.getIndexProxy((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{this.propertyId}));
        Assert.assertSame((Object)indexProxy.getState(), (Object)InternalIndexState.ONLINE);
    }

    private long[] id(String label) {
        return new long[]{this.labelsNameIdMap.get(label).intValue()};
    }

    private IndexReader getIndexReader(int propertyId, Integer countryLabelId) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)countryLabelId, (int[])new int[]{propertyId})).newReader();
    }

    private void launchCustomIndexPopulation(Map<String, Integer> labelNameIdMap, int propertyId, Runnable customAction) throws Exception {
        NeoStores neoStores = this.getNeoStores();
        LabelScanStore labelScanStore = this.getLabelScanStore();
        ThreadToStatementContextBridge transactionStatementContextBridge = this.getTransactionStatementContextBridge();
        try (Transaction transaction = this.embeddedDatabase.beginTx();
             KernelTransaction ktx = transactionStatementContextBridge.getKernelTransactionBoundToThisThread(true);){
            DynamicIndexStoreView storeView = this.dynamicIndexStoreViewWrapper(customAction, neoStores, labelScanStore);
            IndexProviderMap providerMap = this.getIndexProviderMap();
            JobScheduler scheduler = this.getJobScheduler();
            SilentTokenNameLookup tokenNameLookup = new SilentTokenNameLookup(ktx.tokenRead());
            NullLogProvider nullLogProvider = NullLogProvider.getInstance();
            this.indexService = IndexingServiceFactory.createIndexingService((Config)Config.defaults(), (JobScheduler)scheduler, (IndexProviderMap)providerMap, (IndexStoreView)storeView, (TokenNameLookup)tokenNameLookup, this.getIndexRules(neoStores), (LogProvider)nullLogProvider, (LogProvider)nullLogProvider, (IndexingService.Monitor)IndexingService.NO_MONITOR, (SchemaState)this.getSchemaState());
            this.indexService.start();
            this.rules = this.createIndexRules(labelNameIdMap, propertyId);
            this.indexService.createIndexes(this.rules);
            transaction.success();
        }
    }

    private DynamicIndexStoreView dynamicIndexStoreViewWrapper(Runnable customAction, NeoStores neoStores, LabelScanStore labelScanStore) {
        LockService locks = LockService.NO_LOCK_SERVICE;
        NeoStoreIndexStoreView neoStoreIndexStoreView = new NeoStoreIndexStoreView(locks, neoStores);
        return new DynamicIndexStoreViewWrapper(neoStoreIndexStoreView, labelScanStore, locks, neoStores, customAction);
    }

    private void waitAndActivateIndexes(Map<String, Integer> labelsIds, int propertyId) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException, InterruptedException, IndexActivationFailedKernelException {
        try (Transaction ignored = this.embeddedDatabase.beginTx();){
            for (int labelId : labelsIds.values()) {
                this.waitIndexOnline(this.indexService, propertyId, labelId);
            }
        }
    }

    private int getPropertyId() {
        try (Transaction ignored = this.embeddedDatabase.beginTx();){
            int n = this.getPropertyIdByName(NAME_PROPERTY);
            return n;
        }
    }

    private Map<String, Integer> getLabelsNameIdMap() {
        try (Transaction ignored = this.embeddedDatabase.beginTx();){
            Map<String, Integer> map = this.getLabelIdsByName(COUNTRY_LABEL, COLOR_LABEL, CAR_LABEL);
            return map;
        }
    }

    private void waitIndexOnline(IndexingService indexService, int propertyId, int labelId) throws IndexNotFoundKernelException, IndexPopulationFailedKernelException, InterruptedException, IndexActivationFailedKernelException {
        IndexProxy indexProxy = indexService.getIndexProxy((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{propertyId}));
        indexProxy.awaitStoreScanCompleted(0L, TimeUnit.MILLISECONDS);
        while (indexProxy.getState() != InternalIndexState.ONLINE) {
            Thread.sleep(10L);
        }
        indexProxy.activate();
    }

    private StoreIndexDescriptor[] createIndexRules(Map<String, Integer> labelNameIdMap, int propertyId) {
        IndexProvider lookup = this.getIndexProviderMap().lookup(this.schemaIndex.providerName());
        IndexProviderDescriptor providerDescriptor = lookup.getProviderDescriptor();
        return (StoreIndexDescriptor[])labelNameIdMap.values().stream().map(index -> IndexDescriptorFactory.forSchema((SchemaDescriptor)SchemaDescriptorFactory.forLabel((int)index, (int[])new int[]{propertyId}), (IndexProviderDescriptor)providerDescriptor).withId((long)index.intValue())).toArray(StoreIndexDescriptor[]::new);
    }

    private List<StoreIndexDescriptor> getIndexRules(NeoStores neoStores) {
        return Iterators.asList((Iterator)new SchemaStorage((RecordStore)neoStores.getSchemaStore()).indexesGetAll());
    }

    private Map<String, Integer> getLabelIdsByName(String ... names) {
        ThreadToStatementContextBridge transactionStatementContextBridge = this.getTransactionStatementContextBridge();
        HashMap<String, Integer> labelNameIdMap = new HashMap<String, Integer>();
        KernelTransaction ktx = transactionStatementContextBridge.getKernelTransactionBoundToThisThread(true);
        try (Statement ignore = ktx.acquireStatement();){
            TokenRead tokenRead = ktx.tokenRead();
            for (String name : names) {
                labelNameIdMap.put(name, tokenRead.nodeLabel(name));
            }
        }
        return labelNameIdMap;
    }

    private int getPropertyIdByName(String name) {
        ThreadToStatementContextBridge transactionStatementContextBridge = this.getTransactionStatementContextBridge();
        KernelTransaction ktx = transactionStatementContextBridge.getKernelTransactionBoundToThisThread(true);
        try (Statement ignore = ktx.acquireStatement();){
            int n = ktx.tokenRead().propertyKey(name);
            return n;
        }
    }

    private void prepareDb() {
        Label countryLabel = Label.label((String)COUNTRY_LABEL);
        Label color = Label.label((String)COLOR_LABEL);
        Label car = Label.label((String)CAR_LABEL);
        try (Transaction transaction = this.embeddedDatabase.beginTx();){
            this.country1 = this.createNamedLabeledNode(countryLabel, "Sweden");
            this.country2 = this.createNamedLabeledNode(countryLabel, "USA");
            this.color1 = this.createNamedLabeledNode(color, "red");
            this.color2 = this.createNamedLabeledNode(color, "green");
            this.car1 = this.createNamedLabeledNode(car, "Volvo");
            this.car2 = this.createNamedLabeledNode(car, "Ford");
            this.otherNodes = new Node[250];
            for (int i = 0; i < 250; ++i) {
                this.otherNodes[i] = this.embeddedDatabase.createNode();
            }
            transaction.success();
        }
    }

    private Node createNamedLabeledNode(Label label, String name) {
        Node node = this.embeddedDatabase.createNode(new Label[]{label});
        node.setProperty(NAME_PROPERTY, (Object)name);
        return node;
    }

    private LabelScanStore getLabelScanStore() {
        return (LabelScanStore)this.embeddedDatabase.resolveDependency(LabelScanStore.class);
    }

    private NeoStores getNeoStores() {
        RecordStorageEngine recordStorageEngine = (RecordStorageEngine)this.embeddedDatabase.resolveDependency(RecordStorageEngine.class);
        return recordStorageEngine.testAccessNeoStores();
    }

    private SchemaState getSchemaState() {
        return (SchemaState)this.embeddedDatabase.resolveDependency(SchemaState.class);
    }

    private ThreadToStatementContextBridge getTransactionStatementContextBridge() {
        return (ThreadToStatementContextBridge)this.embeddedDatabase.resolveDependency(ThreadToStatementContextBridge.class);
    }

    private IndexProviderMap getIndexProviderMap() {
        return (IndexProviderMap)this.embeddedDatabase.resolveDependency(IndexProviderMap.class);
    }

    private JobScheduler getJobScheduler() {
        return (JobScheduler)this.embeddedDatabase.resolveDependency(JobScheduler.class);
    }

    private class IndexDropAction
    implements Runnable {
        private int labelIdToDropIndexFor;

        private IndexDropAction(int labelIdToDropIndexFor) {
            this.labelIdToDropIndexFor = labelIdToDropIndexFor;
        }

        @Override
        public void run() {
            LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel((int)this.labelIdToDropIndexFor, (int[])new int[]{MultiIndexPopulationConcurrentUpdatesIT.this.propertyId});
            StoreIndexDescriptor rule = this.findRuleForLabel((org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor)descriptor);
            MultiIndexPopulationConcurrentUpdatesIT.this.indexService.dropIndex(rule);
        }

        private StoreIndexDescriptor findRuleForLabel(org.neo4j.internal.kernel.api.schema.LabelSchemaDescriptor schemaDescriptor) {
            for (StoreIndexDescriptor rule : MultiIndexPopulationConcurrentUpdatesIT.this.rules) {
                if (!rule.schema().equals(schemaDescriptor)) continue;
                return rule;
            }
            return null;
        }
    }

    private class UpdateGenerator
    implements Runnable {
        private Iterable<EntityUpdates> updates;

        UpdateGenerator(Iterable<EntityUpdates> updates) {
            this.updates = updates;
        }

        @Override
        public void run() {
            for (EntityUpdates update : this.updates) {
                Transaction transaction = MultiIndexPopulationConcurrentUpdatesIT.this.embeddedDatabase.beginTx();
                Throwable throwable = null;
                try {
                    Node node = MultiIndexPopulationConcurrentUpdatesIT.this.embeddedDatabase.getNodeById(update.getEntityId());
                    Iterator iterator = MultiIndexPopulationConcurrentUpdatesIT.this.labelsNameIdMap.values().iterator();
                    while (iterator.hasNext()) {
                        int labelId = (Integer)iterator.next();
                        LabelSchemaDescriptor schema = SchemaDescriptorFactory.forLabel((int)labelId, (int[])new int[]{MultiIndexPopulationConcurrentUpdatesIT.this.propertyId});
                        block17: for (IndexEntryUpdate indexUpdate : update.forIndexKeys(Collections.singleton(schema))) {
                            switch (indexUpdate.updateMode()) {
                                case CHANGED: 
                                case ADDED: {
                                    node.addLabel(Label.label((String)((String)MultiIndexPopulationConcurrentUpdatesIT.this.labelsIdNameMap.get(schema.getLabelId()))));
                                    node.setProperty(MultiIndexPopulationConcurrentUpdatesIT.NAME_PROPERTY, indexUpdate.values()[0].asObject());
                                    continue block17;
                                }
                                case REMOVED: {
                                    node.addLabel(Label.label((String)((String)MultiIndexPopulationConcurrentUpdatesIT.this.labelsIdNameMap.get(schema.getLabelId()))));
                                    node.delete();
                                    continue block17;
                                }
                            }
                            throw new IllegalArgumentException(indexUpdate.updateMode().name());
                        }
                    }
                    transaction.success();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (transaction == null) continue;
                    if (throwable != null) {
                        try {
                            transaction.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    transaction.close();
                }
            }
            try {
                for (EntityUpdates update : this.updates) {
                    Iterable entryUpdates = MultiIndexPopulationConcurrentUpdatesIT.this.indexService.convertToIndexUpdates(update, EntityType.NODE);
                    DirectIndexUpdates directIndexUpdates = new DirectIndexUpdates(entryUpdates);
                    MultiIndexPopulationConcurrentUpdatesIT.this.indexService.apply((IndexUpdates)directIndexUpdates);
                }
            }
            catch (UncheckedIOException | IndexEntryConflictException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class DelegatingEntityIdIterator
    implements EntityIdIterator {
        private final Runnable customAction;
        private final EntityIdIterator delegate;

        DelegatingEntityIdIterator(EntityIdIterator delegate, Runnable customAction) {
            this.delegate = delegate;
            this.customAction = customAction;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public long next() {
            long value = this.delegate.next();
            if (!this.hasNext()) {
                this.customAction.run();
            }
            return value;
        }

        public void close() {
            this.delegate.close();
        }

        public void invalidateCache() {
            this.delegate.invalidateCache();
        }
    }

    private class LabelScanViewNodeStoreWrapper<FAILURE extends Exception>
    extends LabelScanViewNodeStoreScan<FAILURE> {
        private final LabelScanViewNodeStoreScan<FAILURE> delegate;
        private final Runnable customAction;

        LabelScanViewNodeStoreWrapper(StorageReader storageReader, LockService locks, LabelScanStore labelScanStore, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, int[] labelIds, IntPredicate propertyKeyIdFilter, LabelScanViewNodeStoreScan<FAILURE> delegate, Runnable customAction) {
            super(storageReader, locks, labelScanStore, labelUpdateVisitor, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter);
            this.delegate = delegate;
            this.customAction = customAction;
        }

        public EntityIdIterator getEntityIdIterator() {
            EntityIdIterator originalIterator = this.delegate.getEntityIdIterator();
            return new DelegatingEntityIdIterator(originalIterator, this.customAction);
        }
    }

    private class DynamicIndexStoreViewWrapper
    extends DynamicIndexStoreView {
        private final Runnable customAction;
        private final NeoStores neoStores;

        DynamicIndexStoreViewWrapper(NeoStoreIndexStoreView neoStoreIndexStoreView, LabelScanStore labelScanStore, LockService locks, NeoStores neoStores, Runnable customAction) {
            super(neoStoreIndexStoreView, labelScanStore, locks, neoStores, (LogProvider)NullLogProvider.getInstance());
            this.customAction = customAction;
            this.neoStores = neoStores;
        }

        public <FAILURE extends Exception> StoreScan<FAILURE> visitNodes(int[] labelIds, IntPredicate propertyKeyIdFilter, Visitor<EntityUpdates, FAILURE> propertyUpdatesVisitor, Visitor<NodeLabelUpdate, FAILURE> labelUpdateVisitor, boolean forceStoreScan) {
            StoreScan storeScan = super.visitNodes(labelIds, propertyKeyIdFilter, propertyUpdatesVisitor, labelUpdateVisitor, forceStoreScan);
            return new LabelScanViewNodeStoreWrapper<FAILURE>((StorageReader)new RecordStorageReader(this.neoStores), this.locks, MultiIndexPopulationConcurrentUpdatesIT.this.getLabelScanStore(), element -> false, propertyUpdatesVisitor, labelIds, propertyKeyIdFilter, (LabelScanViewNodeStoreScan)storeScan, this.customAction);
        }
    }
}

